/*
 * Decompiled with CFR 0.152.
 */
package com.inet.shared.utils;

import com.inet.logging.LogManager;
import com.inet.shared.utils.BlendComposite;
import com.inet.shared.utils.LayerGraphics2D;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;

public class GraphicLayer {
    private final Rectangle2D b;
    private final boolean c;
    private final boolean d;
    private BufferedImage e;
    private Graphics2D f;
    private BlendComposite g;
    private Graphics2D h;
    private BufferedImage i;
    private BufferedImage j;
    AffineTransform a = new AffineTransform();

    public Rectangle2D getImgBounds() {
        return this.b;
    }

    GraphicLayer(Rectangle2D imgBounds, boolean knockout, boolean isolate) {
        this.b = imgBounds;
        this.c = knockout;
        this.d = isolate;
    }

    GraphicLayer(BufferedImage backdropImage, BlendComposite composite, Graphics2D baseGraphics, Rectangle2D imgBounds, boolean knockout, boolean isolate, AffineTransform initialTransformation) {
        this(imgBounds, knockout, isolate);
        this.h = (Graphics2D)baseGraphics.create();
        this.a = baseGraphics.getTransform();
        this.e = backdropImage;
        this.g = composite;
        this.g.setBackdrop(backdropImage);
        if (composite.getMask() != null) {
            this.g = GraphicLayer.a(composite, imgBounds, baseGraphics, initialTransformation);
        }
    }

    public AffineTransform getPreviousLayerTransformation() {
        return new AffineTransform(this.a);
    }

    private static BlendComposite a(BlendComposite blendComposite, Rectangle2D rectangle2D, Graphics2D graphics2D, AffineTransform affineTransform) {
        if (blendComposite.getMask() != null) {
            BufferedImage bufferedImage = new BufferedImage((int)Math.round(rectangle2D.getWidth()), (int)Math.round(rectangle2D.getHeight()), 2);
            Graphics2D graphics2D2 = bufferedImage.createGraphics();
            LayerGraphics2D.copyGraphicSettings(graphics2D, graphics2D2);
            graphics2D2.transform(affineTransform);
            graphics2D2.drawImage((Image)blendComposite.getMask(), 0, 0, null);
            graphics2D2.dispose();
            BlendComposite blendComposite2 = new BlendComposite(blendComposite.getMode(), blendComposite.getAlpha(), bufferedImage);
            blendComposite2.setBackdrop(blendComposite.getBackdrop());
            return blendComposite2;
        }
        return blendComposite;
    }

    public BlendComposite getComposite() {
        return this.g;
    }

    void a(Composite composite) {
        if (composite instanceof BlendComposite) {
            BlendComposite blendComposite = (BlendComposite)composite;
            blendComposite.setBackdrop(this.e);
        }
        this.a(false).setComposite(composite);
    }

    BufferedImage a() {
        this.g.setBackdrop(this.e);
        return this.i;
    }

    BufferedImage b() {
        if (this.c) {
            return this.e;
        }
        if (this.d) {
            return this.i;
        }
        if (this.j == null) {
            this.j = new BufferedImage(this.e.getWidth(), this.e.getHeight(), 2);
        }
        Graphics2D graphics2D = this.j.createGraphics();
        graphics2D.setColor(new Color(0, 0, 0, 0));
        graphics2D.fillRect(0, 0, this.e.getWidth(), this.e.getHeight());
        graphics2D.drawImage((Image)this.e, 0, 0, null);
        graphics2D.drawImage((Image)this.a(), 0, 0, null);
        graphics2D.dispose();
        return this.j;
    }

    Graphics2D a(boolean bl) {
        if (this.f == null) {
            this.i = new BufferedImage(this.e.getWidth(), this.e.getHeight(), 2);
            this.f = this.i.createGraphics();
            LayerGraphics2D.copyGraphicSettings(this.h, this.f);
        }
        if (bl && this.f.getComposite() instanceof BlendComposite) {
            ((BlendComposite)this.f.getComposite()).setBackdropProvider(() -> this.b());
        }
        return this.f;
    }

    void a(GraphicLayer graphicLayer) {
        Object object;
        BufferedImage bufferedImage = graphicLayer.a();
        Graphics2D graphics2D = this.a(true);
        Shape shape = graphics2D.getClip();
        AffineTransform affineTransform = graphics2D.getTransform();
        try {
            object = affineTransform.createInverse();
            graphics2D.transform((AffineTransform)object);
            graphics2D.setClip(affineTransform.createTransformedShape(shape));
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            LogManager.getApplicationLogger().error(noninvertibleTransformException);
        }
        object = graphics2D.getComposite();
        graphicLayer.getComposite().setBackdropProvider(() -> this.b());
        graphics2D.setComposite(graphicLayer.getComposite());
        graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
        graphics2D.setClip(shape);
        graphics2D.transform(affineTransform);
        graphics2D.setComposite((Composite)object);
    }

    GraphicLayer c() {
        GraphicLayer graphicLayer = new GraphicLayer(this.b, this.c, this.d);
        graphicLayer.f = (Graphics2D)this.a(false).create();
        graphicLayer.e = this.e;
        graphicLayer.i = this.i;
        graphicLayer.g = this.g;
        return graphicLayer;
    }

    void d() {
        this.f = (Graphics2D)this.f.create();
    }

    public String toString() {
        return "GraphicLayer{imgBounds=" + String.valueOf(this.b) + ", knockout=" + this.c + ", isolate=" + this.d + ", composite=" + String.valueOf(this.g) + ", transformation=" + String.valueOf(this.a(false).getTransform()) + "}";
    }
}

