/*
 * Decompiled with CFR 0.152.
 */
package com.inet.search.tokenizers;

import com.inet.annotations.InternalApi;
import com.inet.search.tokenizers.SearchTokenizer;
import com.inet.search.utils.UmlautsUtils;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@InternalApi
public class TextSearchTokenizer
implements SearchTokenizer {
    private static final Pattern a = Pattern.compile("[\\s\u00a0\u0000\u0001\u0002\u0003\u0004\u0005\u0006\u0007\b\u0015\u0018\u0019\u001a\u001e]");
    @Nonnull
    public static final TextSearchTokenizer DEFAULT = new TextSearchTokenizer();

    protected TextSearchTokenizer() {
    }

    @Override
    @Nonnull
    public Set<String> tokens(@Nullable Object value, int type) {
        if (value == null) {
            return Collections.emptySet();
        }
        HashSet<String> hashSet = new HashSet<String>();
        this.addTo(hashSet, value.toString(), type);
        return this.normalize(hashSet);
    }

    public void addTo(@Nonnull Set<String> result, @Nonnull String value, int type) {
        for (String string : a.split(value)) {
            int n2;
            boolean bl = false;
            int n3 = string.length();
            if (n3 == 0) continue;
            if ((type & 1) > 0) {
                n2 = 0;
                for (int i2 = 0; i2 < n3; ++i2) {
                    char c2 = string.charAt(i2);
                    if (!this.isDelimiter(c2)) continue;
                    if (i2 > n2) {
                        result.add(string.substring(n2, i2));
                    }
                    n2 = i2 + 1;
                    if (c2 != '-') continue;
                    bl = true;
                }
                if (n2 < n3) {
                    result.add(string.substring(n2, n3));
                }
            }
            if ((type & 2) > 0) {
                while (n3 > 0 && this.isDelimiter(string.charAt(n3 - 1))) {
                    --n3;
                }
                for (n2 = 0; n2 < n3 && this.isDelimiter(string.charAt(n2)); ++n2) {
                }
                if (n2 < n3) {
                    result.add(string.substring(n2, n3));
                }
            }
            if (!bl || type != 3) continue;
            this.addTo(result, string.replace("-", ""), type);
        }
    }

    protected boolean isDelimiter(char ch) {
        return "\u00a0 .!?_<>\u00a7$%&,:#'\u00b4`^|+*~\"/\\()[]={};@-".indexOf(ch) >= 0;
    }

    @Nonnull
    protected Set<String> normalize(Set<String> result) {
        if (result.isEmpty()) {
            return result;
        }
        Iterator<String> iterator = result.iterator();
        result = new HashSet<String>();
        while (iterator.hasNext()) {
            String string = iterator.next().trim();
            if (string.isEmpty()) continue;
            result.add(string);
            result.add(UmlautsUtils.flattenToAscii(string));
            result.add(UmlautsUtils.replaceUmlauts(string));
        }
        return result;
    }
}

