/*
 * Decompiled with CFR 0.152.
 */
package com.inet.persistence;

import com.inet.annotations.InternalApi;
import com.inet.error.ErrorCode;
import com.inet.lib.util.EncodingFunctions;
import com.inet.persistence.RandomAccessRead;
import com.inet.persistence.StorageEntry;
import com.inet.persistence.crypto.CryptoPersistenceEntry;
import com.inet.persistence.spi.PersistenceHelper;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@InternalApi
public abstract class PersistenceEntry
extends StorageEntry {
    public static final char PERSISTENCE_ENTRY_SEPARATOR = '/';

    @Nonnull
    public String toString() {
        return this.getPath();
    }

    public boolean equals(@Nullable Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        return this.getPath().equals(((PersistenceEntry)obj).getPath());
    }

    public int hashCode() {
        return this.getPath().hashCode();
    }

    @Override
    @Nonnull
    public abstract String getPath();

    @Override
    @Nonnull
    public String getName() {
        return PersistenceHelper.getName(this.getPath());
    }

    @Nonnull
    public abstract PersistenceEntry resolve(@Nonnull String var1) throws NullPointerException, IllegalArgumentException;

    @Override
    @Nullable
    public abstract PersistenceEntry getParent();

    @Nonnull
    public PersistenceEntry getCryptoInstance(char[] password, byte @Nonnull [] salt) throws IllegalStateException {
        return new CryptoPersistenceEntry(this, password, salt);
    }

    @Override
    @Nullable
    public abstract RandomAccessRead getRandomAccessRead();

    @Override
    public abstract boolean exists();

    @Nonnull
    public abstract @Nonnull List<@Nonnull PersistenceEntry> getChildren();

    public long searchCount(@Nonnull String pattern) {
        long l2 = 0L;
        Iterator<PersistenceEntry> iterator = this.search(pattern).iterator();
        while (iterator.hasNext()) {
            iterator.next();
            ++l2;
        }
        return l2;
    }

    @Nonnull
    public Iterable<PersistenceEntry> search(@Nonnull String pattern) {
        return () -> this.walk(pattern).iterator();
    }

    @Nonnull
    public Stream<PersistenceEntry> walk(@Nonnull String pattern) {
        return StreamSupport.stream(this.search(pattern).spliterator(), false);
    }

    public Stream<PersistenceEntry> walk() {
        return this.walk("*");
    }

    @Nullable
    public abstract String getString();

    public abstract void setString(@Nonnull String var1) throws NullPointerException;

    public abstract byte @Nullable [] getBytes();

    public abstract void setBytes(byte @Nonnull [] var1) throws NullPointerException;

    @Override
    @Nullable
    public abstract InputStream getInputStream();

    public abstract void setInputStream(@Nonnull InputStream var1) throws NullPointerException;

    @Nonnull
    public abstract OutputStream getOutputStream();

    @Override
    public abstract long size();

    @Override
    @Nonnull
    public URL toURL() {
        try {
            return new URL("persistence", "", EncodingFunctions.encodeUrlPath(this.getPath()));
        }
        catch (MalformedURLException malformedURLException) {
            ErrorCode.throwAny(malformedURLException);
            return null;
        }
    }

    @Override
    public abstract void deleteTree();

    public abstract void deleteValue();

    @Override
    public abstract long lastModified();

    public abstract void moveTo(@Nonnull String var1) throws IllegalStateException, IllegalArgumentException;
}

