/*
 * Decompiled with CFR 0.152.
 */
package com.inet.permissions.url;

import com.inet.id.GUID;
import com.inet.lib.io.UTF8StreamWriter;
import com.inet.lib.json.Json;
import com.inet.lib.json.JsonException;
import com.inet.lib.util.IOFunctions;
import com.inet.logging.LogManager;
import com.inet.permissions.url.EntryList;
import com.inet.permissions.url.GroupsJsonObject;
import com.inet.permissions.url.PermissionUrlObject;
import com.inet.permissions.url.PermissionsJsonObject;
import com.inet.permissions.url.UsersJsonObject;
import com.inet.permissions.url.legacy.OldPermissionUrlObject;
import com.inet.plugin.ServerPluginManager;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.groups.GroupType;
import com.inet.usersandgroups.api.groups.MutableUserGroupData;
import com.inet.usersandgroups.api.groups.UserGroupInfo;
import com.inet.usersandgroups.api.groups.UserGroupKey;
import com.inet.usersandgroups.api.groups.UserGroupManager;
import com.inet.usersandgroups.api.user.LoginSettings;
import com.inet.usersandgroups.api.user.MutableUserData;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserAccountType;
import com.inet.usersandgroups.api.user.UserManager;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URL;
import java.net.URLConnection;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.SuppressFBWarnings;

public class PermissionJsonUtils {
    private static final String GROUP_NAME_SEPARATOR = "||";
    private static final boolean createUsers = !"helpdesk".equals(ServerPluginManager.getInstance().getCorePluginId());
    public static final String INET_PERMISSIONS_NAME = ".inet.permissions";

    public static String writePermission(PermissionUrlObject permissionUrlObject) {
        Object object;
        int n2;
        PermissionsJsonObject permissionsJsonObject = new PermissionsJsonObject();
        for (GUID gUID : permissionUrlObject.getUserIds()) {
            n2 = permissionUrlObject.getUserPermission(gUID);
            object = new UsersJsonObject();
            ((UsersJsonObject)object).id = gUID;
            ((UsersJsonObject)object).setPermission(n2);
            permissionsJsonObject.addUsers((UsersJsonObject)object);
        }
        for (GUID gUID : permissionUrlObject.getRoleIds()) {
            n2 = permissionUrlObject.getRolePermission(gUID);
            object = new GroupsJsonObject();
            ((GroupsJsonObject)object).id = gUID;
            ((GroupsJsonObject)object).setPermission(n2);
            permissionsJsonObject.addGroups((GroupsJsonObject)object);
        }
        return new Json().toJson(permissionsJsonObject);
    }

    public static EntryList readPermission(String permissions) {
        EntryList entryList = new EntryList();
        PermissionsJsonObject permissionsJsonObject = new Json().fromJson(permissions, PermissionsJsonObject.class);
        for (UsersJsonObject object : permissionsJsonObject.getUsers()) {
            entryList.addUserPermission(object.id, object.getPermission());
        }
        for (GroupsJsonObject groupsJsonObject : permissionsJsonObject.getGroups()) {
            entryList.addGroupPermission(groupsJsonObject.id, groupsJsonObject.getPermission());
        }
        return entryList;
    }

    public static PermissionUrlObject read(String s) throws JsonException {
        PermissionUrlObject permissionUrlObject = new PermissionUrlObject();
        PermissionsJsonObject permissionsJsonObject = new Json().fromJson(s, PermissionsJsonObject.class);
        for (UsersJsonObject object : permissionsJsonObject.getUsers()) {
            permissionUrlObject.addUserPermission(object.id, object.getPermission());
        }
        for (GroupsJsonObject groupsJsonObject : permissionsJsonObject.getGroups()) {
            permissionUrlObject.addRolePermission(groupsJsonObject.id, groupsJsonObject.getPermission());
        }
        return permissionUrlObject;
    }

    public static void writePermission(PermissionUrlObject permissionObj, URL url) throws IOException {
        PermissionJsonUtils.writePermission(permissionObj, url, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"URLCONNECTION_SSRF_FD"}, justification="Caller must check that only save URLs are used")
    public static void writePermission(PermissionUrlObject permissionObj, URL url, boolean deleteEmptyPermissions) throws IOException {
        if (permissionObj == null || url == null) {
            return;
        }
        if (url.toString().endsWith("/")) {
            url = new URL(url.toString() + INET_PERMISSIONS_NAME);
        }
        try (OutputStream outputStream = null;){
            Object object;
            if (url.getProtocol().equals("file")) {
                object = IOFunctions.getFile(url);
                if (deleteEmptyPermissions && permissionObj.isEmpty()) {
                    ((File)object).delete();
                    return;
                }
                outputStream = new FileOutputStream((File)object);
            } else {
                object = url.openConnection();
                ((URLConnection)object).setDoOutput(true);
                outputStream = ((URLConnection)object).getOutputStream();
            }
            object = new UTF8StreamWriter(new BufferedOutputStream(outputStream));
            try (PrintWriter printWriter = new PrintWriter((Writer)object);){
                String string = PermissionJsonUtils.writePermission(permissionObj);
                printWriter.write(string);
            }
            finally {
                ((UTF8StreamWriter)object).close();
            }
        }
    }

    public static PermissionUrlObject read(InputStream stream) {
        PermissionsJsonObject permissionsJsonObject;
        PermissionUrlObject permissionUrlObject;
        block5: {
            permissionUrlObject = new PermissionUrlObject();
            permissionsJsonObject = null;
            try {
                permissionsJsonObject = new Json().fromJson(stream, PermissionsJsonObject.class);
            }
            catch (IOException iOException) {
                if (!LogManager.getApplicationLogger().isWarning()) break block5;
                LogManager.getApplicationLogger().warn(iOException);
            }
        }
        if (permissionsJsonObject != null) {
            for (UsersJsonObject object : permissionsJsonObject.getUsers()) {
                permissionUrlObject.addUserPermission(object.id, object.getPermission());
            }
            for (GroupsJsonObject groupsJsonObject : permissionsJsonObject.getGroups()) {
                permissionUrlObject.addRolePermission(groupsJsonObject.id, groupsJsonObject.getPermission());
            }
        }
        return permissionUrlObject;
    }

    public static PermissionUrlObject convertOldPermission(OldPermissionUrlObject oldUrlPermissions) {
        String[] stringArray;
        PermissionUrlObject permissionUrlObject = new PermissionUrlObject();
        UserManager userManager = UserManager.getInstance();
        for (String string : stringArray = oldUrlPermissions.getPatterns()) {
            int n2;
            String[] stringArray2;
            if (!string.equals("*") && !string.startsWith("*.")) continue;
            String[] stringArray3 = stringArray2 = oldUrlPermissions.getUserNames(string);
            int n3 = stringArray3.length;
            for (n2 = 0; n2 < n3; ++n2) {
                Object object;
                String string2 = stringArray3[n2];
                int n4 = oldUrlPermissions.getUserPermission(string, string2);
                if (string2.equals("*")) {
                    object = UsersAndGroups.GROUPID_ALLUSERS;
                    int n5 = permissionUrlObject.getRolePermission((GUID)object);
                    permissionUrlObject.addRolePermission((GUID)object, n5 | n4);
                    continue;
                }
                object = userManager.findActiveUserAccount("system", string2);
                if (object == null) {
                    if (!createUsers) continue;
                    object = userManager.createUserAccount(UserAccountType.Standard, new MutableUserData(), new LoginSettings("system", string2, null));
                }
                GUID gUID = ((UserAccount)object).getID();
                int n6 = permissionUrlObject.getUserPermission(gUID);
                permissionUrlObject.addUserPermission(gUID, n6 | n4);
            }
            String[] stringArray4 = stringArray3 = oldUrlPermissions.getRoleNames(string);
            n2 = stringArray4.length;
            block14: for (int i2 = 0; i2 < n2; ++i2) {
                String string3 = stringArray4[i2];
                int n7 = oldUrlPermissions.getRolePermission(string, string3);
                String string4 = "";
                if (string3.indexOf(GROUP_NAME_SEPARATOR) > -1) {
                    string4 = string3.substring(0, string3.indexOf(GROUP_NAME_SEPARATOR)).toLowerCase();
                    string3 = string3.substring(string3.indexOf(GROUP_NAME_SEPARATOR) + GROUP_NAME_SEPARATOR.length());
                }
                UserGroupManager userGroupManager = UserGroupManager.getInstance();
                Consumer<UserGroupKey> consumer = userGroupKey -> {
                    block2: {
                        try {
                            UserGroupInfo userGroupInfo = userGroupManager.getGroup((UserGroupKey)userGroupKey);
                            GUID gUID = userGroupInfo == null ? userGroupManager.createGroup(userGroupKey.getName(), userGroupKey.getType(), new MutableUserGroupData()) : userGroupInfo.getID();
                            int n3 = permissionUrlObject.getRolePermission(gUID);
                            permissionUrlObject.addRolePermission(gUID, n3 | n7);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            if (!LogManager.getApplicationLogger().isWarning()) break block2;
                            LogManager.getApplicationLogger().warn(illegalArgumentException);
                        }
                    }
                };
                switch (string4) {
                    case "": {
                        if (string3.equalsIgnoreCase("*")) {
                            consumer.accept(UsersAndGroups.GROUP_ALLUSERS);
                            continue block14;
                        }
                        consumer.accept(UserGroupKey.of(string3, UsersAndGroups.GROUPTYPE_AUTH));
                        continue block14;
                    }
                    case "helpdesk": {
                        consumer.accept(UserGroupKey.of(string3, UsersAndGroups.GROUPTYPE_STANDARD));
                        continue block14;
                    }
                    case "resource": {
                        GroupType groupType = GroupType.of(string4);
                        UserGroupKey userGroupKey2 = UserGroupKey.of(string3, groupType);
                        Set<UserGroupInfo> set = userGroupManager.getGroups(groupType);
                        for (UserGroupInfo userGroupInfo : set) {
                            if (!userGroupKey2.equals(userGroupInfo.getGroupKey()) || userGroupInfo.hasParent()) continue;
                            try {
                                int n8 = permissionUrlObject.getRolePermission(userGroupInfo.getID());
                                permissionUrlObject.addRolePermission(userGroupInfo.getID(), n8 | n7);
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                if (!LogManager.getApplicationLogger().isWarning()) continue;
                                LogManager.getApplicationLogger().warn(illegalArgumentException);
                            }
                        }
                        continue block14;
                    }
                    default: {
                        consumer.accept(UserGroupKey.of(string3, GroupType.of(string4)));
                    }
                }
            }
        }
        return permissionUrlObject;
    }

    public static final class PERMISSION_TYPES
    extends Enum<PERMISSION_TYPES> {
        public static final /* enum */ PERMISSION_TYPES EXECUTE = new PERMISSION_TYPES(1);
        public static final /* enum */ PERMISSION_TYPES WRITE = new PERMISSION_TYPES(2);
        public static final /* enum */ PERMISSION_TYPES READ = new PERMISSION_TYPES(4);
        private int a;
        private static final /* synthetic */ PERMISSION_TYPES[] b;

        public static PERMISSION_TYPES[] values() {
            return (PERMISSION_TYPES[])b.clone();
        }

        public static PERMISSION_TYPES valueOf(String name) {
            return Enum.valueOf(PERMISSION_TYPES.class, name);
        }

        private PERMISSION_TYPES(int bitmask) {
            this.a = bitmask;
        }

        public int getBitValue() {
            return this.a;
        }

        private static /* synthetic */ PERMISSION_TYPES[] a() {
            return new PERMISSION_TYPES[]{EXECUTE, WRITE, READ};
        }

        static {
            b = PERMISSION_TYPES.a();
        }
    }
}

