/*
 * Decompiled with CFR 0.152.
 */
package com.inet.logging;

import com.inet.annotations.InternalApi;
import com.inet.logging.DefaultLogger;
import com.inet.logging.FormattedLogStream;
import com.inet.logging.LogBuffer;
import com.inet.logging.LogFileArchiver;
import com.inet.logging.LogID;
import com.inet.logging.LogLevel;
import com.inet.logging.Logger;
import com.inet.logging.LoggingAppender;
import com.inet.logging.LoggingEvent;
import com.inet.logging.SourceDescription;
import com.inet.logging.SourceFactory;
import com.inet.logging.StaticInit;
import com.inet.logging.StaticLogger;
import com.inet.logging.TraceCounter;
import com.inet.plugin.ServerPluginManager;
import com.inet.thread.ThreadUtils;
import com.sun.management.OperatingSystemMXBean;
import java.io.PrintStream;
import java.lang.management.ManagementFactory;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ForkJoinPool;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@InternalApi
public class LogManager
extends StaticInit {
    private static final Map<String, Logger> a = new ConcurrentHashMap<String, Logger>();
    private static final List<LoggingAppender> b = new ArrayList<LoggingAppender>();
    private static LoggingAppender[] c = new LoggingAppender[0];
    private static final List<LoggingAppender> d = new ArrayList<LoggingAppender>();
    private static LoggingAppender[] e = new LoggingAppender[0];
    private static SourceFactory[] f = new SourceFactory[0];
    private static final FormattedLogStream g = new FormattedLogStream();
    private static Thread h;
    private static Logger i;
    private static Logger j;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void a() {
        Map<String, Logger> map = a;
        synchronized (map) {
            if (h == null && g != null) {
                Thread thread = new Thread(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        h = Thread.currentThread();
                        LogID.setID("logger");
                        while (h != null || !LogBuffer.b()) {
                            try {
                                LogManager.a(LogBuffer.a(), c);
                            }
                            catch (InterruptedException interruptedException) {
                                h = null;
                            }
                            catch (OutOfMemoryError outOfMemoryError) {
                            }
                            catch (Throwable throwable) {
                                try {
                                    LogManager.getConfigLogger().debug(throwable);
                                }
                                catch (Throwable throwable2) {}
                            }
                        }
                        Map<String, Logger> map = a;
                        synchronized (map) {
                            h = null;
                        }
                        LogManager.getConfigLogger().debug("Logging Spooler stopped");
                    }
                }, "Logging Spooler");
                thread.setDaemon(true);
                thread.start();
                h = thread;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stopSpooler() {
        Thread thread = h;
        Map<String, Logger> map = a;
        synchronized (map) {
            h = null;
        }
        if (thread != null) {
            int n2;
            for (n2 = 0; n2 < 100 && !LogBuffer.b() && thread.isAlive(); ++n2) {
                try {
                    thread.join(10L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            thread.interrupt();
            for (n2 = 0; n2 < 10; ++n2) {
                try {
                    thread.join(10L);
                    if (thread.isAlive()) continue;
                    break;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        while (!LogBuffer.b()) {
            try {
                LogManager.a(LogBuffer.a(), c);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace(System.err);
            }
        }
        g.b();
    }

    @Nonnull
    public static Logger getLogger(@Nonnull String module) {
        if (h == null) {
            LogManager.a();
        }
        String string = module;
        Logger logger = a.get(module = LogManager.a(module));
        if (logger == null) {
            if (!string.equalsIgnoreCase(module)) {
                LogManager.getConfigLogger().debug("Changed Logger '" + string + "' to '" + module + "'");
            }
            logger = new DefaultLogger(module);
            a.put(module, logger);
        }
        return logger;
    }

    @Nonnull
    private static String a(@Nonnull String string) {
        int n2 = string.indexOf(46);
        if (n2 > 0) {
            if (string.startsWith("waffle.")) {
                return "Authentication";
            }
            if (string.startsWith("com.bradmcevoy.")) {
                return "Webdav";
            }
            if (string.startsWith("net.sf.ehcache.")) {
                return "Cache";
            }
            if (string.startsWith("com.asual.lesscss.")) {
                return "Theme";
            }
            if (string.startsWith("org.eclipse.jetty.")) {
                return "Webserver";
            }
            if (string.startsWith("com.inet.http.")) {
                return "Webserver";
            }
            if (string.startsWith("com.inet.webserver.")) {
                return "Webserver";
            }
            if (string.startsWith("org.shredzone.acme4j")) {
                return "Webserver";
            }
            if (string.startsWith("org.jose4j")) {
                return "Webserver";
            }
            if (string.startsWith("org.mongodb.")) {
                return "Persistence";
            }
            if (string.startsWith("org.bson.")) {
                return "Persistence";
            }
            if (string.startsWith("com.azure.cosmos.")) {
                return "Cosmos DB";
            }
            if (string.startsWith("com.azure.core.")) {
                return "Cosmos DB";
            }
            if (string.startsWith("com.azure.identity.")) {
                return "Cosmos DB";
            }
            if (string.startsWith("com.microsoft.aad.msal4j.")) {
                return "Cosmos DB";
            }
            if (string.startsWith("io.netty.")) {
                return "Netty";
            }
            if (string.startsWith("reactor.")) {
                return "Netty";
            }
            if (string.startsWith("software.amazon.awssdk.")) {
                return "DynamoDB";
            }
            if (n2 > 3) {
                return LogManager.b(string.substring(0, n2));
            }
            int n3 = string.indexOf(46, n2 + 1);
            if (n3 > 0) {
                String string2 = LogManager.b(string.substring(n2 + 1, n3));
                int n4 = string.indexOf(46, n3 + 1);
                if (n4 > 0 && n4 - n3 > 1) {
                    String string3 = LogManager.b(string.substring(n3 + 1, n4));
                    return string2 + " " + string3;
                }
                return string2;
            }
        }
        return string;
    }

    private static String b(@Nonnull String string) {
        if (string.length() > 0 && Character.isLowerCase(string.charAt(0))) {
            return Character.toUpperCase(string.charAt(0)) + string.substring(1);
        }
        return string;
    }

    public static List<String> getCreatedLoggerNames() {
        Object[] objectArray = a.keySet().toArray();
        Arrays.sort(objectArray);
        List<Object> list = Arrays.asList(objectArray);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addLoggingAppender(LoggingAppender appender) {
        if (appender == null) {
            throw new NullPointerException("LoggingAppender is null");
        }
        List<LoggingAppender> list = b;
        synchronized (list) {
            b.add(appender);
            c = b.toArray(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeLoggingPreparer(LoggingAppender preparer) {
        List<LoggingAppender> list = d;
        synchronized (list) {
            d.remove(preparer);
            e = d.toArray(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addLoggingPreparer(LoggingAppender preparer) {
        if (preparer == null) {
            throw new NullPointerException("LoggingAppender is null");
        }
        List<LoggingAppender> list = d;
        synchronized (list) {
            d.add(preparer);
            e = d.toArray(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeLoggingAppender(LoggingAppender appender) {
        List<LoggingAppender> list = b;
        synchronized (list) {
            b.remove(appender);
            c = b.toArray(c);
        }
    }

    public static void setLogStream(PrintStream stream) {
        g.a(stream);
    }

    @Nullable
    public static PrintStream getLogStream() {
        return g.a();
    }

    public static synchronized void addSourceFactory(SourceFactory factory) {
        ArrayList<SourceFactory> arrayList = new ArrayList<SourceFactory>(Arrays.asList(f));
        arrayList.add(factory);
        f = arrayList.toArray(f);
    }

    public static void setTraceCounter(TraceCounter newCounter) {
        g.a(newCounter);
    }

    @Nonnull
    public static Logger getConfigLogger() {
        if (i != null) {
            return i;
        }
        return new StaticLogger("Config"){

            @Override
            protected void log(LogLevel level, String prefix, Object message) {
                Logger logger = i;
                if (logger instanceof StaticLogger) {
                    ((StaticLogger)logger).log(level, prefix, message);
                    return;
                }
                if (message instanceof Throwable) {
                    ((Throwable)message).printStackTrace();
                } else if (level.getValue() <= this.getLogLevel()) {
                    System.out.println(message);
                }
            }

            @Override
            public void setLogLevel(int level) {
                super.setLogLevel(level);
                Logger logger = i;
                if (logger != null) {
                    logger.setLogLevel(level);
                }
            }
        };
    }

    @Nonnull
    public static Logger getApplicationLogger() {
        if (j == null) {
            String string = ServerPluginManager.getInstance().getCorePluginId();
            for (String string2 : a.keySet()) {
                if (!string2.equalsIgnoreCase(string)) continue;
                j = LogManager.getLogger(string2);
                break;
            }
            if (j == null) {
                return LogManager.getConfigLogger();
            }
        }
        return j;
    }

    public static void deprecatedMessage() {
        try {
            Logger logger = LogManager.getApplicationLogger();
            if (logger.isWarning()) {
                logger.warn("The method '" + ThreadUtils.getCallerName(1) + "' is deprecated and will be removed in future major versions. See the API documentation for details of replacement. It is called from '" + ThreadUtils.getCallerName(2) + "'");
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void logDiagnostics(@Nullable Connection con) {
        Logger logger = LogManager.getConfigLogger();
        if (con != null) {
            ForkJoinPool.commonPool().execute(() -> {
                try {
                    String string;
                    String string2 = con.getMetaData().getDatabaseProductName().toLowerCase();
                    if (string2.contains("oracle")) {
                        string = "SELECT 1 FROM DUAL";
                    } else if (string2.contains("sql server")) {
                        string = "SELECT 1";
                        LogManager.a(con);
                    } else {
                        string = string2.contains("mysql") || string2.contains("mariadb") ? "SELECT 1" : null;
                    }
                    if (string != null) {
                        long l2 = System.currentTimeMillis();
                        con.createStatement().executeQuery(string).next();
                        logger.error("\tdatabase ping:             " + (System.currentTimeMillis() - l2) + " ms");
                    }
                }
                catch (SQLException sQLException) {
                    logger.error(sQLException);
                }
            });
        }
        java.lang.management.OperatingSystemMXBean operatingSystemMXBean = ManagementFactory.getOperatingSystemMXBean();
        logger.error("\tavailable processors:      " + operatingSystemMXBean.getAvailableProcessors());
        logger.error("\tsystem load average:       " + operatingSystemMXBean.getSystemLoadAverage());
        logger.error("\tmax heap memory:           " + Runtime.getRuntime().maxMemory() / 1024L / 1024L + " MB");
        logger.error("\ttotal heap memory:         " + Runtime.getRuntime().totalMemory() / 1024L / 1024L + " MB");
        logger.error("\tfree heap memory:          " + Runtime.getRuntime().freeMemory() / 1024L / 1024L + " MB");
        if (operatingSystemMXBean instanceof OperatingSystemMXBean) {
            OperatingSystemMXBean operatingSystemMXBean2 = (OperatingSystemMXBean)operatingSystemMXBean;
            logger.error("\tfree physical memory:      " + operatingSystemMXBean2.getFreeMemorySize() / 1024L / 1024L + " MB");
            logger.error("\ttotal physical memory:     " + operatingSystemMXBean2.getTotalMemorySize() / 1024L / 1024L + " MB");
            logger.error("\tfree swap space:           " + operatingSystemMXBean2.getFreeSwapSpaceSize() / 1024L / 1024L + " MB");
            logger.error("\ttotal swap space:          " + operatingSystemMXBean2.getTotalSwapSpaceSize() / 1024L / 1024L + " MB");
            logger.error("\tcommitted virtual memory:  " + operatingSystemMXBean2.getCommittedVirtualMemorySize() / 1024L / 1024L + " MB");
            logger.error("\tsystem cpu load size:      " + operatingSystemMXBean2.getCpuLoad());
            logger.error("\tprocess cpu load size:     " + operatingSystemMXBean2.getProcessCpuLoad());
            logger.error("\tOperating system name:     " + operatingSystemMXBean2.getName());
            logger.error("\tOperating system version:  " + operatingSystemMXBean2.getVersion());
            logger.error("\tsystem architecture:       " + operatingSystemMXBean2.getArch());
        }
    }

    private static void a(Connection connection) throws SQLException {
        if (connection.isClosed()) {
            return;
        }
        Logger logger = LogManager.getConfigLogger();
        String string = "SELECT  *\r\nFROM    sys.dm_exec_requests  \r\n        CROSS APPLY sys.dm_exec_sql_text(sql_handle)  ";
        try (Statement statement = connection.createStatement();
             ResultSet resultSet = statement.executeQuery(string);){
            logger.error("Currently running Queries:");
            while (resultSet.next()) {
                logger.error("NEXT Query:");
                ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                int n2 = resultSetMetaData.getColumnCount();
                for (int i2 = 1; i2 <= n2; ++i2) {
                    logger.error(resultSetMetaData.getColumnLabel(i2) + ": " + String.valueOf(resultSet.getObject(i2)));
                }
            }
        }
    }

    static void a(String string, LogLevel logLevel, String string2, Object object) {
        SourceDescription sourceDescription = null;
        for (SourceFactory sourceFactory : f) {
            SourceDescription sourceDescription2 = sourceFactory.getSourceDescription();
            if (sourceDescription2 == null) continue;
            sourceDescription = sourceDescription2;
            break;
        }
        LoggingEvent loggingEvent = new LoggingEvent(string, sourceDescription, logLevel, string2, object, LogID.getID());
        LogManager.a(loggingEvent, e);
        if (h == null || h == Thread.currentThread()) {
            LogManager.a(loggingEvent, c);
        } else {
            LogBuffer.a(loggingEvent);
        }
    }

    static void a(@Nonnull LoggingEvent loggingEvent, LoggingAppender[] loggingAppenderArray) {
        for (LoggingAppender loggingAppender : loggingAppenderArray) {
            if (loggingAppender == null) {
                return;
            }
            loggingAppender.append(loggingEvent);
        }
    }

    static {
        LogManager.addLoggingAppender(g);
        Exception exception = new Exception();
        ForkJoinPool.commonPool().execute(() -> {
            try {
                i = LogManager.getLogger("Config");
                LogManager.addLoggingAppender(new LogFileArchiver());
                LogManager.a();
            }
            catch (Throwable throwable) {
                throwable.addSuppressed(exception);
                throwable.printStackTrace();
            }
        });
    }
}

