/*
 * Decompiled with CFR 0.152.
 */
package com.inet.logging;

import com.inet.annotations.InternalApi;
import com.inet.cache.shutdown.ShutdownFinalizer;
import com.inet.cache.shutdown.ShutdownManager;
import com.inet.id.GUID;
import com.inet.logging.LogManager;
import com.inet.persistence.EventLogPersistence;
import com.inet.persistence.MaintenanceMode;
import com.inet.persistence.MaintenanceModeListener;
import com.inet.persistence.Persistence;
import com.inet.plugin.ServerPluginManager;
import com.inet.thread.BaseRunnableSession;
import com.inet.thread.EventDispatcher;
import com.inet.thread.SessionLocator;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@InternalApi
public class EventLog<EVENT extends Enum<?>> {
    private static final ConcurrentHashMap<String, EventLog<?>> a = new ConcurrentHashMap();
    private static boolean b;
    @Nonnull
    private final String c;
    private final EventDispatcher<EventLog<?>> d = new EventDispatcher(false);
    private EventLogPersistence e;

    @Nonnull
    public static <EVENT extends Enum<?>> EventLog<EVENT> register(@Nonnull String name) {
        return a.computeIfAbsent(name, string -> new EventLog((String)string));
    }

    private static void a() {
        for (EventLog<?> eventLog : a.values()) {
            EventLogPersistence eventLogPersistence = eventLog.e;
            eventLog.e = null;
            try {
                if (eventLogPersistence == null) continue;
                eventLogPersistence.close();
            }
            catch (Exception exception) {
                LogManager.getConfigLogger().error(exception);
            }
        }
    }

    private EventLog(@Nonnull String name) {
        Objects.requireNonNull(name);
        this.c = name;
        this.d.registerListener(this);
    }

    public void log(@Nonnull EVENT event, @Nullable String message, @Nullable String data, Object ... extraColumns) {
        UserAccount userAccount;
        try {
            if (b) {
                userAccount = UserManager.getInstance().getCurrentUserAccount();
            } else {
                b = ServerPluginManager.getInstance().isInitFinish();
                UserAccount userAccount2 = userAccount = b ? UserManager.getInstance().getCurrentUserAccount() : null;
            }
            if (userAccount != null && userAccount.getID() == UserManager.PRIVILEGED_ACCOUNT_ID) {
                GUID gUID;
                Object object;
                userAccount = null;
                BaseRunnableSession baseRunnableSession = null;
                if (SessionLocator.exists() && (object = SessionLocator.getCurrent()) instanceof BaseRunnableSession) {
                    baseRunnableSession = (BaseRunnableSession)object;
                }
                if ((gUID = ((UserManager)(object = UserManager.getInstance())).getCurrentUserAccountID(baseRunnableSession)) != UserManager.PRIVILEGED_ACCOUNT_ID) {
                    userAccount = ((UserManager)object).getUserAccount(gUID);
                }
            }
        }
        catch (Throwable throwable) {
            userAccount = null;
        }
        this.log(event, userAccount, message, data, extraColumns);
    }

    public void log(@Nonnull EVENT event, @Nullable UserAccount account, @Nullable String message, @Nullable String data, Object ... extraColumns) {
        EventData eventData = new EventData();
        eventData.a = System.currentTimeMillis();
        eventData.b = account;
        eventData.c = ((Enum)event).name();
        eventData.d = message;
        eventData.e = data;
        eventData.f = extraColumns;
        this.d.dispatchEvent(eventLog -> eventLog.a(eventData));
    }

    private void a(@Nonnull EventData eventData) {
        try {
            if (this.e == null) {
                if (!b) {
                    for (int i2 = 0; i2 < 100 && ServerPluginManager.getInstance().getCorePluginId() == null; ++i2) {
                        Thread.sleep(100L);
                    }
                }
                this.e = Persistence.getRecoveryEnabledInstance().getEventLogPersistence(this.c);
            }
            this.e.write(eventData);
        }
        catch (Throwable throwable) {
            LogManager.getConfigLogger().error(throwable);
        }
    }

    static {
        ShutdownManager.add(new ShutdownFinalizer(){

            @Override
            public void onShutdown() {
                EventLog.a();
            }

            @Override
            public int order() {
                return 100;
            }
        });
        MaintenanceMode.addListener(new MaintenanceModeListener(){

            @Override
            public void shutdown() {
                EventLog.a();
            }

            @Override
            public int order() {
                return 100;
            }
        });
    }

    public static class EventData {
        private long a;
        private UserAccount b;
        private String c;
        private String d;
        private String e;
        private Object[] f;

        public long getTimeMillis() {
            return this.a;
        }

        public UserAccount getAccount() {
            return this.b;
        }

        public String getEvent() {
            return this.c;
        }

        public String getMessage() {
            return this.d;
        }

        public String getData() {
            return this.e;
        }

        public Object[] getExtraColumns() {
            return this.f;
        }
    }
}

