/*
 * Decompiled with CFR 0.152.
 */
package com.inet.lib.util;

import com.inet.annotations.InternalApi;
import com.inet.lib.json.Json;
import com.inet.logging.Logger;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.HashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@InternalApi
public class EncodingFunctions {
    private static final byte[] a = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70};

    private EncodingFunctions() {
    }

    public static String encodeUrlParameter(String str) {
        return URLEncoder.encode(str, StandardCharsets.UTF_8);
    }

    public static String decodeUrlParameter(String str) {
        return URLDecoder.decode(str, StandardCharsets.UTF_8);
    }

    public static String encodeFileUrlPath(String path) {
        return EncodingFunctions.encodeUrlPath(path.replace('\\', '/'));
    }

    public static String encodeUrlPath(String path) {
        StringBuffer stringBuffer = null;
        int n2 = 0;
        int n3 = path.length();
        for (int i2 = 0; i2 < n3; ++i2) {
            boolean bl;
            char c2 = path.charAt(i2);
            switch (c2) {
                case ' ': 
                case '\"': 
                case '#': 
                case '%': 
                case ',': 
                case '<': 
                case '>': 
                case '?': 
                case '[': 
                case '\\': 
                case ']': 
                case '^': 
                case '`': 
                case '{': 
                case '|': 
                case '}': 
                case '\u007f': {
                    bl = true;
                    break;
                }
                default: {
                    boolean bl2 = bl = c2 >= '\u0080';
                }
            }
            if (!bl) continue;
            if (stringBuffer == null) {
                stringBuffer = new StringBuffer(n3);
            }
            stringBuffer.append(path, n2, i2);
            n2 = i2 + 1;
            if (c2 < '\u0080') {
                EncodingFunctions.a(stringBuffer, c2);
                continue;
            }
            if (c2 < '\u0800') {
                EncodingFunctions.a(stringBuffer, 0xC0 | c2 >> 6 & 0x1F);
                EncodingFunctions.a(stringBuffer, 0x80 | c2 >> 0 & 0x3F);
                continue;
            }
            if (Character.isHighSurrogate(c2) && ++i2 < n3) {
                char c3 = path.charAt(i2);
                ++n2;
                int n4 = ((c2 & 0x3FF) << 10 | c3 & 0x3FF) + 65536;
                EncodingFunctions.a(stringBuffer, 0xF0 | n4 >> 18 & 7);
                EncodingFunctions.a(stringBuffer, 0x80 | n4 >> 12 & 0x3F);
                EncodingFunctions.a(stringBuffer, 0x80 | n4 >> 6 & 0x3F);
                EncodingFunctions.a(stringBuffer, 0x80 | n4 & 0x3F);
                continue;
            }
            EncodingFunctions.a(stringBuffer, 0xE0 | c2 >> 12 & 0x1F);
            EncodingFunctions.a(stringBuffer, 0x80 | c2 >> 6 & 0x3F);
            EncodingFunctions.a(stringBuffer, 0x80 | c2 >> 0 & 0x3F);
        }
        if (stringBuffer == null) {
            return path;
        }
        stringBuffer.append(path, n2, n3);
        return stringBuffer.toString();
    }

    @Nonnull
    public static String encodeHttpHeader(@Nonnull String value, boolean rfc5987) {
        StringBuffer stringBuffer = null;
        int n2 = 0;
        int n3 = value.length();
        for (int i2 = 0; i2 < n3; ++i2) {
            boolean bl;
            char c2 = value.charAt(i2);
            if (rfc5987) {
                if (c2 >= 'A' && c2 <= 'Z' || c2 >= 'a' && c2 <= 'z' || c2 >= '0' && c2 <= '9') {
                    bl = false;
                } else {
                    switch (c2) {
                        case '!': 
                        case '#': 
                        case '$': 
                        case '&': 
                        case '+': 
                        case '-': 
                        case '.': 
                        case '^': 
                        case '_': 
                        case '`': 
                        case '|': 
                        case '~': {
                            bl = false;
                            break;
                        }
                        default: {
                            bl = true;
                            break;
                        }
                    }
                }
            } else {
                boolean bl2 = bl = c2 < ' ' || c2 > '\u00ff';
            }
            if (!bl) continue;
            if (stringBuffer == null) {
                stringBuffer = new StringBuffer(n3);
            }
            stringBuffer.append(value, n2, i2);
            n2 = i2 + 1;
            if (c2 < '\u0080') {
                EncodingFunctions.a(stringBuffer, c2);
                continue;
            }
            if (c2 < '\u0800') {
                EncodingFunctions.a(stringBuffer, 0xC0 | c2 >> 6 & 0x1F);
                EncodingFunctions.a(stringBuffer, 0x80 | c2 >> 0 & 0x3F);
                continue;
            }
            if (Character.isHighSurrogate(c2) && ++i2 < n3) {
                char c3 = value.charAt(i2);
                ++n2;
                int n4 = ((c2 & 0x3FF) << 10 | c3 & 0x3FF) + 65536;
                EncodingFunctions.a(stringBuffer, 0xF0 | n4 >> 18 & 7);
                EncodingFunctions.a(stringBuffer, 0x80 | n4 >> 12 & 0x3F);
                EncodingFunctions.a(stringBuffer, 0x80 | n4 >> 6 & 0x3F);
                EncodingFunctions.a(stringBuffer, 0x80 | n4 & 0x3F);
                continue;
            }
            EncodingFunctions.a(stringBuffer, 0xE0 | c2 >> 12 & 0x1F);
            EncodingFunctions.a(stringBuffer, 0x80 | c2 >> 6 & 0x3F);
            EncodingFunctions.a(stringBuffer, 0x80 | c2 >> 0 & 0x3F);
        }
        if (stringBuffer == null) {
            return value;
        }
        stringBuffer.append(value, n2, n3);
        return stringBuffer.toString();
    }

    private static void a(StringBuffer stringBuffer, int n2) {
        stringBuffer.append('%');
        stringBuffer.append((char)a[n2 >> 4 & 0xF]);
        stringBuffer.append((char)a[n2 & 0xF]);
    }

    public static String decodeUrlPath(String path) {
        try {
            URI uRI = new URI(path);
            String string = uRI.getScheme();
            if (string != null) {
                String string2 = uRI.getPath();
                if (string.length() == 1 && string2 != null) {
                    return string + ":" + string2;
                }
                throw new IllegalArgumentException(path);
            }
            return uRI.getPath();
        }
        catch (URISyntaxException uRISyntaxException) {
            return path;
        }
    }

    public static String toHexString(byte @Nonnull [] data, int length) {
        return new String(EncodingFunctions.toHexBytes(data, length), 0);
    }

    public static byte[] toHexBytes(byte @Nonnull [] data, int length) {
        byte[] byArray = new byte[length * 2];
        int n2 = 0;
        for (int i2 = 0; i2 < length; ++i2) {
            byte by = data[i2];
            byArray[n2++] = a[by >> 4 & 0xF];
            byArray[n2++] = a[by & 0xF];
        }
        return byArray;
    }

    @Nullable
    public static HashMap<Object, Object> decodeJWT(@Nullable String token, @Nullable Logger logger) {
        if (token != null) {
            int n2 = token.indexOf(46);
            int n3 = token.indexOf(46, n2 + 1);
            if (n2 > 0 && n3 > 0) {
                byte[] byArray = Base64.getDecoder().decode(token.substring(n2 + 1, n3));
                if (logger != null && logger.isDebug()) {
                    logger.debug("JWT token: " + new String(byArray, StandardCharsets.UTF_8));
                }
                return new Json().fromJson(byArray, HashMap.class);
            }
        }
        return null;
    }
}

