/*
 * Decompiled with CFR 0.152.
 */
package com.inet.lib.util;

import com.inet.shared.utils.MemoryStream;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.image.BufferedImage;
import javax.annotation.Nonnull;

public class ColorUtils {
    private static TexturePaint a = null;
    private static final Color[] b = new Color[]{Color.black, Color.blue, Color.cyan, Color.darkGray, Color.gray, Color.green, Color.lightGray, Color.magenta, Color.orange, Color.pink, Color.red, Color.white, Color.yellow, new Color(200, 70, 100)};
    private static Color[] c = new Color[14];
    private static int d = 0;

    public static int getLumiosity(Color color) {
        return (int)(0.2999 * (double)color.getRed() + 0.587 * (double)color.getGreen() + 0.114 * (double)color.getBlue());
    }

    public static int getColorDistance(Color c1, Color c2) {
        int n2 = c1.getRed() - c2.getRed();
        int n3 = c1.getGreen() - c2.getGreen();
        int n4 = c1.getBlue() - c2.getBlue();
        return (int)Math.sqrt(n2 * n2 + n4 * n4 + n3 * n3);
    }

    public static Color addTransparency(Color color, int transparency) {
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), transparency);
    }

    public static Color getInvertedColor(Color color) {
        return new Color(255 - color.getRed(), 255 - color.getGreen(), 255 - color.getBlue(), color.getAlpha());
    }

    public static TexturePaint getDefaultCheckesPaint(Rectangle r) {
        if (a == null) {
            a = ColorUtils.getCheckesPaint(r, Color.DARK_GRAY, Color.GRAY);
        }
        return a;
    }

    public static TexturePaint getCheckesPaint(Rectangle r, Color c1, Color c2) {
        BufferedImage bufferedImage = new BufferedImage(20, 20, 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setColor(c1);
        graphics2D.fillRect(0, 0, 10, 10);
        graphics2D.fillRect(10, 10, 10, 10);
        graphics2D.setColor(c2);
        graphics2D.fillRect(0, 10, 10, 10);
        graphics2D.fillRect(10, 0, 10, 10);
        return new TexturePaint(bufferedImage, r);
    }

    public static TexturePaint getStripesPaint(Rectangle r, Color c1, Color c2) {
        BufferedImage bufferedImage = new BufferedImage(20, 20, 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setColor(c1);
        graphics2D.fillRect(0, 0, 20, 20);
        graphics2D.setColor(c2);
        graphics2D.fillPolygon(new Polygon(new int[]{0, 10, 0}, new int[]{0, 0, 10}, 3));
        graphics2D.fillPolygon(new Polygon(new int[]{20, 20, 10, 0}, new int[]{0, 10, 20, 20}, 4));
        return new TexturePaint(bufferedImage, r);
    }

    public static Color[] getDefaultPalette() {
        return b;
    }

    public static Color[] getUserPalette() {
        return c;
    }

    public static void addUserColor(Color c2) {
        int n2;
        if (c2 == null || c2.getAlpha() == 0) {
            return;
        }
        for (n2 = 0; n2 < b.length; ++n2) {
            if (!c2.equals(b[n2])) continue;
            return;
        }
        for (n2 = 0; n2 < c.length; ++n2) {
            if (!c2.equals(c[n2])) continue;
            return;
        }
        for (n2 = 0; n2 < c.length; ++n2) {
            if (c[n2] != null) continue;
            ColorUtils.c[n2] = c2;
            return;
        }
        ColorUtils.c[ColorUtils.d] = c2;
        if (++d == c.length) {
            d = 0;
        }
    }

    public static int getAlpha(int color) {
        int n2 = ~(color >> 24);
        if (n2 < 0) {
            n2 = 256 + n2;
        }
        return n2;
    }

    public static int toCcColor(Color color) {
        if (color == null) {
            return -1;
        }
        int n2 = color.getRGB();
        return ~n2 & 0xFF000000 | ((n2 & 0xFF) << 16) + (n2 & 0xFF00) + ((n2 & 0xFF0000) >> 16);
    }

    public static int getShadowColor(int color) {
        return ColorUtils.toCcColor(new Color(ColorUtils.getRed(color), ColorUtils.getGreen(color), ColorUtils.getBlue(color), 127));
    }

    public static int getRed(int color) {
        return color & 0xFF;
    }

    public static int getBlue(int color) {
        return (color & 0xFF0000) >> 16;
    }

    public static int getGreen(int color) {
        return (color & 0xFF00) >> 8;
    }

    public static Color toJavaColor(int abgr) {
        if (ColorUtils.getAlpha(abgr) == 0) {
            return null;
        }
        return new Color(~abgr & 0xFF000000 | (abgr & 0xFF) << 16 | abgr & 0xFF00 | (abgr & 0xFF0000) >> 16, true);
    }

    public static Color getOpaqueColor(Color backColor, Color currentColor) {
        if (backColor == null) {
            backColor = new Color(255, 255, 255);
        }
        if (currentColor == null || currentColor.getAlpha() == 0) {
            return null;
        }
        float f2 = (float)currentColor.getAlpha() / 255.0f;
        return new Color((int)((float)backColor.getRed() * (1.0f - f2)) + (int)((float)currentColor.getRed() * f2), (int)((float)backColor.getGreen() * (1.0f - f2)) + (int)((float)currentColor.getGreen() * f2), (int)((float)backColor.getBlue() * (1.0f - f2)) + (int)((float)currentColor.getBlue() * f2));
    }

    public static int getOpaqueColor(int backColor, int currentColor) {
        Color color = ColorUtils.toJavaColor(backColor);
        Color color2 = ColorUtils.toJavaColor(currentColor);
        return ColorUtils.toCcColor(ColorUtils.getOpaqueColor(color, color2));
    }

    public static Paint getOpaquePaint(Color backColor, Paint p2) {
        switch (p2.getTransparency()) {
            case 1: 
            case 2: {
                return p2;
            }
        }
        if (p2 instanceof Color) {
            Color color = (Color)p2;
            return ColorUtils.getOpaqueColor(backColor, color);
        }
        if (p2 instanceof GradientPaint) {
            Color color;
            GradientPaint gradientPaint = (GradientPaint)p2;
            Color color2 = ColorUtils.getOpaqueColor(backColor, gradientPaint.getColor1());
            if (color2.getAlpha() != 0) {
                color2 = Color.WHITE;
            }
            if ((color = ColorUtils.getOpaqueColor(backColor, gradientPaint.getColor2())).getAlpha() != 0) {
                color = Color.WHITE;
            }
            return new GradientPaint(gradientPaint.getPoint1(), color2, gradientPaint.getPoint2(), color);
        }
        return p2;
    }

    public static int getRgbColorVal(int argbColorVal) {
        return argbColorVal & 0xFFFFFF;
    }

    public static int setMinTransparenceLevel(int abgr, float alpha) {
        int n2 = (int)(255.0f * alpha);
        int n3 = ColorUtils.getAlpha(abgr);
        if (n2 < n3) {
            abgr = abgr & 0xFFFFFF | ~n2 << 24;
        }
        return abgr;
    }

    public static void appendHtmlColor(@Nonnull MemoryStream stream, int abgr) {
        stream.writeByte(35);
        stream.writeByteAsHexString(ColorUtils.getRed(abgr));
        stream.writeByteAsHexString(ColorUtils.getGreen(abgr));
        stream.writeByteAsHexString(ColorUtils.getBlue(abgr));
        int n2 = ColorUtils.getAlpha(abgr);
        if (n2 < 255) {
            stream.writeByteAsHexString(n2);
        }
    }

    @Nonnull
    public static String convertAbgrToHtmlColor(int abgr) {
        MemoryStream memoryStream = new MemoryStream();
        ColorUtils.appendHtmlColor(memoryStream, abgr);
        return memoryStream.toString();
    }

    public static int convertHtmlColorToAbgr(@Nonnull String htmlColor) {
        htmlColor = htmlColor.substring(1);
        int n2 = Integer.parseInt(htmlColor.substring(4, 6), 16);
        int n3 = Integer.parseInt(htmlColor.substring(2, 4), 16);
        int n4 = Integer.parseInt(htmlColor.substring(0, 2), 16);
        if (htmlColor.length() == 8) {
            int n5 = Integer.parseInt(htmlColor.substring(6, 8), 16);
            return (n5 & 0xFF) << 24 | (n2 & 0xFF) << 16 | (n3 & 0xFF) << 8 | n4 & 0xFF;
        }
        return (n2 & 0xFF) << 16 | (n3 & 0xFF) << 8 | n4 & 0xFF;
    }
}

