/*
 * Decompiled with CFR 0.152.
 */
package com.inet.lib.json;

import com.inet.annotations.InternalApi;
import com.inet.lib.io.FastByteArrayInputStream;
import com.inet.lib.io.UTF8StreamReader;
import com.inet.lib.io.UTF8StreamWriter;
import com.inet.lib.json.ClassWrapper;
import com.inet.lib.json.FastStringReader;
import com.inet.lib.json.JsonException;
import com.inet.lib.json.JsonParameterizedType;
import com.inet.lib.json.JsonSubTypeResolver;
import com.inet.lib.json.JsonTypeResolver;
import com.inet.lib.json.JsonWriter;
import com.inet.lib.json.JsonWriterFilter;
import com.inet.lib.json.d;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@InternalApi
public class Json {
    public static final String JSON_DATA_PRODUCES_NULL_VALUE = "JSON data produces NULL value";
    public static final Map<Object, Map<String, String>> NULL_MAP = new HashMap<Object, Map<String, String>>(){

        public Map<String, String> a(@Nullable Object object, @Nullable Map<String, String> map) {
            return null;
        }

        @Override
        public void putAll(@Nonnull Map<? extends Object, ? extends Map<String, String>> m2) {
        }

        @Override
        public /* synthetic */ Object put(@Nullable Object object, @Nullable Object object2) {
            return this.a(object, (Map)object2);
        }
    };
    public static final Charset UTF8 = Charset.forName("UTF8");

    @Nonnull
    public <T> T fromJson(byte @Nonnull [] input, @Nonnull Class<T> clazz) {
        try {
            return this.fromJson((InputStream)new FastByteArrayInputStream(input), (Type)clazz, null, null);
        }
        catch (Exception exception) {
            throw JsonException.create(exception);
        }
    }

    public <T> T fromJson(byte @Nonnull [] input, @Nonnull Class<T> clazz, Type ... generic) {
        try {
            return this.fromJson((InputStream)new FastByteArrayInputStream(input), clazz, generic);
        }
        catch (Exception exception) {
            throw JsonException.create(exception);
        }
    }

    @Nonnull
    public <T> T fromJson(@Nonnull InputStream input, @Nonnull Class<T> clazz) throws IOException {
        return this.fromJson(input, (Type)clazz, null, null);
    }

    @Nonnull
    public <T> T fromJson(@Nonnull InputStream input, @Nonnull Class<T> clazz, Type ... generic) {
        try {
            return this.fromJson((Reader)new UTF8StreamReader(input), clazz, generic);
        }
        catch (Exception exception) {
            throw JsonException.create(exception);
        }
    }

    @Nonnull
    public <T> T fromJson(@Nonnull InputStream input, @Nonnull Class<T> clazz, JsonTypeResolver typeResolver) throws IOException {
        return this.fromJson(input, clazz, null, typeResolver);
    }

    @Nonnull
    public <T> T fromJson(@Nonnull InputStream input, @Nonnull Type clazz, Map<Object, Map<String, String>> extraFields, JsonTypeResolver typeResolver) throws IOException {
        return this.fromJson((Reader)new UTF8StreamReader(input), clazz, extraFields, typeResolver);
    }

    @Nonnull
    public <T> T fromJson(@Nonnull String jsonData, @Nonnull Class<T> clazz) {
        return this.fromJson(jsonData, (Type)clazz, null, null);
    }

    @Nonnull
    public <T> T fromJson(@Nonnull String jsonData, @Nonnull Class<T> clazz, JsonTypeResolver typeResolver) {
        return this.fromJson(jsonData, clazz, null, typeResolver);
    }

    @Nonnull
    public <T> T fromJson(@Nonnull String jsonData, @Nonnull Type clazz) {
        return this.fromJson(jsonData, clazz, null, null);
    }

    @Nonnull
    public <T> T fromJson(@Nonnull String jsonData, @Nonnull Type clazz, Map<Object, Map<String, String>> extraFields) {
        return this.fromJson(jsonData, clazz, extraFields, null);
    }

    @Nonnull
    public <T> T fromJson(@Nonnull String jsonData, @Nonnull Type clazz, Map<Object, Map<String, String>> extraFields, JsonTypeResolver typeResolver) {
        FastStringReader fastStringReader = null;
        try {
            fastStringReader = new FastStringReader(jsonData);
            return this.fromJson((Reader)fastStringReader, clazz, extraFields, typeResolver);
        }
        catch (Exception exception) {
            JsonException jsonException = JsonException.create(exception);
            if (fastStringReader != null) {
                int n2 = fastStringReader.getIndexPosition() - 1;
                int n3 = Math.max(0, n2 - 30);
                int n4 = Math.min(n2 + 30, jsonData.length());
                String string = jsonData.substring(n3, n4);
                jsonException.addSuppressed(new JsonException("Syntax error in JSON data at position " + n2 + ". Nearby excerpt: " + string));
            }
            throw jsonException;
        }
    }

    @Nonnull
    public <T> T fromJson(@Nonnull Reader jsonData, @Nonnull Class<T> clazz) throws IOException {
        return this.fromJson(jsonData, (Type)clazz, null, null);
    }

    @Nonnull
    public <T> T fromJson(@Nonnull Reader jsonData, @Nonnull Class<T> clazz, JsonTypeResolver typeResolver) throws IOException {
        return this.fromJson(jsonData, clazz, null, typeResolver);
    }

    @Nonnull
    public <T> T fromJson(@Nonnull Reader jsonData, @Nonnull Class<T> clazz, Map<Object, Map<String, String>> extraFields) throws IOException {
        return this.fromJson(jsonData, clazz, extraFields, null);
    }

    @Nonnull
    public <T> T fromJson(@Nonnull Reader jsonData, @Nonnull Type clazz) throws IOException {
        return this.fromJson(jsonData, clazz, null, null);
    }

    @Nonnull
    public <T> T fromJson(@Nonnull Reader jsonData, @Nonnull Type clazz, JsonTypeResolver typeResolver) throws IOException {
        return this.fromJson(jsonData, clazz, null, typeResolver);
    }

    @Nonnull
    public <T> T fromJson(@Nonnull Reader jsonData, @Nonnull Type clazz, Map<Object, Map<String, String>> extraFields) throws IOException {
        return this.fromJson(jsonData, clazz, extraFields, null);
    }

    @Nonnull
    public <T> T fromJson(@Nonnull Reader jsonData, @Nonnull Type clazz, Map<Object, Map<String, String>> extraFields, JsonTypeResolver typeResolver) throws IOException {
        try {
            T t = this.fromJsonNullable(jsonData, clazz, extraFields, typeResolver);
            if (t == null) {
                throw new JsonException(JSON_DATA_PRODUCES_NULL_VALUE);
            }
            return t;
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            throw JsonException.create(exception);
        }
    }

    @Nullable
    @Deprecated
    public <T> T fromJsonNullable(@Nonnull Reader jsonData, @Nonnull Type clazz, Map<Object, Map<String, String>> extraFields, JsonTypeResolver typeResolver) throws IOException {
        try {
            if (typeResolver == null) {
                typeResolver = JsonTypeResolver.a;
            }
            d d2 = new d(jsonData, extraFields, typeResolver);
            return (T)d2.a(clazz, null);
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            throw JsonException.create(exception);
        }
    }

    @Nonnull
    public <T> T fromJson(@Nonnull String jsonData, @Nonnull Class<T> clazz, Type ... generic) {
        return this.fromJson(jsonData, null, clazz, generic);
    }

    @Nonnull
    public <T> T fromJson(@Nonnull String jsonData, @Nullable Map<Object, Map<String, String>> extraFields, @Nonnull Class<T> clazz, Type ... generic) {
        try {
            return this.fromJson((Reader)new FastStringReader(jsonData), extraFields, clazz, generic);
        }
        catch (Exception exception) {
            throw JsonException.create(exception);
        }
    }

    @Nonnull
    public <T> T fromJson(@Nonnull Reader jsonData, @Nonnull Class<T> clazz, Type ... generic) throws IOException {
        return this.fromJson(jsonData, null, clazz, generic);
    }

    @Nonnull
    public <T> T fromJson(@Nonnull Reader jsonData, Map<Object, Map<String, String>> extraFields, @Nonnull Class<T> clazz, Type ... generic) throws IOException {
        try {
            d d2 = new d(jsonData, extraFields, JsonTypeResolver.a);
            Class<T> clazz2 = generic == null || generic.length == 0 ? clazz : new JsonParameterizedType(clazz, generic);
            Object object = d2.a(clazz2, null);
            if (object == null) {
                throw new JsonException(JSON_DATA_PRODUCES_NULL_VALUE);
            }
            return (T)object;
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            throw JsonException.create(exception);
        }
    }

    public Object[] fromJson(@Nonnull Reader jsonData, @Nonnull @Nonnull Type @Nonnull [] classes) throws IOException {
        try {
            d d2 = new d(jsonData, null, JsonTypeResolver.a);
            return d2.a(classes);
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            throw JsonException.create(exception);
        }
    }

    @Nonnull
    public String toJson(@Nonnull Object data) {
        return this.toJson(data, (JsonWriterFilter)null);
    }

    @Nonnull
    public String toJson(@Nonnull Object data, @Nullable JsonWriterFilter filter) {
        StringBuilder stringBuilder = new StringBuilder();
        this.toJson(data, stringBuilder, filter);
        return stringBuilder.toString();
    }

    public void toJson(@Nonnull Object value, @Nonnull Appendable writer) throws IOException {
        this.toJson(value, writer, null);
    }

    public void toJson(@Nonnull Object value, @Nonnull Appendable writer, @Nullable JsonWriterFilter filter) throws IOException {
        try {
            JsonWriter jsonWriter = new JsonWriter(writer);
            if (filter != null) {
                jsonWriter.setWriterFilter(filter);
            }
            jsonWriter.a(value);
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            throw JsonException.create(exception);
        }
    }

    public void toJson(@Nonnull Object value, @Nonnull StringBuilder builder) {
        this.toJson(value, builder, null);
    }

    public void toJson(@Nonnull Object value, @Nonnull StringBuilder builder, @Nullable JsonWriterFilter filter) {
        Objects.requireNonNull(value, "value must non null");
        this.toJsonNullable(value, builder, filter);
    }

    @Deprecated
    public void toJsonNullable(@Nullable Object value, @Nonnull StringBuilder builder, @Nullable JsonWriterFilter filter) {
        try {
            JsonWriter jsonWriter = new JsonWriter(builder);
            if (filter != null) {
                jsonWriter.setWriterFilter(filter);
            }
            jsonWriter.a(value);
        }
        catch (Exception exception) {
            throw JsonException.create(exception);
        }
    }

    public void toJson(@Nonnull Object value, @Nonnull OutputStream output) throws IOException {
        Objects.requireNonNull(value, "value must non null");
        UTF8StreamWriter uTF8StreamWriter = new UTF8StreamWriter(output);
        this.toJson(value, uTF8StreamWriter);
        try {
            uTF8StreamWriter.flush();
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            throw JsonException.create(exception);
        }
    }

    public static <T> void registerTypeResolver(@Nonnull Class<T> clazz, @Nullable JsonSubTypeResolver<T> resolver) {
        ClassWrapper.getWrapper(clazz, null).a(resolver);
    }

    @Nonnull
    public static PrintStream getErrorStream() {
        return System.err;
    }
}

