/*
 * Decompiled with CFR 0.152.
 */
package com.inet.lib.io;

import com.inet.annotations.InternalApi;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import javax.annotation.Nonnull;

@InternalApi
public class UTF8StreamWriter
extends Writer {
    private final OutputStream a;
    private int b;

    public UTF8StreamWriter(@Nonnull OutputStream output) {
        this.a = output;
    }

    private void a(int n2) throws IOException {
        if (n2 < 128) {
            this.a.write(n2);
        } else if (n2 < 2048) {
            this.a.write(0xC0 | n2 >> 6);
            this.a.write(0x80 | n2 & 0x3F);
        } else if (n2 < 65536) {
            this.a.write(0xE0 | n2 >> 12);
            this.a.write(0x80 | n2 >> 6 & 0x3F);
            this.a.write(0x80 | n2 & 0x3F);
        } else {
            this.a.write(0xF0 | n2 >> 18 & 7);
            this.a.write(0x80 | n2 >> 12 & 0x3F);
            this.a.write(0x80 | n2 >> 6 & 0x3F);
            this.a.write(0x80 | n2 & 0x3F);
        }
    }

    @Override
    public void write(int ch) throws IOException {
        if (this.b != 0) {
            if (Character.isLowSurrogate((char)ch)) {
                ch = ((this.b & 0x3FF) << 10 | ch & 0x3FF) + 65536;
            } else {
                this.a(this.b);
            }
            this.b = 0;
            this.a(ch);
        } else if (Character.isHighSurrogate((char)ch)) {
            this.b = ch;
        } else {
            this.a((char)ch);
        }
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        int n2 = off + len;
        while (off < n2) {
            this.write(cbuf[off++]);
        }
    }

    @Override
    public void write(String str, int off, int len) throws IOException {
        int n2 = off + len;
        while (off < n2) {
            this.write(str.charAt(off++));
        }
    }

    @Override
    public Writer append(CharSequence csq) throws IOException {
        if (csq == null) {
            this.write("null");
        } else {
            this.append(csq, 0, csq.length());
        }
        return this;
    }

    @Override
    public Writer append(CharSequence csq, int start, int end) throws IOException {
        if (csq == null) {
            this.write("null");
        } else {
            while (start < end) {
                this.write(csq.charAt(start++));
            }
        }
        return this;
    }

    @Override
    public void flush() throws IOException {
        this.flushSurrogate();
        this.a.flush();
    }

    public void flushSurrogate() throws IOException {
        if (this.b != 0) {
            this.a(this.b);
            this.b = 0;
        }
    }

    @Override
    public void close() throws IOException {
        this.flushSurrogate();
        this.a.close();
    }
}

