/*
 * Decompiled with CFR 0.152.
 */
package com.inet.lib.io;

import com.inet.annotations.InternalApi;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UTFDataFormatException;
import javax.annotation.Nonnull;

@InternalApi
public class UTF8StreamReader
extends Reader {
    private final InputStream a;
    private int b;
    private boolean c;

    public UTF8StreamReader(@Nonnull InputStream input) {
        this(input, true);
    }

    public UTF8StreamReader(@Nonnull InputStream input, boolean scanForBOM) {
        this.a = input;
        this.c = scanForBOM;
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        int n2 = off;
        len += off;
        while (off < len) {
            int n3 = this.read();
            if (n3 < 0) {
                return off > n2 ? off - n2 : -1;
            }
            cbuf[off] = (char)n3;
            ++off;
        }
        return off - n2;
    }

    @Override
    public int read() throws IOException {
        if (this.c) {
            this.c = false;
            int n2 = this.a();
            if (n2 != 65279) {
                return n2;
            }
        }
        return this.a();
    }

    private int a() throws IOException {
        if (this.b != 0) {
            int n2 = this.b;
            this.b = 0;
            return n2;
        }
        int n3 = this.a.read();
        if (n3 < 0) {
            return -1;
        }
        switch (n3 >> 4) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return n3;
            }
            case 12: 
            case 13: {
                int n4 = this.b();
                return (char)((n3 & 0x1F) << 6 | n4 & 0x3F);
            }
            case 14: {
                int n5 = this.b();
                int n6 = this.b();
                return (char)((n3 & 0xF) << 12 | (n5 & 0x3F) << 6 | (n6 & 0x3F) << 0);
            }
            case 15: {
                if ((n3 & 8) != 0) {
                    throw new UTFDataFormatException("malformed input around byte " + n3);
                }
                int n7 = this.b();
                int n8 = this.b();
                int n9 = this.b();
                int n10 = (n3 & 7) << 18 | (n7 & 0x3F) << 12 | (n8 & 0x3F) << 6 | (n9 & 0x3F) << 0;
                this.b = 0xDC00 | (n10 -= 65536) & 0x3FF;
                return (char)(0xD800 | n10 >> 10);
            }
        }
        throw new UTFDataFormatException("malformed input around byte " + n3);
    }

    private int b() throws IOException, UTFDataFormatException {
        int n2 = this.a.read();
        if ((n2 & 0xC0) != 128) {
            throw new UTFDataFormatException("malformed input around byte " + n2);
        }
        return n2;
    }

    @Override
    public void close() throws IOException {
        this.a.close();
    }

    @Override
    public boolean ready() throws IOException {
        return this.a.available() > 0;
    }
}

