/*
 * Decompiled with CFR 0.152.
 */
package com.inet.http.error;

import com.inet.annotations.InternalApi;
import com.inet.authentication.base.LoginManager;
import com.inet.error.ErrorCodeHelper;
import com.inet.http.error.ServletErrorHandlerProvider;
import com.inet.id.GUID;
import com.inet.lib.util.IOFunctions;
import com.inet.lib.util.StringFunctions;
import com.inet.logging.LogManager;
import com.inet.logging.StaticLogger;
import com.inet.plugin.ApplicationDescription;
import com.inet.plugin.ServerPluginManager;
import com.inet.shared.servlet.ServletUtils;
import com.inet.usersandgroups.api.user.UserManager;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpServletResponseWrapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.SuppressFBWarnings;

@InternalApi
public class ServletErrorHandler {
    private static ThreadLocal<Boolean> a = ThreadLocal.withInitial(() -> false);

    public static void sendErrorPage(@Nonnull HttpServletRequest request, @Nonnull HttpServletResponse response, @Nonnull Throwable th) {
        if (a.get().booleanValue()) {
            return;
        }
        try {
            a.set(true);
            ServletErrorHandler.sendErrorPageRecusive(request, response, th);
        }
        finally {
            a.set(false);
        }
    }

    public static void sendErrorPageRecusive(@Nonnull HttpServletRequest request, @Nonnull HttpServletResponse response, @Nonnull Throwable th) {
        if (response.isCommitted()) {
            return;
        }
        try {
            IOFunctions.skipAll((InputStream)request.getInputStream());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        ArrayList<a> arrayList = new ArrayList<a>();
        ServerPluginManager serverPluginManager = ServerPluginManager.getInstance();
        List<ServletErrorHandlerProvider> list = serverPluginManager.get(ServletErrorHandlerProvider.class);
        if (list.size() > 0) {
            for (ServletErrorHandlerProvider servletErrorHandlerProvider : list) {
                int n2 = servletErrorHandlerProvider.priority(request, response, th);
                arrayList.add(new a(n2, servletErrorHandlerProvider));
            }
            Collections.sort(arrayList);
            a a2 = (a)arrayList.get(0);
            if (a2.a >= 0) {
                a2.a().sendErrorPage(request, response, th);
                return;
            }
        }
        try {
            ServletErrorHandlerProvider servletErrorHandlerProvider;
            int n3 = ErrorCodeHelper.getHttpStatusCode(th);
            response.setStatus(n3);
            servletErrorHandlerProvider = response.getOutputStream();
            StringWriter stringWriter = new StringWriter();
            stringWriter.append("<html><head><meta http-equiv='Content-Type' content='text/html;charset=UTF-8'/><title>Error " + n3 + "</title></head><body><h2>HTTP ERROR: " + n3 + "</h2><p>Problem accessing: ");
            stringWriter.append(StringFunctions.encodeHTML(request.getRequestURI()));
            stringWriter.append("<p>Reason:<pre>");
            if (ErrorCodeHelper.isHideStackTraceToUser(th, request)) {
                stringWriter.append(StringFunctions.encodeHTML(th.toString()));
            } else {
                StringWriter stringWriter2 = new StringWriter();
                th.printStackTrace(new PrintWriter(stringWriter2));
                stringWriter.append(StringFunctions.encodeHTML(stringWriter2.toString(), false));
            }
            stringWriter.append("</pre><hr /><i><small>Powered by ");
            stringWriter.append(ApplicationDescription.get().getApplicationName());
            stringWriter.append("</small></i>");
            servletErrorHandlerProvider.write(stringWriter.toString().getBytes(StandardCharsets.UTF_8));
        }
        catch (IOException iOException) {
            LogManager.getConfigLogger().error(iOException);
        }
    }

    public static boolean isClientAbort(@Nonnull Throwable th) {
        return StaticLogger.isClientAbort(th);
    }

    @SuppressFBWarnings(value={"UNVALIDATED_REDIRECT"}, justification="Validation occur in ServletUtils.createRedirectURL")
    public static boolean handleUnautorized(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String string;
        GUID gUID;
        response.setStatus(401);
        final boolean[] blArray = new boolean[1];
        response = new HttpServletResponseWrapper((HttpServletResponse)response){

            public ServletOutputStream getOutputStream() throws IOException {
                blArray[0] = true;
                return super.getOutputStream();
            }

            public void sendError(int sc) throws IOException {
                if (sc != 401) {
                    super.sendError(sc);
                }
            }

            public void flushBuffer() throws IOException {
                if (blArray[0]) {
                    super.flushBuffer();
                }
            }
        };
        GUID gUID2 = UserManager.getInstance().getCurrentUserAccountID();
        boolean bl = LoginManager.forceLogin(request, response);
        if (bl && (gUID = UserManager.getInstance().getCurrentUserAccountID()) != null && !Objects.equals(gUID2, gUID) && (string = ServletUtils.getRequestPage(request)) != null) {
            String string2 = ServletUtils.createRedirectURL(request, string);
            response.sendRedirect(string2);
            return false;
        }
        return !blArray[0];
    }

    private static class a
    implements Comparable<a> {
        private int a;
        private ServletErrorHandlerProvider b;

        a(int n2, ServletErrorHandlerProvider servletErrorHandlerProvider) {
            this.a = n2;
            this.b = servletErrorHandlerProvider;
        }

        ServletErrorHandlerProvider a() {
            return this.b;
        }

        public int a(a a2) {
            return Integer.compare(a2.a, this.a);
        }

        @Override
        public /* synthetic */ int compareTo(Object object) {
            return this.a((a)object);
        }
    }
}

