/*
 * Decompiled with CFR 0.152.
 */
package com.inet.font.truetype;

import com.inet.annotations.InternalApi;
import com.inet.cache.internal.HardDiskExternalDataWriterFactory;
import com.inet.cache.shutdown.ShutdownManager;
import com.inet.font.FontFamily;
import com.inet.font.cache.FontNameProcessor;
import com.inet.font.truetype.FontCollection;
import com.inet.font.truetype.FontFactory;
import com.inet.logging.LogID;
import com.inet.logging.LogManager;
import com.inet.thread.RunnableSession;
import com.inet.thread.SessionLocal;
import com.inet.thread.SessionLocator;
import java.awt.Font;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.zip.CRC32;
import javax.annotation.SuppressFBWarnings;

@InternalApi
public class SessionFontFactoryCache {
    private static final SessionLocal<Map<String, b>> a = new SessionLocal();
    private static final SessionLocal<Set<c>> b = new SessionLocal();

    public static void addTempFont(Font font, byte[] fontFile) throws IOException {
        SessionFontFactoryCache.addTempFont(font, fontFile, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="No user input is used")
    public static void addTempFont(Font font, byte[] fontFile, Map<Character, char[]> cmapAddition) throws IOException {
        Object object;
        c c2 = new c(font, fontFile);
        if (!SessionLocator.exists()) {
            LogManager.getApplicationLogger().warn("No Session was set for adding Temporory Font");
            return;
        }
        c2.a();
        RunnableSession runnableSession = SessionLocator.getCurrent();
        Object object2 = runnableSession;
        synchronized (object2) {
            object = b.get();
            if (object != null && object.contains(c2)) {
                return;
            }
        }
        object2 = HardDiskExternalDataWriterFactory.getDefaultDir();
        object = File.createTempFile("FontPool_S" + LogID.getID() + "_TTFont", ".ttf", (File)object2);
        try (Object object3 = new FileOutputStream((File)object);){
            ((OutputStream)object3).write(fontFile);
        }
        if (LogManager.getApplicationLogger().isDebug()) {
            LogManager.getApplicationLogger().debug(String.valueOf(runnableSession) + ": Storing session font: " + String.valueOf(font) + " to " + String.valueOf(object));
        }
        ShutdownManager.deleteOnShutdown((File)object);
        SessionFontFactoryCache.a((File)object, true, cmapAddition, c2);
        object3 = runnableSession;
        synchronized (object3) {
            Set<c> set = b.get();
            if (set == null) {
                set = new HashSet<c>();
                b.set(set);
            }
            set.add(c2);
        }
    }

    public static void addTempFont(File fontPath, boolean deleteOnSessionEnd) {
        SessionFontFactoryCache.a(fontPath, deleteOnSessionEnd, null, null);
    }

    private static void a(File file, boolean bl, Map<Character, char[]> map, c c2) {
        if (file == null || file.isDirectory()) {
            throw new IllegalArgumentException("The font path of a session font must point to a font file.");
        }
        FontFactory[] fontFactoryArray = FontCollection.getFontFactories(file.getAbsolutePath());
        if (map != null && fontFactoryArray != null) {
            if (fontFactoryArray.length > 1) {
                LogManager.getApplicationLogger().error("PDF CMap addition for font '" + file.getName() + "' is ambiguous (maps to more than one font file) and will be ignored");
                map = null;
            } else {
                fontFactoryArray[0].setCMapAddition(map);
            }
        }
        SessionFontFactoryCache.a(fontFactoryArray, file, bl, c2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void a(FontFactory[] fontFactoryArray, File file, boolean bl, c c2) {
        if (fontFactoryArray == null) {
            return;
        }
        a a2 = new a(file);
        try {
            for (FontFactory fontFactory : fontFactoryArray) {
                HashSet<String> hashSet = new HashSet<String>();
                String[] stringArray = fontFactory.b();
                if (stringArray == null || stringArray.length == 0) {
                    LogManager.getApplicationLogger().error("Cannot add temporary font, it has no name");
                    continue;
                }
                for (String string2 : stringArray) {
                    int n2 = fontFactory.a(string2) ? fontFactory.d() : 0;
                    String string3 = FontNameProcessor.getCompositeName(string2, n2);
                    hashSet.add(string3);
                }
                FontFamily fontFamily = fontFactory.c();
                if (fontFamily.getName() != null) {
                    hashSet.add(FontNameProcessor.getCompositeName(fontFamily.getName(), fontFactory.d()));
                }
                hashSet.forEach(string -> SessionFontFactoryCache.a(a2, bl, fontFactory, string, c2));
            }
        }
        finally {
            a2.c();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void a(a a2, boolean bl, FontFactory fontFactory, String string, c c2) {
        RunnableSession runnableSession = SessionLocator.getCurrent();
        synchronized (runnableSession) {
            a2.a();
            b b2 = SessionFontFactoryCache.getFontMap().put(string, new b(fontFactory, a2, bl, c2));
            if (b2 != null && b2.c && !a2.equals(b2.b)) {
                b2.b.b();
            }
        }
    }

    protected static Map<String, b> getFontMap() {
        Map<String, b> map = a.get();
        if (map == null) {
            map = new ConcurrentHashMap<String, b>();
            a.set(map);
        }
        return map;
    }

    static FontFactory a(String string) {
        Map<String, b> map = a.get();
        if (map != null) {
            b b2 = map.get(string);
            return b2 != null ? b2.a : null;
        }
        return null;
    }

    public static void startForCurrentSession() {
        SessionFontFactoryCache.getFontMap();
        Set<c> set = b.get();
        if (set == null) {
            b.set(new HashSet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cleanupForCurrentSession() {
        RunnableSession runnableSession = SessionLocator.getCurrent();
        synchronized (runnableSession) {
            Object object;
            Object object2;
            Object object3;
            Set<c> set = b.get();
            if (set != null) {
                object3 = set.iterator();
                while (object3.hasNext()) {
                    object2 = (c)object3.next();
                    ((c)object2).b();
                    if (!((c)object2).c()) continue;
                    object3.remove();
                }
            }
            object3 = SessionFontFactoryCache.getFontMap();
            object2 = object3.entrySet().iterator();
            ArrayList<String> arrayList = new ArrayList<String>();
            while (object2.hasNext()) {
                object = (Map.Entry)object2.next();
                b b2 = (b)object.getValue();
                b2.a();
                if (!b2.b()) continue;
                b2.c();
                arrayList.add((String)object.getKey());
                object2.remove();
            }
            if (LogManager.getApplicationLogger().isDebug() && arrayList.isEmpty()) {
                object = arrayList.stream().collect(Collectors.joining(","));
                LogManager.getApplicationLogger().debug(String.valueOf(SessionLocator.getCurrent()) + ": Clearing session fonts: " + (String)object);
            }
        }
    }

    private static class c {
        private long a;
        private int b;
        private String c;
        private String d;
        private int e;
        private Set<String> f = new HashSet<String>();

        public c(Font font, byte[] byArray) {
            this.b = byArray.length;
            CRC32 cRC32 = new CRC32();
            cRC32.update(byArray, 0, Math.min(2048, byArray.length));
            this.a = cRC32.getValue();
            this.c = font.getName();
            this.d = font.getFamily();
            this.e = this.b + (int)this.a + this.c.hashCode() + this.d.hashCode();
            this.f.add(LogID.getID());
        }

        public synchronized void a() {
            this.f.add(LogID.getID());
        }

        public synchronized void b() {
            this.f.remove(LogID.getID());
        }

        public boolean c() {
            return this.f.isEmpty();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof c)) {
                return false;
            }
            c c2 = (c)obj;
            return this.b == c2.b && this.a == c2.a && this.c.equals(c2.c) && this.d.equals(c2.d);
        }

        public int hashCode() {
            return this.e;
        }
    }

    private static class a {
        private File a;
        private boolean b = false;
        private int c = 0;

        public a(File file) {
            this.a = file;
        }

        public void a() {
            if (this.c == Integer.MIN_VALUE) {
                throw new IllegalStateException("Cannot use an already deleted temporary font file! (" + this.a.getName() + ")");
            }
            if (this.b) {
                throw new IllegalStateException("Cannot modify an already initialized font referencing! (" + this.a.getName() + ")");
            }
            ++this.c;
        }

        public void b() {
            --this.c;
            this.d();
        }

        public void c() {
            this.b = true;
            this.d();
        }

        private void d() {
            if (this.c <= 0 && this.b) {
                ShutdownManager.delete(this.a);
                this.c = Integer.MIN_VALUE;
            }
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof a)) {
                return false;
            }
            return this.a.equals(((a)obj).a);
        }
    }

    private static class b {
        private FontFactory a;
        private a b;
        private boolean c;
        private c d;

        public b(FontFactory fontFactory, a a2, boolean bl, c c2) {
            this.a = fontFactory;
            this.b = a2;
            this.c = bl;
            this.d = c2;
        }

        public synchronized void a() {
            if (this.d != null) {
                this.d.b();
            }
        }

        public boolean b() {
            return this.d == null || this.d.c();
        }

        private void c() {
            if (this.c) {
                this.b.b();
            }
        }
    }
}

