/*
 * Decompiled with CFR 0.152.
 */
package com.inet.font.truetype;

import com.inet.font.FontFamily;
import com.inet.font.cache.FontFamilyListHandler;
import com.inet.font.cache.FontNameProcessor;
import com.inet.font.cache.FontPathMapping;
import com.inet.font.truetype.FontCollection;
import com.inet.font.truetype.FontFactory;
import com.inet.logging.LogManager;
import com.inet.logging.Logger;
import java.util.HashMap;
import java.util.Map;

public class FontFactoriesCache {
    private static Map<String, FontFactory> a;

    public static int registerFontPath(String fontPath, int fontInstalledCount, boolean addFontFamily) {
        Logger logger = LogManager.getApplicationLogger();
        try {
            FontFactory[] fontFactoryArray = FontCollection.getFontFactories(fontPath);
            if (fontFactoryArray == null) {
                if (logger.isDebug()) {
                    logger.debug("can't read the font from '" + fontPath + "'");
                }
                return fontInstalledCount;
            }
            for (int i2 = 0; i2 < fontFactoryArray.length; ++i2) {
                String[] stringArray = fontFactoryArray[i2].b();
                if (stringArray == null || stringArray.length == 0) {
                    logger.info("font names not found in file '" + fontPath + "'");
                    continue;
                }
                if (logger.isDebug()) {
                    logger.debug("installed font [" + fontInstalledCount + "]:");
                }
                ++fontInstalledCount;
                for (int i3 = 0; i3 < stringArray.length; ++i3) {
                    if (stringArray[i3] == null || stringArray[i3].length() == 0) continue;
                    if (logger.isDebug()) {
                        logger.debug("font name: " + stringArray[i3]);
                    }
                    int n2 = fontFactoryArray[i2].a(stringArray[i3]) ? fontFactoryArray[i2].d() : 0;
                    String string = FontNameProcessor.getCompositeName(stringArray[i3], n2);
                    FontPathMapping.addFontPath(string, fontPath);
                    a.put(string, fontFactoryArray[i2]);
                }
                FontFamily fontFamily = fontFactoryArray[i2].c();
                if (fontFamily.getName() == null) {
                    logger.warn("font family name not found");
                    continue;
                }
                String string = FontNameProcessor.getCompositeName(fontFamily.getName(), fontFactoryArray[i2].d());
                FontPathMapping.addFontPath(string, fontPath);
                a.put(string, fontFactoryArray[i2]);
                if (fontFamily.hasLocalizedName()) {
                    string = FontNameProcessor.getCompositeName(fontFamily.toString(), fontFactoryArray[i2].d());
                    FontPathMapping.addFontPath(string, fontPath);
                    a.put(string, fontFactoryArray[i2]);
                }
                fontFamily.setFontPath(fontPath);
                if (fontFactoryArray[i2].a()) {
                    fontFamily.setSymbolicFlag();
                }
                if (!addFontFamily) continue;
                FontFamilyListHandler.addFontFamily(fontFamily);
            }
        }
        catch (Exception exception) {
            logger.error("Error by creating font factories from path: " + fontPath);
            logger.error(exception);
        }
        return fontInstalledCount;
    }

    public static void extendFontFactoriesMapping(String originalComposedName, String additionalComposedName) {
        FontFactory fontFactory = a.get(originalComposedName);
        a.put(additionalComposedName, fontFactory);
    }

    public static boolean isInitiated() {
        return a != null;
    }

    static final FontFactory a(String string, int n2) {
        if (string == null) {
            if (LogManager.getApplicationLogger().isDebug()) {
                LogManager.getApplicationLogger().debug("font name not defined");
            }
            return null;
        }
        if (!FontFactoriesCache.isInitiated()) {
            if (LogManager.getApplicationLogger().isDebug()) {
                LogManager.getApplicationLogger().debug("font factories list is not initiated");
            }
            return null;
        }
        String string2 = FontNameProcessor.getCompositeName(string, n2);
        return a.get(string2);
    }

    public static void init() {
        a = new HashMap<String, FontFactory>();
    }

    public static FontFactory getFontFactoryWithCompatibleStyle(String familyName, int fontStyle) {
        FontFactory fontFactory = FontFactoriesCache.a(familyName, fontStyle &= 3);
        if (fontFactory == null && fontStyle != 0 && (fontFactory = FontFactoriesCache.a(familyName, 0)) == null && fontStyle == 3 && (fontFactory = FontFactoriesCache.a(familyName, 1)) == null) {
            fontFactory = FontFactoriesCache.a(familyName, 2);
        }
        return fontFactory;
    }
}

