/*
 * Decompiled with CFR 0.152.
 */
package com.inet.font.layout;

import com.inet.font.CharMetricsProvider;
import com.inet.font.FontUtils;
import com.inet.font.cepack.AdobeCharNames;
import com.inet.font.layout.HasEncodingDifferences;
import com.inet.lib.list.CharCharMap;
import com.inet.lib.list.CharList;
import com.inet.logging.LogManager;
import com.inet.shared.utils.MemoryStream;
import javax.annotation.Nonnull;

public class FontEncoder
implements HasEncodingDifferences {
    private static final boolean USE_UNI_NAMES_AS_DEFAULT = false;
    private static final byte[] a = FontUtils.getBytes(" /uni");
    private static final byte[] b = FontUtils.getBytes(" /uni0");
    private static final byte[] c = FontUtils.getBytes(" /uni00");
    private static final byte[] d = FontUtils.getBytes(" /uni000");
    private static final byte[] e = FontUtils.getBytes(" /u");
    static final int MAX_SIZE = 255;
    static final int CONTROL_SYMBOLS_SIZE = 32;
    static final int ASCII_INTERVAL_SIZE = 128;
    private char[] f = new char[256];
    private CharCharMap g;
    private CharList h = new CharList();
    private int i = -1;
    private int j = -1;
    private int k = -1;
    private int l = -1;
    private int m;
    private int n;
    private CharMetricsProvider o;
    private MemoryStream p;
    private boolean q = false;
    private int r;

    public FontEncoder(@Nonnull CharMetricsProvider widthProvider) {
        this.o = widthProvider;
        this.g = new CharCharMap();
    }

    public boolean textCanBeWritten(String text) {
        int n2 = 255 - this.g.size() - this.r - 32 - this.h.size();
        for (int i2 = 0; i2 < text.length(); ++i2) {
            char c2 = text.charAt(i2);
            if (c2 < '\u0080' && (c2 < ' ' || this.f[c2] == c2) || this.h.indexOf(c2) != -1 || this.g.contains(c2)) continue;
            if (n2-- <= 0) {
                return false;
            }
            this.h.addElement(c2);
        }
        return true;
    }

    public byte @Nonnull [] encodeText(String text) {
        int n2 = text.length();
        byte[] byArray = new byte[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = text.charAt(i2);
            char c3 = this.b(c2);
            byArray[i2] = (byte)c3;
        }
        this.h.clear();
        return byArray;
    }

    private char b(char c2) {
        char c3;
        if (c2 < '\u0080') {
            if (c2 < ' ' || this.f[c2] == c2) {
                return c2;
            }
            if (this.f[c2] == '\u0000') {
                this.f[c2] = c2;
                ++this.r;
                if (c2 > this.j) {
                    this.j = c2;
                }
                if (this.i == -1 || c2 < this.i) {
                    this.i = c2;
                }
                return c2;
            }
        }
        if ((c3 = this.g.get(c2)) == '\uffff') {
            char c4 = '\u0000';
            if (c2 < '\u0080') {
                c4 = this.a();
                if (c4 != '\u0000') {
                    this.f[c4] = c2;
                    c3 = c4;
                }
                if (c4 > this.j) {
                    this.j = c4;
                }
                if (this.i == -1 || c4 < this.i) {
                    this.i = c4;
                }
            }
            if (c4 == '\u0000') {
                c4 = this.b();
                if (c4 != '\u0000') {
                    this.f[c4] = c2;
                    c3 = c4;
                    if (c4 > this.l) {
                        this.l = c4;
                    }
                    if (this.k == -1 || c4 < this.k) {
                        this.k = c4;
                    }
                } else if (c2 >= '\u0080' && (c4 = this.a()) != '\u0000') {
                    this.f[c4] = c2;
                    c3 = c4;
                    if (c4 > this.j) {
                        this.j = c4;
                    }
                    if (this.i == -1 || c4 < this.i) {
                        this.i = c4;
                    }
                }
            }
            if (c4 == '\u0000') {
                throw new IllegalStateException("code not found");
            }
            this.g.put(c2, c4);
        }
        return c3;
    }

    private char a() {
        for (int i2 = 32; i2 < 128; ++i2) {
            if (this.f[i2] != '\u0000') continue;
            return (char)i2;
        }
        return '\u0000';
    }

    private char b() {
        for (int i2 = 128; i2 < 255; ++i2) {
            if (this.f[i2] != '\u0000') continue;
            return (char)i2;
        }
        return '\u0000';
    }

    private void c() {
        if (this.p == null) {
            this.p = new MemoryStream();
        } else {
            this.p.setLength(0);
        }
    }

    @Override
    public MemoryStream getDifferences() {
        this.d();
        this.c();
        int n2 = 0;
        boolean bl = false;
        this.a(bl, n2);
        bl = true;
        this.a(bl, n2);
        return this.p;
    }

    private void a(boolean bl, int n2) {
        int n3;
        int n4 = n3 = bl ? this.l : this.j;
        for (int i2 = bl ? 128 : 0; i2 <= n3; ++i2) {
            char c2 = this.f[i2];
            if (c2 == '\u0000' || c2 == i2) continue;
            if (n2 != i2 - 1) {
                this.p.write(32);
                this.p.writeIntAsString(i2);
            }
            n2 = i2;
            String string = this.a(c2);
            if (string == null || "sigma1".equals(string)) {
                FontEncoder.writeUnicodeName(this.p, c2);
                continue;
            }
            this.p.write(32);
            this.p.write(47);
            this.p.write(FontUtils.getBytes(string));
        }
    }

    public MemoryStream getWidthsStream() {
        this.d();
        this.c();
        for (int i2 = this.m; i2 <= this.n; ++i2) {
            char c2 = this.f[i2];
            int n2 = c2 == '\u0000' ? 0 : this.getCharWidth(c2);
            this.p.write(32);
            this.p.writeIntAsString(n2);
        }
        return this.p;
    }

    public int getCharWidth(char ch) {
        return this.o.getWidth(ch);
    }

    String a(char c2) {
        return AdobeCharNames.getCharName(c2);
    }

    public int getMinChar() {
        this.d();
        return this.m;
    }

    public int getMaxChar() {
        this.d();
        return this.n;
    }

    private void d() {
        if (this.q) {
            return;
        }
        this.q = true;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        if (this.i != -1) {
            this.m = this.i;
            bl = true;
            if (this.j != -1) {
                this.n = this.j;
                bl2 = true;
            }
        } else if (this.j != -1) {
            bl = true;
        }
        if (this.k != -1) {
            bl3 = true;
            if (!bl) {
                this.m = this.k;
            }
            if (this.l != -1) {
                this.n = this.l;
                bl4 = true;
            }
        } else if (this.l != -1) {
            bl3 = true;
        }
        if (!bl && !bl3) {
            LogManager.getApplicationLogger().warn("no characters found in font ");
            this.m = 0;
            this.n = 0;
            return;
        }
        if (!(bl && !bl2 || bl3 && !bl4)) {
            return;
        }
        Object object = "invalid byte mapping in font ";
        if (bl && !bl2) {
            object = (String)object + " in low";
            object = bl3 && !bl4 ? (String)object + " and high interval" : (String)object + " interval";
        } else {
            object = (String)object + " in high interval";
        }
        LogManager.getApplicationLogger().error(object);
        this.m = 0;
        this.n = 0;
    }

    public static void writeUnicodeName(MemoryStream stream, char ch) {
        if (ch < '\u0010') {
            stream.write(d);
        } else if (ch < '\u0100') {
            stream.write(c);
        } else if (ch < '\u1000') {
            stream.write(b);
        } else if (ch < '\u10000') {
            stream.write(a);
        } else {
            stream.write(e);
        }
        stream.write(FontUtils.getBytes(Integer.toHexString(ch).toUpperCase()));
    }
}

