/*
 * Decompiled with CFR 0.152.
 */
package com.inet.font;

import com.inet.annotations.InternalApi;
import com.inet.annotations.JsonData;
import com.inet.font.unicode.UnicodeCharBlock;
import java.util.List;

@JsonData
@InternalApi
public class FontFamily {
    private String localizedName;
    private String defaultName;
    private boolean symbolicFont;
    private boolean isEmbedded;
    private boolean isInstalledInSystem;
    private boolean istype1;
    private String fontPath;
    private List<UnicodeCharBlock> charBlocks;
    private int fontRank;
    private int fontStyle = 0;
    private String faceName;
    private FontFamily next;
    private String fontFamilyClass = "SANSSERIF";
    private boolean isProblematic;

    private FontFamily() {
    }

    public FontFamily(String localizedName, String englishName) {
        this.localizedName = localizedName;
        this.defaultName = englishName;
        if (localizedName != null && (localizedName.trim().length() == 0 || localizedName.equals(this.defaultName))) {
            this.localizedName = null;
        }
    }

    public String getName() {
        return this.defaultName;
    }

    public String getLocalizedName() {
        return this.localizedName != null ? this.localizedName : this.defaultName;
    }

    public String toString() {
        return this.getLocalizedName();
    }

    public boolean hasLocalizedName() {
        return this.localizedName != null;
    }

    public boolean equals(Object obj) {
        if (obj instanceof FontFamily) {
            FontFamily fontFamily = (FontFamily)obj;
            return this.getName().equalsIgnoreCase(fontFamily.getName()) && this.getLocalizedName().equalsIgnoreCase(fontFamily.getLocalizedName());
        }
        return false;
    }

    public int hashCode() {
        int n2 = this.getName().toLowerCase().hashCode();
        int n3 = this.getLocalizedName().toLowerCase().hashCode();
        return n2 | n3 << 8;
    }

    public boolean isSymbolicFont() {
        return this.symbolicFont;
    }

    public void setSymbolicFlag() {
        this.symbolicFont = true;
    }

    public void setEmbedded(boolean isEmbedded) {
        this.isEmbedded = isEmbedded;
    }

    public boolean isEmbedded() {
        return this.isEmbedded;
    }

    public boolean isInstalledInSystem() {
        return this.isInstalledInSystem;
    }

    public void setInstalledInSystem() {
        this.isInstalledInSystem = true;
    }

    public void setFontPath(String fontPath) {
        this.fontPath = fontPath;
    }

    public String getFontPath() {
        return this.fontPath;
    }

    public void setUnicodeCharBlocks(List<UnicodeCharBlock> blocks) {
        this.charBlocks = blocks;
    }

    public List<UnicodeCharBlock> getUnicodeCharBlocks() {
        return this.charBlocks;
    }

    public void setFontRank(int fontRank) {
        this.fontRank = fontRank;
    }

    public int getFontRank() {
        return this.fontRank;
    }

    public void setStyle(int fontStyle) {
        this.fontStyle = fontStyle;
    }

    public void setFaceName(String faceName) {
        this.faceName = faceName;
    }

    public boolean isPlain() {
        return this.fontStyle == 0;
    }

    public int getStyle() {
        return this.fontStyle;
    }

    public FontFamily getNext() {
        return this.next;
    }

    public void setNext(FontFamily ffam) {
        this.next = ffam;
    }

    public void switchToFaceName() throws IllegalStateException {
        if (this.faceName == null) {
            throw new IllegalStateException("face name must be set for not plain font " + this.defaultName);
        }
        this.defaultName = this.faceName;
    }

    public void addOrReplace(FontFamily newFontFamily) {
        FontFamily fontFamily = this;
        FontFamily fontFamily2 = fontFamily.next;
        while (fontFamily2 != null) {
            if (fontFamily2.getStyle() == newFontFamily.getStyle()) {
                newFontFamily.next = fontFamily2.next;
                break;
            }
            fontFamily = fontFamily2;
            fontFamily2 = fontFamily.next;
        }
        fontFamily.next = newFontFamily;
    }

    public void setFamilyClass(String val) {
        this.fontFamilyClass = val;
    }

    public String getFontType() {
        return this.fontFamilyClass;
    }

    public boolean isType1() {
        return this.istype1;
    }

    public void setType1(boolean istype1) {
        this.istype1 = istype1;
    }

    public void setProblematic(boolean val) {
        this.isProblematic = val;
    }

    public boolean getIsProblematic() {
        return this.isProblematic;
    }
}

