/*
 * Decompiled with CFR 0.152.
 */
package com.inet.field.fieldtypes;

import com.inet.field.fieldtypes.FieldOperator;
import com.inet.field.fieldtypes.FieldType;
import com.inet.field.fieldtypes.FieldTypeFactory;
import com.inet.http.servlet.ClientLocale;
import com.inet.http.servlet.ClientTimezone;
import com.inet.lib.util.StringFunctions;
import com.inet.logging.LogManager;
import com.inet.search.SearchDataType;
import com.inet.search.SearchTag;
import com.inet.search.tokenizers.TextSearchTokenizer;
import java.text.DateFormat;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class FieldTypeDate
extends FieldType<Long> {
    private boolean a;

    public FieldTypeDate(String key, Supplier<String> displayname, boolean isDateWithTime) {
        super(key, displayname);
        this.a = isDateWithTime;
    }

    @Override
    @Nullable
    public String getDisplayValue(@Nullable Long value) {
        DateFormat dateFormat;
        if (value == null) {
            return null;
        }
        DateFormat dateFormat2 = dateFormat = this.a ? DateFormat.getDateTimeInstance(2, 2, ClientLocale.getThreadLocale()) : DateFormat.getDateInstance(2, ClientLocale.getThreadLocale());
        if (this.withTimezone()) {
            return dateFormat.format(new Date(value));
        }
        ZoneOffset zoneOffset = ZoneOffset.UTC;
        LocalDateTime localDateTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(value), zoneOffset);
        return dateFormat.format(new Date(localDateTime.toEpochSecond(ZoneOffset.ofHours(ClientTimezone.getTimeZone().getOffset(value) / 3600 / 1000)) * 1000L));
    }

    @Override
    public SearchTag createSearchTag(Supplier<String> labelProvider, @Nonnull FieldTypeFactory fieldTypeFactory) {
        return fieldTypeFactory.applyConfiguredChangesToSearchTag(new SearchTag(this.getKey(), SearchDataType.Date, true, TextSearchTokenizer.DEFAULT, 100, labelProvider, true));
    }

    public boolean withTimezone() {
        return true;
    }

    @Nullable
    public Long clientDateToPersistedDate(@Nullable Long date) {
        if (date == null) {
            return null;
        }
        if (this.withTimezone()) {
            return date;
        }
        ZoneId zoneId = ClientTimezone.getTimeZone().toZoneId();
        ZoneOffset zoneOffset = ZoneOffset.UTC;
        LocalDateTime localDateTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(date), zoneId);
        return localDateTime.toInstant(zoneOffset).toEpochMilli();
    }

    @Nullable
    public Long persistedDateToClientDate(@Nullable Long date) {
        if (date == null) {
            return null;
        }
        if (this.withTimezone()) {
            return date;
        }
        ZoneId zoneId = ClientTimezone.getTimeZone().toZoneId();
        ZoneOffset zoneOffset = ZoneOffset.UTC;
        LocalDateTime localDateTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(date), zoneOffset);
        return ZonedDateTime.ofLocal(localDateTime, zoneId, null).toEpochSecond() * 1000L;
    }

    @Override
    @Nullable
    public String asString(@Nullable Long value) {
        return StringFunctions.stringValueOf(this.persistedDateToClientDate(value));
    }

    @Override
    @Nullable
    public Long valueOf(@Nullable String value) {
        if (StringFunctions.isEmpty(value)) {
            return null;
        }
        try {
            Long l2 = Long.valueOf(value);
            return this.clientDateToPersistedDate(l2);
        }
        catch (NumberFormatException numberFormatException) {
            LogManager.getApplicationLogger().warn(numberFormatException);
            return null;
        }
    }

    public static FieldTypeDate withoutSearchtag(String key, boolean isDateWithTime) {
        return new FieldTypeDate(key, () -> null, isDateWithTime){

            @Override
            public SearchTag createSearchTag(Supplier<String> displayname, FieldTypeFactory fieldTypeFactory) {
                return null;
            }
        };
    }

    public boolean isDateWithTime() {
        return this.a;
    }

    @Override
    public boolean evaluateCondition(@Nullable String leftValue, @Nullable String rightValue, FieldOperator operator, Set<String> flags) {
        if (flags.contains("rightvalueisrelativedate")) {
            Long l2 = null;
            try {
                l2 = Long.valueOf(rightValue);
            }
            catch (NullPointerException | NumberFormatException runtimeException) {
                // empty catch block
            }
            if (l2 != null) {
                rightValue = String.valueOf(System.currentTimeMillis() + l2 * 60L * 1000L);
            }
        }
        return super.evaluateCondition(leftValue, rightValue, operator, flags);
    }

    @Override
    public Set<FieldOperator> getSupportedOperators() {
        return Set.of(FieldOperator.EQUALS, FieldOperator.EQUALS_NOT, FieldOperator.LESS_THAN, FieldOperator.GREATER_THAN, FieldOperator.GREATER_OR_EQUAL, FieldOperator.LESS_OR_EQUAL, FieldOperator.IS_NOT_EMPTY);
    }
}

