/*
 * Decompiled with CFR 0.152.
 */
package com.inet.field.fieldtypes;

import com.inet.field.fieldtypes.FieldTypeDouble;
import com.inet.field.fieldtypes.FieldTypeFactory;
import com.inet.logging.LogManager;
import com.inet.search.SearchTag;
import java.text.NumberFormat;
import java.util.Currency;
import java.util.Locale;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class FieldTypeCurrency
extends FieldTypeDouble {
    public FieldTypeCurrency(String key, Supplier<String> displayname) {
        super(key, displayname);
    }

    @Override
    @Nullable
    public String getDisplayValue(@Nullable Double value) {
        if (value == null) {
            return null;
        }
        Locale locale = Locale.getDefault();
        try {
            Currency.getInstance(locale);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            locale = Locale.US;
        }
        return NumberFormat.getCurrencyInstance(locale).format(value);
    }

    @Nonnull
    public static Currency getCurrency() {
        Locale locale = Locale.getDefault();
        Currency currency = null;
        try {
            currency = Currency.getInstance(locale);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            LogManager.getApplicationLogger().debug("Cannot load correct currency for locale " + locale.toString());
        }
        if (currency == null) {
            return Currency.getInstance(Locale.US);
        }
        return currency;
    }

    public static FieldTypeCurrency withoutSearchtag(String key) {
        return new FieldTypeCurrency(key, () -> null){

            @Override
            public SearchTag createSearchTag(Supplier<String> displayname, FieldTypeFactory fieldTypeFactory) {
                return null;
            }
        };
    }
}

