/*
 * Decompiled with CFR 0.152.
 */
package com.inet.config.structure.core;

import com.inet.annotations.InternalApi;
import com.inet.config.ConfigKey;
import com.inet.config.ConfigKeyParser;
import com.inet.config.ConfigurationManager;
import com.inet.config.LicenseInfo;
import com.inet.config.TempConfiguration;
import com.inet.config.internal.PrivateCloudLicenseTimerTask;
import com.inet.config.structure.ConfigStructure;
import com.inet.config.structure.core.license.LicenseConfigProperty;
import com.inet.config.structure.core.license.LicenseEntry;
import com.inet.config.structure.model.ConfigAction;
import com.inet.config.structure.model.ConfigCategory;
import com.inet.config.structure.model.ConfigCondition;
import com.inet.config.structure.model.ConfigConditionAction;
import com.inet.config.structure.model.ConfigGroup;
import com.inet.config.structure.model.ConfigProperty;
import com.inet.config.structure.model.ConfigPropertyGroup;
import com.inet.config.structure.model.ConfigValidationMsg;
import com.inet.config.structure.model.LocalizedKey;
import com.inet.config.structure.model.SelectConfigProperty;
import com.inet.config.structure.model.UnitConfigProperty;
import com.inet.config.structure.provider.AbstractStructureProvider;
import com.inet.config.structure.provider.ConditionGenerator;
import com.inet.config.structure.provider.ConfigStructureSettings;
import com.inet.config.structure.provider.ConfigValidator;
import com.inet.http.ClientMessageException;
import com.inet.http.servlet.ClientLocale;
import com.inet.lib.core.OS;
import com.inet.lib.json.Json;
import com.inet.lib.util.EncodingFunctions;
import com.inet.lib.util.IOFunctions;
import com.inet.lib.util.NetworkFunctions;
import com.inet.lib.util.StringFunctions;
import com.inet.logging.CoreLoggers;
import com.inet.logging.LogLevelsDefaults;
import com.inet.logging.LogManager;
import com.inet.persistence.Persistence;
import com.inet.plugin.ApplicationDescription;
import com.inet.plugin.ServerPluginManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.NetworkInterface;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.AccessController;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.SuppressFBWarnings;

@InternalApi
public class CoreSystemStructureProvider
extends AbstractStructureProvider {
    public static final CoreSystemStructureProvider INSTANCE = new CoreSystemStructureProvider();
    public static final String CATEGORY_LICENSE = "category.license";
    public static final String GROUP_LICENSE_KEY = "group.license.key";
    public static final String CATEGORY_LOGGING = "category.logging";
    private static final String CATEGORY_COMPANY_INFO = "category.companyinfo";
    private static final String PROPERTY_GROUP_COMPANY_INFO = "propertygroup.companyinfo";
    private static final String GROUP_LOGGING_LEVEL = "group.logging.level";
    private static final String GROUP_LOGGING_USERDEINFED_LEVEL_COLUMN1 = "group.logging.userdefinedlevel.column1";
    private static final String GROUP_LOGGING_USERDEINFED_LEVEL_COLUMN2 = "group.logging.userdefinedlevel.column2";
    private static final String GROUP_LOGGING_FORMAT = "group.logging.format";
    private static final String CATEGORY_EXECUTION = "category.execution";
    private static final String PROPERTY_GROUP_EXECUTION = "propertygroup.execution";
    private static final String CATEGORY_OTHER_OPTION = "category.other";
    private static final Integer a = 0;
    private static final Integer b = 1;
    private static final Integer c = 2;
    private static final Integer d = 3;
    private static final Integer e = 4;
    private static final Integer f = 5;
    public static final List<String> HOST_SERVICES = Arrays.asList("https://licensing.inetsoftware.de/hostname", "https://ipinfo.io/hostname");
    private static String g;
    private static int h;
    private static String i;
    private static Set<String> j;

    public static void addFilterPropertyLicense(String pluginID) {
        j.add(pluginID);
    }

    @Override
    public void addGroupsTo(@Nonnull Set<ConfigGroup> groups, boolean advanced, @Nonnull ConfigStructureSettings settings) {
        groups.add(new ConfigGroup(100, "categorygroup.system", this.translate(settings, "categorygroup.system", new Object[0]), this.getClass().getResource("server_categorygroup_system_48.png")));
    }

    @Override
    public void addCategoriesTo(@Nonnull Set<ConfigCategory> categories, @Nonnull String groupKey, boolean advanced, @Nonnull ConfigStructureSettings settings) {
        switch (groupKey) {
            case "categorygroup.system": {
                if (!CoreSystemStructureProvider.isDesigner()) {
                    categories.add(new ConfigCategory(99, CATEGORY_COMPANY_INFO, this.translate(settings, CATEGORY_COMPANY_INFO, new Object[0]), "system-companyinfo"));
                }
                categories.add(new ConfigCategory(100, CATEGORY_LICENSE, this.translate(settings, CATEGORY_LICENSE, new Object[0]), "system-license"));
                categories.add(new ConfigCategory(500, CATEGORY_LOGGING, this.translate(settings, CATEGORY_LOGGING, new Object[0]), "system-logging"));
                if (!advanced) break;
                if (!CoreSystemStructureProvider.isDesigner()) {
                    categories.add(new ConfigCategory(600, CATEGORY_EXECUTION, this.translate(settings, CATEGORY_EXECUTION, new Object[0]), "performance-execution"));
                }
                categories.add(new ConfigCategory(1000, CATEGORY_OTHER_OPTION, this.translate(settings, CATEGORY_OTHER_OPTION, new Object[0]), "system-other-options"));
                break;
            }
        }
    }

    @Override
    public URL getCategoryIcon(@Nonnull String categoryKey) {
        switch (categoryKey) {
            case "category.license": {
                return this.getClass().getResource("licensekey_48.png");
            }
            case "category.logging": {
                return this.getClass().getResource("logging_48.png");
            }
            case "category.companyinfo": {
                return this.getClass().getResource("company_info_48.png");
            }
            case "category.execution": {
                return this.getClass().getResource("execution_48.png");
            }
            case "category.other": {
                return this.getClass().getResource("other_48.png");
            }
        }
        return null;
    }

    @Override
    public void addPropertyGroupsTo(@Nonnull Set<ConfigPropertyGroup> propertyGroups, @Nonnull String categoryKey, boolean advanced, @Nonnull ConfigStructureSettings settings) {
        switch (categoryKey) {
            case "category.companyinfo": {
                propertyGroups.add(new ConfigPropertyGroup(100, PROPERTY_GROUP_COMPANY_INFO));
                break;
            }
            case "category.license": {
                propertyGroups.add(new ConfigPropertyGroup(200, GROUP_LICENSE_KEY, this.translate(settings, GROUP_LICENSE_KEY, new Object[0])));
                break;
            }
            case "category.logging": {
                propertyGroups.add(new ConfigPropertyGroup(100, GROUP_LOGGING_LEVEL));
                ConfigPropertyGroup configPropertyGroup = new ConfigPropertyGroup(200, GROUP_LOGGING_USERDEINFED_LEVEL_COLUMN1);
                configPropertyGroup.setColumnSet(ConfigPropertyGroup.COLUMN_SET.twoColumnsIntended);
                propertyGroups.add(configPropertyGroup);
                ConfigPropertyGroup configPropertyGroup2 = new ConfigPropertyGroup(250, GROUP_LOGGING_USERDEINFED_LEVEL_COLUMN2);
                configPropertyGroup2.setColumnSet(ConfigPropertyGroup.COLUMN_SET.twoColumnsIntended);
                propertyGroups.add(configPropertyGroup2);
                propertyGroups.add(new ConfigPropertyGroup(300, GROUP_LOGGING_FORMAT));
                break;
            }
            case "category.execution": {
                propertyGroups.add(new ConfigPropertyGroup(100, PROPERTY_GROUP_EXECUTION));
                break;
            }
            case "category.other": {
                propertyGroups.add(new ConfigPropertyGroup(100, CATEGORY_OTHER_OPTION));
                break;
            }
        }
    }

    @Override
    public void addConditionsTo(@Nonnull List<ConfigConditionAction> actions, @Nonnull String categoryKey, boolean advanced, @Nonnull ConfigStructureSettings settings) {
        ConditionGenerator conditionGenerator = new ConditionGenerator();
        switch (categoryKey) {
            case "category.logging": {
                ConfigCondition configCondition = conditionGenerator.createCondition().property(ConfigKey.LOG_DRIVER).equals().value(Boolean.TRUE);
                ConfigCondition configCondition2 = conditionGenerator.createCondition().not(conditionGenerator.createCondition().property(ConfigKey.LOG_LEVELS).equals().value("-1"));
                ConfigCondition configCondition3 = conditionGenerator.createCondition().property(ConfigKey.LOG_LEVELS).equals().value("0");
                ConfigCondition configCondition4 = conditionGenerator.createCondition().property(ConfigKey.LOG_LEVELS).equals().value("1");
                ConfigCondition configCondition5 = conditionGenerator.createCondition().property(ConfigKey.LOG_LEVELS).equals().value("2");
                ConfigCondition configCondition6 = conditionGenerator.createCondition().property(ConfigKey.LOG_LEVELS).equals().value("3");
                ConfigCondition configCondition7 = conditionGenerator.createCondition().property(ConfigKey.LOG_LEVELS).equals().value("4");
                ConfigCondition configCondition8 = conditionGenerator.createCondition().property(ConfigKey.LOG_LEVELS).equals().value("5");
                ConfigCondition configCondition9 = conditionGenerator.createCondition().property(ConfigKey.LOG_LEVELS).gt().value("0");
                configCondition9 = conditionGenerator.createCondition().and(configCondition9, conditionGenerator.createCondition().property(ConfigKey.LOG_LEVELS).lt().value("5"));
                LogLevelsDefaults logLevelsDefaults = CoreSystemStructureProvider.a(settings);
                List<String> list = LogManager.getCreatedLoggerNames();
                LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>(list);
                linkedHashSet.addAll(CoreLoggers.CORE_LOGGERS);
                linkedHashSet.addAll(logLevelsDefaults.keySet());
                for (String object : linkedHashSet) {
                    String string = ConfigKey.LOG_LEVELS.getKey() + "." + object;
                    if (CoreLoggers.CORE_LOGGERS.contains(object)) {
                        actions.add(conditionGenerator.setValueActionFor(configCondition3, string, "0"));
                        actions.add(conditionGenerator.setValueActionFor(configCondition4, string, "1"));
                        actions.add(conditionGenerator.setValueActionFor(configCondition5, string, "2"));
                        actions.add(conditionGenerator.setValueActionFor(configCondition6, string, "3"));
                        actions.add(conditionGenerator.setValueActionFor(configCondition7, string, "4"));
                    } else {
                        actions.add(conditionGenerator.setValueActionFor(configCondition3, string, "0"));
                        actions.add(conditionGenerator.setValueActionFor(configCondition9, string, "1"));
                    }
                    if (!list.contains(object)) continue;
                    actions.add(conditionGenerator.visibleActionFor(configCondition8, string));
                    actions.add(conditionGenerator.enableActionFor(configCondition2, string));
                }
                ConfigCondition configCondition10 = conditionGenerator.createCondition().or(configCondition2, configCondition);
                if (advanced) {
                    actions.add(conditionGenerator.enableActionFor(configCondition10, ConfigKey.LOG_DATEFORMAT));
                    configCondition = conditionGenerator.createCondition().and(configCondition10, conditionGenerator.createCondition().not(conditionGenerator.createCondition().property(ConfigKey.LOG_FILE).equals().value("")));
                    actions.add(conditionGenerator.enableActionFor(configCondition, ConfigKey.LOG_MAXSIZE));
                    actions.add(conditionGenerator.enableActionFor(configCondition, ConfigKey.LOG_MAXNUMBER));
                }
                actions.add(conditionGenerator.enableActionFor(configCondition10, ConfigKey.LOG_FILE));
                actions.add(conditionGenerator.visibleActionFor(configCondition8, GROUP_LOGGING_USERDEINFED_LEVEL_COLUMN1));
                actions.add(conditionGenerator.visibleActionFor(configCondition8, GROUP_LOGGING_USERDEINFED_LEVEL_COLUMN2));
                break;
            }
            case "category.companyinfo": {
                ConfigCondition configCondition = conditionGenerator.createCondition().not(conditionGenerator.createCondition().property(ConfigKey.IMPRINT_CONTENT_URL).equals().value(""));
                actions.add(conditionGenerator.enableActionFor(configCondition, ConfigKey.IMPRINT_CONTENT_LINKTEXT));
                break;
            }
        }
    }

    @Override
    public void addPropertiesTo(@Nonnull Set<ConfigProperty> configProperties, @Nonnull String propertyGroupKey, boolean advanced, final @Nonnull ConfigStructureSettings settings) {
        switch (propertyGroupKey) {
            case "propertygroup.companyinfo": {
                String[] stringArray;
                if (ServerPluginManager.getInstance().isPluginLoaded("mail")) {
                    stringArray = CoreSystemStructureProvider.getSupportEmail(settings.getValue(ConfigKey.SUPPORT_EMAIL), settings.getLicense());
                    this.addTo(configProperties, ConfigKey.SUPPORT_EMAIL.getKey(), "SimpleText", (String)stringArray, settings);
                }
                if (!CoreSystemStructureProvider.isDesigner()) {
                    this.addTo(configProperties, ConfigKey.PRODUCT_NAME, settings, ApplicationDescription.get().getApplicationName());
                    stringArray = new String[]{"*.(png|jpg|jpeg|bmp|gif)", "*.png", "*.(jpg|jpeg)", "*.bmp", "*.gif"};
                    this.addFileOrUploadTo(configProperties, ConfigKey.IMPRINT_LOGO_URL, settings, "image/*", stringArray);
                    this.addTo(configProperties, ConfigKey.IMPRINT_LOGO_WITH_TEXT, settings);
                    this.addTo(configProperties, "imprint.logo.preview", "logopreview", settings);
                    this.addTo(configProperties, ConfigKey.IMPRINT_CONTENT_URL, settings);
                    this.addTo(configProperties, ConfigKey.IMPRINT_CONTENT_LINKTEXT, settings, this.translate(settings, "imprint.linktitle", new Object[0]));
                }
                if (!advanced) break;
                this.addTo(configProperties, ConfigKey.SERVER_URL, settings, ConfigKey.SERVER_URL.getDefault());
                break;
            }
            case "group.license.key": {
                for (String string : j) {
                    if (!string.equals(ServerPluginManager.getInstance().getCorePluginId())) continue;
                    return;
                }
                configProperties.add(new LicenseConfigProperty(settings));
                break;
            }
            case "group.logging.level": {
                ArrayList<LocalizedKey> arrayList = new ArrayList<LocalizedKey>();
                String string = "";
                arrayList.add(new LocalizedKey("-1", this.translate(settings, "log.levels.NONE", new Object[0])));
                arrayList.add(new LocalizedKey("0", this.translate(settings, "log.levels.STATUS", new Object[0])));
                arrayList.add(new LocalizedKey("1", this.translate(settings, "log.levels.ERROR", new Object[0])));
                arrayList.add(new LocalizedKey("2", this.translate(settings, "log.levels.WARN", new Object[0])));
                arrayList.add(new LocalizedKey("3", this.translate(settings, "log.levels.INFO", new Object[0])));
                arrayList.add(new LocalizedKey("4", this.translate(settings, "log.levels.DEBUG", new Object[0])));
                arrayList.add(new LocalizedKey("5", this.translate(settings, "log.levels.CUSTOM", new Object[0])));
                LogLevelsDefaults logLevelsDefaults = CoreSystemStructureProvider.a(settings);
                string = Boolean.parseBoolean(settings.getValue(ConfigKey.LOG_ENGINE)) ? CoreSystemStructureProvider.a(logLevelsDefaults).toString() : "-1";
                this.addSelectTo(configProperties, ConfigKey.LOG_LEVELS.getKey(), string, "SimpleText", settings, arrayList);
                break;
            }
            case "group.logging.userdefinedlevel.column1": 
            case "group.logging.userdefinedlevel.column2": {
                ArrayList<LocalizedKey> arrayList = new ArrayList<LocalizedKey>();
                arrayList.add(new LocalizedKey("0", this.translate(settings, "log.levels.STATUS", new Object[0])));
                arrayList.add(new LocalizedKey("1", this.translate(settings, "log.levels.ERROR", new Object[0])));
                arrayList.add(new LocalizedKey("2", this.translate(settings, "log.levels.WARN", new Object[0])));
                arrayList.add(new LocalizedKey("3", this.translate(settings, "log.levels.INFO", new Object[0])));
                arrayList.add(new LocalizedKey("4", this.translate(settings, "log.levels.DEBUG", new Object[0])));
                LogLevelsDefaults logLevelsDefaults = CoreSystemStructureProvider.a(settings);
                List<String> list = LogManager.getCreatedLoggerNames();
                HashSet<String> hashSet = new HashSet<String>();
                hashSet.addAll(CoreLoggers.CORE_LOGGERS);
                hashSet.addAll(list);
                hashSet.addAll(logLevelsDefaults.keySet());
                ArrayList arrayList2 = new ArrayList(hashSet);
                Collections.sort(arrayList2, String.CASE_INSENSITIVE_ORDER);
                int n2 = list.size();
                int n3 = 0;
                for (String string : arrayList2) {
                    String string2 = ConfigKey.LOG_LEVELS.getKey() + "." + string;
                    String string3 = logLevelsDefaults.get(string).toString();
                    if (list.contains(string)) {
                        if (GROUP_LOGGING_USERDEINFED_LEVEL_COLUMN1.equals(propertyGroupKey) && n3 < n2 / 2 || GROUP_LOGGING_USERDEINFED_LEVEL_COLUMN2.equals(propertyGroupKey) && n3 >= n2 / 2) {
                            configProperties.add(new SelectConfigProperty(configProperties.size() * 100, string2, "SimpleText", string, (Object)string3, null, arrayList));
                        }
                        ++n3;
                        continue;
                    }
                    if (!GROUP_LOGGING_USERDEINFED_LEVEL_COLUMN1.equals(propertyGroupKey)) continue;
                    configProperties.add(new ConfigProperty(configProperties.size() * 100, string2, "Hidden", string, string3, null, null));
                }
                break;
            }
            case "group.logging.format": {
                this.addTo(configProperties, ConfigKey.LOG_DRIVER, settings);
                this.addFileTo(configProperties, ConfigKey.LOG_FILE, settings, System.getProperty("user.dir"), System.getProperty("user.dir"), new String[]{"*.log"});
                if (!advanced) break;
                this.addTo(configProperties, ConfigKey.LOG_MAXSIZE, settings);
                this.addTo(configProperties, ConfigKey.LOG_MAXNUMBER, settings);
                this.addTo(configProperties, ConfigKey.LOG_DATEFORMAT, settings);
                break;
            }
            case "propertygroup.execution": {
                int n4 = ApplicationDescription.get().getDefaultNumberOfJobs();
                this.addTo(configProperties, ConfigKey.JOB_CONCURRENT_TASKS, this.getDefaultType(ConfigKey.JOB_CONCURRENT_TASKS), settings, String.valueOf(n4));
                ArrayList<UnitConfigProperty.Unit> arrayList = new ArrayList<UnitConfigProperty.Unit>(){
                    {
                        this.add(new UnitConfigProperty.Unit(1.0, CoreSystemStructureProvider.this.translate(settings, "Seconds", new Object[0])));
                        this.add(new UnitConfigProperty.Unit(0.016666666666666666, CoreSystemStructureProvider.this.translate(settings, "Minutes", new Object[0])));
                    }
                };
                long l2 = Long.parseLong(settings.getValue(ConfigKey.JOB_TIME_UNTIL_NEXT_JOB_PAUSED));
                this.addUnitTo(configProperties, ConfigKey.JOB_TIME_UNTIL_NEXT_JOB_PAUSED.getKey(), String.valueOf(l2 / 1000L), "FixNumber", settings, (List<UnitConfigProperty.Unit>)arrayList, Long.parseLong(ConfigKey.JOB_TIME_UNTIL_NEXT_JOB_PAUSED.getDefault()) / 1000L + " " + this.translate(settings, "Seconds", new Object[0]));
                ArrayList<UnitConfigProperty.Unit> arrayList3 = new ArrayList<UnitConfigProperty.Unit>(){
                    {
                        this.add(new UnitConfigProperty.Unit(1.0, CoreSystemStructureProvider.this.translate(settings, "Minutes", new Object[0])));
                        this.add(new UnitConfigProperty.Unit(0.016666666666666666, CoreSystemStructureProvider.this.translate(settings, "Hours", new Object[0])));
                    }
                };
                l2 = Long.parseLong(settings.getValue(ConfigKey.JOB_TIMEOUT));
                this.addUnitTo(configProperties, ConfigKey.JOB_TIMEOUT.getKey(), String.valueOf(l2 / 60L), "FixNumber", settings, (List<UnitConfigProperty.Unit>)arrayList3, Long.parseLong(ConfigKey.JOB_TIMEOUT.getDefault()) / 60L + " " + this.translate(settings, "Minutes", new Object[0]));
                l2 = Long.parseLong(settings.getValue(ConfigKey.JOB_TIMEOUT_HARDKILL));
                this.addUnitTo(configProperties, ConfigKey.JOB_TIMEOUT_HARDKILL.getKey(), String.valueOf(l2 / 60L), "FixNumber", settings, (List<UnitConfigProperty.Unit>)arrayList3, Long.parseLong(ConfigKey.JOB_TIMEOUT_HARDKILL.getDefault()) / 60L + " " + this.translate(settings, "Minutes", new Object[0]));
                break;
            }
            case "category.other": {
                Object[] objectArray;
                this.addTo(configProperties, "Other.hint", "Label", settings);
                ArrayList<String[]> arrayList = new ArrayList<String[]>();
                for (String object2 : settings.keySet()) {
                    if (ConfigKey.valueOf(object2) != null) continue;
                    objectArray = new String[]{object2, settings.getValue(object2)};
                    arrayList.add((String[])objectArray);
                }
                Collections.sort(arrayList, new Comparator<String[]>(){

                    public int a(String[] stringArray, String[] stringArray2) {
                        String string = stringArray[0];
                        String string2 = stringArray2[0];
                        if (string == null) {
                            return string2 == null ? 0 : 1;
                        }
                        if (string2 == null) {
                            return -1;
                        }
                        return string.compareTo(string2);
                    }

                    @Override
                    public /* synthetic */ int compare(Object object, Object object2) {
                        return this.a((String[])object, (String[])object2);
                    }
                });
                ConfigProperty configProperty = new ConfigProperty(0, "", "SimpleText", this.translate(settings, "variablename", new Object[0]), null, null, null);
                ConfigProperty configProperty2 = new ConfigProperty(0, "", "SimpleText", this.translate(settings, "variablevalue", new Object[0]), null, null, null);
                objectArray = new ConfigAction[]{new ConfigAction(this.translate(settings, "Other.add", new Object[0]))};
                int[] nArray = new int[]{33, 67};
                this.addTableTo(configProperties, "Other", "", settings, arrayList, (ConfigAction[])objectArray, nArray, configProperty, configProperty2);
                break;
            }
        }
    }

    @Override
    public void validate(@Nullable String categoryKey, @Nonnull ArrayList<ConfigValidationMsg> messages, @Nonnull ArrayList<ConfigConditionAction> conditions, @Nonnull ConfigStructureSettings settings) {
        Object object;
        Object object2;
        Object object3;
        ConfigValidator configValidator = new ConfigValidator(messages, settings);
        if (categoryKey == null || categoryKey.equals(CATEGORY_LOGGING)) {
            object3 = settings.getValue(ConfigKey.LOG_DATEFORMAT);
            if (object3 != null && settings.isValidatable(ConfigKey.LOG_DATEFORMAT, conditions) && (object3 = object3.trim()).length() > 0) {
                try {
                    new SimpleDateFormat((String)object3);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    messages.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, StringFunctions.getUserFriendlyErrorMessage(illegalArgumentException), ConfigKey.LOG_DATEFORMAT));
                }
            }
            if (settings.isValidatable(ConfigKey.LOG_FILE, conditions)) {
                configValidator.checkWritableFilePossible(ConfigKey.LOG_FILE);
            }
            if (settings.isValidatable(ConfigKey.LOG_MAXSIZE, conditions)) {
                configValidator.validateNumberRange(ConfigKey.LOG_MAXSIZE, 0L, 1024L);
            }
            if (settings.isValidatable(ConfigKey.LOG_MAXNUMBER, conditions)) {
                configValidator.validateNumberRange(ConfigKey.LOG_MAXNUMBER, 0L, 500L);
            }
        }
        if (categoryKey == null || categoryKey.equals(CATEGORY_COMPANY_INFO)) {
            object3 = null;
            boolean bl = false;
            try {
                if (!ConfigurationManager.isRecoveryMode()) {
                    object3 = new URL(settings.getValue(ConfigKey.SERVER_URL));
                    bl = PrivateCloudLicenseTimerTask.isKnown((URL)object3);
                    PrivateCloudLicenseTimerTask.externalUrlAssignable((URL)object3);
                }
            }
            catch (Throwable throwable) {
                object3 = null;
                bl = false;
            }
            if (ServerPluginManager.getInstance().isPluginLoaded("mail")) {
                configValidator.validateEmails(ConfigKey.SUPPORT_EMAIL);
            }
            configValidator.validateFileOrURL(ConfigKey.IMPRINT_LOGO_URL);
            configValidator.validateHttpURL(ConfigKey.IMPRINT_CONTENT_URL);
            configValidator.validateHttpURL(ConfigKey.SERVER_URL);
            if (object3 != null && messages.size() == 0 && !ConfigurationManager.isRecoveryMode()) {
                if (!bl) {
                    for (int i2 = 0; i2 < 20 && PrivateCloudLicenseTimerTask.externalUrlAssignable((URL)object3) != null; ++i2) {
                        try {
                            Thread.sleep(1L);
                            continue;
                        }
                        catch (InterruptedException interruptedException) {
                            return;
                        }
                    }
                }
                if ((object2 = PrivateCloudLicenseTimerTask.externalUrlAssignable((URL)object3)) != null) {
                    messages.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Warning, (String)object2, ConfigKey.SERVER_URL));
                }
            }
        }
        if (categoryKey == null || categoryKey.equals(CATEGORY_EXECUTION)) {
            configValidator.validateNumberRange(ConfigKey.JOB_CONCURRENT_TASKS, 0L, Integer.MAX_VALUE);
            object3 = settings.getChangedValue(ConfigKey.JOB_TIME_UNTIL_NEXT_JOB_PAUSED.getKey());
            if (object3 == null) {
                object3 = settings.getOriginalValue(ConfigKey.JOB_TIME_UNTIL_NEXT_JOB_PAUSED);
                int n2 = Integer.parseInt((String)object3);
                object3 = String.valueOf(n2 / 1000);
            } else if (object3.trim().isEmpty()) {
                object3 = ConfigKey.JOB_TIME_UNTIL_NEXT_JOB_PAUSED.getDefault();
                int n3 = Integer.parseInt((String)object3);
                object3 = String.valueOf(n3 / 1000);
            }
            configValidator.validateNumberRange(ConfigKey.JOB_TIME_UNTIL_NEXT_JOB_PAUSED.getKey(), (String)object3, 1L, 2147483L);
            object = settings.getChangedValue(ConfigKey.JOB_TIMEOUT.getKey());
            if (object == null) {
                object = settings.getOriginalValue(ConfigKey.JOB_TIMEOUT);
                int n4 = Integer.parseInt((String)object);
                object = String.valueOf(n4 / 60);
            } else if (((String)object).trim().isEmpty()) {
                object = ConfigKey.JOB_TIMEOUT.getDefault();
                int n5 = Integer.parseInt((String)object);
                object = String.valueOf(n5 / 60);
            }
            configValidator.validateNumberRange(ConfigKey.JOB_TIMEOUT.getKey(), (String)object, 0L, 0x2222222L);
            object2 = settings.getChangedValue(ConfigKey.JOB_TIMEOUT_HARDKILL.getKey());
            if (object2 == null) {
                object2 = settings.getOriginalValue(ConfigKey.JOB_TIMEOUT_HARDKILL);
                var9_18 = Integer.parseInt((String)object2);
                object2 = String.valueOf(var9_18 / 60);
            } else if (((String)object2).trim().isEmpty()) {
                object2 = ConfigKey.JOB_TIMEOUT_HARDKILL.getDefault();
                var9_18 = Integer.parseInt((String)object2);
                object2 = String.valueOf(var9_18 / 60);
            }
            configValidator.validateNumberRange(ConfigKey.JOB_TIMEOUT_HARDKILL.getKey(), (String)object2, 0L, 0x2222222L);
        }
        if ((categoryKey == null || categoryKey.equals(CATEGORY_OTHER_OPTION)) && (object3 = settings.getChangedValue("Other", String[][].class)) != null) {
            object = new HashSet();
            for (String[] stringArray : object3) {
                String string = stringArray[0].trim();
                if (string.isEmpty()) {
                    messages.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, this.translate(settings, "config.otheroption.add.emptyname", new Object[0]), "Other"));
                } else if (ConfigKey.valueOf(string) != null || ((HashSet)object).contains(string)) {
                    messages.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, this.translate(settings, "config.otheroption.add.already_exists", string), "Other"));
                } else if (string.length() > 80) {
                    messages.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, this.translate(settings, "config.otheroption.add.toolong", string), "Other"));
                }
                StringBuilder stringBuilder = new StringBuilder();
                for (int i3 = 0; i3 < string.length(); ++i3) {
                    char c2 = string.charAt(i3);
                    if ((i3 != 0 || Character.isJavaIdentifierStart(c2)) && (i3 == 0 || Character.isJavaIdentifierPart(c2) || c2 == '.')) continue;
                    stringBuilder.append(c2);
                }
                if (stringBuilder.length() > 0) {
                    messages.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, this.translate(settings, "config.otheroption.add.illegal_chars", string, stringBuilder.toString()), "Other"));
                }
                ((HashSet)object).add(string);
            }
        }
    }

    public static final void requestTrialLicense(ConfigStructureSettings settings) {
        List<LicenseEntry> list = LicenseConfigProperty.getLicenseList(settings);
        try {
            String string = CoreSystemStructureProvider.a(settings, null).trim();
            for (LicenseEntry licenseEntry : list) {
                String string2 = licenseEntry.getLicenseKey();
                if (!Objects.equals(string2, string)) continue;
                throw new ClientMessageException(INSTANCE.translate(settings, "error.duplicate.trial.license", ApplicationDescription.get().getDefaultSupportAddress()));
            }
            LicenseConfigProperty.addLicensesTo(list, string, settings);
            settings.setLicenseKey(new Json().toJson(list));
        }
        catch (IOException iOException) {
            Object object;
            LogManager.getConfigLogger().error(iOException);
            Object object2 = StringFunctions.getUserFriendlyErrorMessage(iOException);
            ApplicationDescription applicationDescription = ApplicationDescription.get();
            String string = applicationDescription.getTrialLicenseBrowserURL();
            if (string != null) {
                object = string;
                try {
                    URL uRL = new URL(string);
                    object = uRL.getProtocol() + "://" + uRL.getHost();
                }
                catch (MalformedURLException malformedURLException) {
                    LogManager.getConfigLogger().error(malformedURLException);
                }
                object2 = (String)object2 + "<br><br>Please try the following URL: <a href=\"" + string + "\" target=\"_blank\">" + (String)object + "</a>";
            }
            if (iOException instanceof UnknownHostException) {
                object = ApplicationDescription.get().getDefaultSupportAddress();
                object2 = INSTANCE.translate(settings, "license.trial.noConnectionToServer", object) + (String)object2;
            }
            throw new ClientMessageException((String)object2, true);
        }
    }

    @SuppressFBWarnings(value={"URLCONNECTION_SSRF_FD"}, justification="fix URL used")
    private static String a(@Nonnull ConfigStructureSettings configStructureSettings, @Nullable String string) throws IOException {
        Object object;
        ApplicationDescription applicationDescription = ApplicationDescription.get();
        String string2 = string != null ? string : applicationDescription.getApplicationName();
        LogManager.getConfigLogger().debug("Requesting Trial License: " + string2);
        String string3 = configStructureSettings.getValue("license.generateTrial.ip");
        if (string3 == null) {
            object = ConfigurationManager.getInstance().getAvailableIPAddresses();
            string3 = ((InetAddress[])object).length == 0 ? "" : ((InetAddress)object[0]).getHostAddress();
        }
        object = new StringBuilder("https://licensing.inetsoftware.de?ip=");
        ((StringBuilder)object).append(string3);
        ((StringBuilder)object).append("&version=").append(applicationDescription.getVersion().getMajor());
        ((StringBuilder)object).append("&host=").append(EncodingFunctions.encodeUrlParameter(NetworkFunctions.getLocalHostName()));
        ((StringBuilder)object).append("&app=").append(EncodingFunctions.encodeUrlParameter(string2));
        applicationDescription.appendTrialLicenseParameters((StringBuilder)object, configStructureSettings);
        URL uRL = new URL(((StringBuilder)object).toString());
        URLConnection uRLConnection = uRL.openConnection();
        uRLConnection.setConnectTimeout(5000);
        uRLConnection.setReadTimeout(5000);
        uRLConnection.setRequestProperty("Connection", "close");
        try {
            String string4;
            block12: {
                InputStream inputStream = uRLConnection.getInputStream();
                try {
                    string4 = IOFunctions.readAsciiString(inputStream);
                    if (inputStream == null) break block12;
                }
                catch (Throwable throwable) {
                    try {
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException iOException) {
                        LogManager.getConfigLogger().debug(uRL);
                        throw iOException;
                    }
                }
                inputStream.close();
            }
            return string4;
        }
        finally {
            LogManager.getConfigLogger().debug("Trial License was requested: " + string2);
        }
    }

    public static String requestTrialLicenseKey() throws IOException {
        return CoreSystemStructureProvider.requestTrialLicenseKey(null);
    }

    public static String requestTrialLicenseKey(@Nullable String feature) throws IOException {
        TempConfiguration tempConfiguration = new TempConfiguration("");
        Locale locale = ClientLocale.getThreadLocale();
        Properties properties = new Properties();
        ConfigStructureSettings configStructureSettings = new ConfigStructureSettings(tempConfiguration, locale, properties);
        return CoreSystemStructureProvider.a(configStructureSettings, feature);
    }

    @Nonnull
    public static String getMessageFromIsDockerMethod() {
        return i;
    }

    public static boolean isDocker() {
        if (h < 0) {
            AccessController.doPrivileged(() -> {
                AtomicInteger atomicInteger = new AtomicInteger(0);
                AtomicReference<String> atomicReference = new AtomicReference<String>("");
                try {
                    boolean bl = false;
                    if (OS.isLinux()) {
                        if (new File("/.dockerenv").exists()) {
                            atomicReference.set("Docker environment detected");
                            atomicInteger.incrementAndGet();
                        } else if (new File("/etc/heroku").exists() || new File("/app/.heroku").exists() || new File("/dev/herokudev").exists()) {
                            atomicReference.set("Heroku detected.");
                            atomicInteger.addAndGet(2);
                        }
                        if (System.getenv("DYNO") != null) {
                            atomicReference.set("Dyno environment detected");
                            atomicInteger.incrementAndGet();
                        }
                        if (System.getenv("DOCKER_EXPOSED_PORT") != null) {
                            atomicReference.set("Jelastic environment detected");
                            atomicInteger.incrementAndGet();
                            if (System.getenv("MASTER_IP") != null || System.getenv("MASTER_HOST") != null) {
                                atomicReference.set(atomicReference.get() + ".");
                                atomicInteger.incrementAndGet();
                            }
                        }
                        try {
                            Object object = Files.getAttribute(Path.of("/", new String[0]), "unix:ino", new LinkOption[0]);
                            if (object instanceof Number && ((Number)object).longValue() > 1000L) {
                                atomicInteger.incrementAndGet();
                            }
                        }
                        catch (Throwable throwable) {
                            LogManager.getConfigLogger().error(throwable);
                        }
                        CoreSystemStructureProvider.a(atomicInteger, atomicReference, "cgroup");
                        CoreSystemStructureProvider.a(atomicInteger, atomicReference, "mountinfo");
                        bl = CoreSystemStructureProvider.a(atomicInteger.get());
                    } else if (OS.isWindows()) {
                        Object object;
                        if (new File("C:/Users/ContainerAdministrator").exists()) {
                            atomicReference.set("ContainerAdministrator detected");
                            atomicInteger.incrementAndGet();
                        }
                        try {
                            object = NetworkInterface.getNetworkInterfaces();
                            while (object.hasMoreElements()) {
                                NetworkInterface networkInterface = object.nextElement();
                                String string = networkInterface.getDisplayName();
                                if (string.contains("Hyper-V Virtual Ethernet Adapter")) {
                                    atomicReference.set("Hyper-V Virtual Ethernet Adapter detected");
                                    atomicInteger.incrementAndGet();
                                } else {
                                    if (!string.contains("Hyper-V Virtual Ethernet Container Adapter")) continue;
                                    atomicReference.set("Hyper-V Virtual Ethernet Container Adapter detected");
                                    atomicInteger.incrementAndGet();
                                }
                                break;
                            }
                        }
                        catch (Throwable throwable) {
                            LogManager.getConfigLogger().error(throwable);
                        }
                        try {
                            object = IOFunctions.readAsciiString(Runtime.getRuntime().exec("cmd /c sc query | find \"cexecsvc\"").getInputStream());
                            if (!StringFunctions.isEmpty((String)object)) {
                                atomicReference.set("Service cexecsvc detected");
                                atomicInteger.incrementAndGet();
                            }
                        }
                        catch (Throwable throwable) {
                            LogManager.getConfigLogger().error(throwable);
                        }
                        bl = CoreSystemStructureProvider.a(atomicInteger.get());
                    }
                    if (bl) {
                        atomicReference.set("AWS environment detected");
                        atomicInteger.addAndGet(2);
                    }
                }
                catch (SecurityException securityException) {
                    LogManager.getConfigLogger().debug(securityException);
                }
                h = atomicInteger.get();
                if (!atomicReference.get().isEmpty()) {
                    LogManager.getConfigLogger().debug(atomicReference);
                }
                i = atomicReference.get();
                return null;
            });
        }
        return h >= 2;
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="The resource is restrcited to known locations without external user input")
    private static void a(AtomicInteger atomicInteger, AtomicReference<String> atomicReference, String string) {
        block9: {
            try (BufferedReader bufferedReader = Files.newBufferedReader(Paths.get("/proc/self/" + string, new String[0]), StandardCharsets.UTF_8);){
                String string2;
                do {
                    if ((string2 = bufferedReader.readLine()) != null) continue;
                    break block9;
                } while (!string2.contains("/docker/") && !string2.contains("/lxc/") && !string2.contains("/kubepods") && !string2.contains("/containerd") && !string2.contains("/cri-containerd") && !string2.contains("/podman") || string2.endsWith("/"));
                atomicReference.set("Docker environment detected");
                atomicInteger.incrementAndGet();
            }
            catch (Throwable throwable) {
                LogManager.getConfigLogger().error(throwable);
            }
        }
    }

    private static boolean a(int n2) {
        if (n2 < 2) {
            boolean bl;
            block9: {
                URLConnection uRLConnection = new URL("http://169.254.169.254/latest/dynamic/instance-identity/").openConnection();
                uRLConnection.setConnectTimeout(1000);
                uRLConnection.setReadTimeout(1000);
                InputStream inputStream = uRLConnection.getInputStream();
                try {
                    String string = IOFunctions.readAsciiString(inputStream);
                    LogManager.getConfigLogger().debug(string);
                    boolean bl2 = bl = string.length() > 0;
                    if (inputStream == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                inputStream.close();
            }
            return bl;
        }
        return false;
    }

    @SuppressFBWarnings(value={"URLCONNECTION_SSRF_FD"}, justification="Only fix URLs are used")
    public static String getPublicDomain() {
        if (g == null) {
            for (String string : HOST_SERVICES) {
                try {
                    URLConnection uRLConnection = new URL(string).openConnection();
                    uRLConnection.setConnectTimeout(5000);
                    uRLConnection.setReadTimeout(5000);
                    try (InputStream inputStream = uRLConnection.getInputStream();){
                        g = IOFunctions.readAsciiString(inputStream).trim();
                        break;
                    }
                }
                catch (IOException iOException) {
                }
            }
        }
        return g;
    }

    @Override
    public ConfigStructure.SaveState save(String key, String value, @Nonnull ConfigStructureSettings settings) {
        switch (key) {
            case "support.email": {
                if (value.equals(CoreSystemStructureProvider.getSupportEmail("", settings.getLicense()))) {
                    value = "";
                }
                settings.save(key, value);
                return ConfigStructure.SaveState.SAVE;
            }
            case "licensekey": {
                settings.save(ConfigKey.LICENSEKEY, settings.getLicenseKey());
                ForkJoinPool.commonPool().execute(() -> ConfigKeyParser.getCurrent());
                return ConfigStructure.SaveState.RELOAD;
            }
            case "log.levels": {
                settings.save(ConfigKey.LOG_ENGINE, Boolean.toString(!"-1".equals(value)));
                return ConfigStructure.SaveState.SAVE;
            }
            case "MaxActiveRequests": {
                if (value.isEmpty()) {
                    value = null;
                }
                settings.save(key, value);
                return ConfigStructure.SaveState.SAVE;
            }
            case "job_time_until_next_paused": {
                if (value.isEmpty()) {
                    settings.save(key, null);
                } else {
                    int n2 = Integer.parseInt(value);
                    settings.save(key, String.valueOf(n2 * 1000));
                }
                return ConfigStructure.SaveState.SAVE;
            }
            case "job_timeout": {
                if (value.isEmpty()) {
                    settings.save(key, null);
                } else {
                    int n3 = Integer.parseInt(value);
                    settings.save(key, String.valueOf(n3 * 60));
                }
                return ConfigStructure.SaveState.SAVE;
            }
            case "job_timeout_hard": {
                if (value.isEmpty()) {
                    settings.save(key, null);
                } else {
                    int n4 = Integer.parseInt(value);
                    settings.save(key, String.valueOf(n4 * 60));
                }
                return ConfigStructure.SaveState.SAVE;
            }
            case "Other": {
                String[][] stringArray = new Json().fromJson(value, String[][].class);
                HashSet<String> hashSet = new HashSet<String>();
                for (String string : settings.keySet()) {
                    if (ConfigKey.valueOf(string = string.trim()) != null) continue;
                    hashSet.add(string);
                }
                for (String[] stringArray2 : stringArray) {
                    String string = stringArray2[0];
                    String string2 = stringArray2[1];
                    settings.save(string, string2);
                    hashSet.remove(string);
                }
                for (String string : hashSet) {
                    settings.save(string, null);
                }
                return ConfigStructure.SaveState.SAVE;
            }
            case "imprint.logo.url": {
                if (value.trim().length() > 0) {
                    if (value.startsWith("data:") && !"data:dummy".equals(value)) {
                        Persistence.getRecoveryEnabledInstance().resolve("config_logo_file").setString(value);
                        value = "data:dummy";
                    } else {
                        Persistence.getRecoveryEnabledInstance().resolve("config_logo_file").deleteTree();
                    }
                }
                settings.save(key, value);
                return ConfigStructure.SaveState.RELOAD;
            }
            case "imprint.logo.withtext": 
            case "frameTitle": {
                settings.save(key, value);
                return ConfigStructure.SaveState.RELOAD;
            }
            case "serverURL": {
                if (Objects.equals(value, ConfigKey.SERVER_URL.getDefault())) {
                    value = null;
                }
                settings.save(ConfigKey.SERVER_URL, value);
                return ConfigStructure.SaveState.SAVE;
            }
        }
        if (key.startsWith("log.levels.")) {
            LogLevelsDefaults logLevelsDefaults = CoreSystemStructureProvider.a(settings);
            logLevelsDefaults.put(key.substring(11), Integer.valueOf(value));
            settings.save(ConfigKey.LOG_LEVELS, new Json().toJson(logLevelsDefaults));
            return ConfigStructure.SaveState.SAVE;
        }
        return ConfigStructure.SaveState.NONE;
    }

    @Nonnull
    private static Integer a(HashMap<String, Integer> hashMap) {
        Integer n2 = null;
        for (String object : CoreLoggers.CORE_LOGGERS) {
            Integer n3 = hashMap.get(object);
            if (n3 == null) continue;
            if (n2 == null) {
                n2 = n3;
                continue;
            }
            if (n2.intValue() == n3.intValue()) continue;
            return f;
        }
        Integer n3 = n2.intValue() == a.intValue() ? a : b;
        for (Map.Entry<String, Integer> entry : hashMap.entrySet()) {
            if (CoreLoggers.CORE_LOGGERS.contains(entry.getKey()) || hashMap.get(entry.getKey()).intValue() == n3.intValue()) continue;
            return f;
        }
        return n2;
    }

    private static LogLevelsDefaults a(@Nonnull ConfigStructureSettings configStructureSettings) {
        return new Json().fromJson(configStructureSettings.getOriginalValue(ConfigKey.LOG_LEVELS), LogLevelsDefaults.class);
    }

    @Nonnull
    public static String getSupportEmail(@Nullable String configValue, LicenseInfo license) {
        if (!(configValue != null && !configValue.isEmpty() || license.isValid() && !license.hasExpiredDate())) {
            ApplicationDescription applicationDescription = ApplicationDescription.get();
            return applicationDescription.getDefaultSupportAddress();
        }
        return configValue;
    }

    static {
        h = -1;
        i = "";
        j = new HashSet<String>();
    }
}

