/*
 * Decompiled with CFR 0.152.
 */
package com.inet.config.structure;

import com.inet.annotations.InternalApi;
import com.inet.config.Configuration;
import com.inet.config.internal.NodeRestarter;
import com.inet.config.provider.ConfigurationProvider;
import com.inet.config.provider.DefaultConfigurationProvider;
import com.inet.config.structure.model.ConfigCategory;
import com.inet.config.structure.model.ConfigConditionAction;
import com.inet.config.structure.model.ConfigGroup;
import com.inet.config.structure.model.ConfigProperty;
import com.inet.config.structure.model.ConfigPropertyGroup;
import com.inet.config.structure.model.ConfigValidationMsg;
import com.inet.config.structure.model.LocalizedKey;
import com.inet.config.structure.provider.ConfigStructureProvider;
import com.inet.config.structure.provider.ConfigStructureSettings;
import com.inet.lib.list.PairList;
import com.inet.lib.util.StringFunctions;
import com.inet.plugin.ServerPluginManager;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@InternalApi
public class ConfigStructure {
    @Nonnull
    private final ConfigStructureSettings a;
    private final boolean b;
    private Map<String, List<ConfigCategory>> c = new HashMap<String, List<ConfigCategory>>();
    private ConfigurationProvider d;

    public ConfigStructure(@Nonnull Configuration configuration, @Nonnull Locale locale, boolean advanced, @Nullable Properties values, @Nullable ConfigurationProvider configProvider) {
        this(configuration, locale, advanced, values, configProvider, false);
    }

    protected ConfigStructure(@Nonnull Configuration configuration, @Nonnull Locale locale, boolean advanced, @Nullable Properties values, @Nullable ConfigurationProvider configProvider, boolean isFilter) {
        this.a = new ConfigStructureSettings(configuration, locale, values, isFilter);
        this.b = advanced;
        this.d = configProvider != null ? configProvider : new DefaultConfigurationProvider();
    }

    @Nonnull
    public List<ConfigGroup> getGroups() {
        HashSet<ConfigGroup> hashSet = new HashSet<ConfigGroup>();
        for (ConfigStructureProvider arrayList2 : this.d.getStructureProviders()) {
            arrayList2.addGroupsTo(hashSet, this.b, this.a);
        }
        ArrayList arrayList3 = new ArrayList();
        for (ConfigGroup configGroup : hashSet) {
            if (this.a(configGroup.getKey()).size() != 0) continue;
            arrayList3.add(configGroup);
        }
        hashSet.removeAll(arrayList3);
        ArrayList<ConfigGroup> arrayList = new ArrayList<ConfigGroup>(hashSet);
        Collections.sort(arrayList);
        return arrayList;
    }

    @Nonnull
    public List<ConfigCategory> getCategories(String groupKey) {
        List<ConfigCategory> list = this.c.get(groupKey);
        if (list == null) {
            list = this.a(groupKey);
        }
        return list;
    }

    private List<ConfigCategory> a(String string) {
        HashSet<ConfigCategory> hashSet = new HashSet<ConfigCategory>();
        for (ConfigStructureProvider iterator2 : this.d.getStructureProviders()) {
            iterator2.addCategoriesTo(hashSet, string, this.b, this.a);
        }
        ArrayList arrayList = new ArrayList();
        for (ConfigStructureProvider configStructureProvider : this.d.getStructureProviders()) {
            PairList<String, String> pairList = configStructureProvider.getCategoryVetoes(this.b, this.a);
            for (int i2 = 0; i2 < pairList.size(); ++i2) {
                if (!pairList.get(i2).getFirst().equals(string)) continue;
                arrayList.add(pairList.get(i2).getSecond());
            }
        }
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            ConfigCategory configCategory = (ConfigCategory)iterator.next();
            if (!arrayList.contains(configCategory.getKey())) continue;
            iterator.remove();
        }
        ArrayList<ConfigCategory> arrayList2 = new ArrayList<ConfigCategory>(hashSet);
        Collections.sort(arrayList2);
        this.c.put(string, arrayList2);
        return arrayList2;
    }

    @Nonnull
    public static URL getCategoryIcon(@Nonnull String categoryKey) {
        URL uRL;
        for (ConfigStructureProvider configStructureProvider : new DefaultConfigurationProvider().getStructureProviders()) {
            uRL = configStructureProvider.getCategoryIcon(categoryKey);
            if (uRL == null) continue;
            return uRL;
        }
        for (ConfigStructureProvider configStructureProvider : ServerPluginManager.getInstance().get(ConfigStructureProvider.class)) {
            uRL = configStructureProvider.getCategoryIcon(categoryKey);
            if (uRL == null) continue;
            return uRL;
        }
        throw new IllegalStateException("Icon not found for category :" + categoryKey);
    }

    @Nonnull
    public List<ConfigConditionAction> getConditions(@Nonnull String categoryKey) {
        ArrayList<ConfigConditionAction> arrayList = new ArrayList<ConfigConditionAction>();
        for (ConfigStructureProvider configStructureProvider : this.d.getStructureProviders()) {
            configStructureProvider.addConditionsTo(arrayList, categoryKey, this.b, this.a);
        }
        return arrayList;
    }

    @Nonnull
    public List<ConfigPropertyGroup> getPropertyGroups(@Nonnull String categoryKey) {
        HashSet<ConfigPropertyGroup> hashSet = new HashSet<ConfigPropertyGroup>();
        for (ConfigStructureProvider iterator2 : this.d.getStructureProviders()) {
            iterator2.addPropertyGroupsTo(hashSet, categoryKey, this.b, this.a);
        }
        ArrayList arrayList = new ArrayList();
        for (ConfigStructureProvider configStructureProvider : this.d.getStructureProviders()) {
            PairList<String, String> pairList = configStructureProvider.getPropertyGroupVetoes(this.b, this.a);
            for (int i2 = 0; i2 < pairList.size(); ++i2) {
                if (!pairList.get(i2).getFirst().equals(categoryKey)) continue;
                arrayList.add(pairList.get(i2).getSecond());
            }
        }
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            ConfigPropertyGroup configPropertyGroup = (ConfigPropertyGroup)iterator.next();
            if (!arrayList.contains(configPropertyGroup.getKey())) continue;
            iterator.remove();
        }
        ArrayList<ConfigPropertyGroup> arrayList2 = new ArrayList<ConfigPropertyGroup>(hashSet);
        Collections.sort(arrayList2);
        return arrayList2;
    }

    @Nonnull
    public List<ConfigProperty> getProperties(@Nonnull String propertyGroupKey) {
        HashSet<ConfigProperty> hashSet = new HashSet<ConfigProperty>();
        for (ConfigStructureProvider configStructureProvider : this.d.getStructureProviders()) {
            configStructureProvider.addPropertiesTo(hashSet, propertyGroupKey, this.b, this.a);
        }
        ArrayList arrayList = new ArrayList(hashSet);
        Collections.sort(arrayList);
        return arrayList;
    }

    @Nonnull
    public List<ConfigValidationMsg> validate(@Nullable String categoryKey) {
        ArrayList<ConfigValidationMsg> arrayList = new ArrayList<ConfigValidationMsg>();
        ArrayList<ConfigConditionAction> arrayList2 = new ArrayList<ConfigConditionAction>();
        List<ConfigGroup> list = this.getGroups();
        for (ConfigGroup object : list) {
            List<ConfigCategory> list2 = this.getCategories(object.getKey());
            for (ConfigCategory configCategory : list2) {
                arrayList2.addAll(this.getConditions(configCategory.getKey()));
            }
        }
        for (ConfigStructureProvider configStructureProvider : this.d.getStructureProviders()) {
            configStructureProvider.validate(categoryKey, arrayList, arrayList2, this.a);
        }
        return arrayList;
    }

    @Nonnull
    public List<ConfigValidationMsg> action(@Nonnull String actionKey) {
        ArrayList<ConfigValidationMsg> arrayList = new ArrayList<ConfigValidationMsg>();
        switch (actionKey) {
            case "action.restart": {
                try {
                    NodeRestarter.restartAllServerNodes();
                }
                catch (Throwable throwable) {
                    arrayList.add(new ConfigValidationMsg(ConfigValidationMsg.Type.Invalid, StringFunctions.getUserFriendlyErrorMessage(throwable), actionKey));
                }
                break;
            }
            default: {
                for (ConfigStructureProvider configStructureProvider : this.d.getStructureProviders()) {
                    configStructureProvider.action(actionKey, arrayList, this.a);
                }
            }
        }
        return arrayList;
    }

    public SaveState save() throws RuntimeException {
        SaveState saveState = SaveState.SAVE;
        Properties properties = this.a.getValues();
        if (properties == null) {
            throw new RuntimeException("Bad request, no changed properties send");
        }
        block2: for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String string = (String)entry.getKey();
            String string2 = (String)entry.getValue();
            for (ConfigStructureProvider configStructureProvider : this.d.getStructureProviders()) {
                try {
                    SaveState saveState2 = configStructureProvider.save(string, string2, this.a);
                    if (saveState2.ordinal() <= SaveState.NONE.ordinal()) continue;
                    if (saveState2.ordinal() <= saveState.ordinal()) continue block2;
                    saveState = saveState2;
                    continue block2;
                }
                catch (RuntimeException runtimeException) {
                    throw new RuntimeException(StringFunctions.getUserFriendlyErrorMessage(runtimeException) + " --- for key: " + string + ", with value: " + string2 + ", at class: " + (configStructureProvider != null ? configStructureProvider.getClass().getName() : null), runtimeException);
                }
            }
            this.a.save(string, string2);
        }
        return saveState;
    }

    @Nonnull
    public List<LocalizedKey> getSelectValues(@Nonnull String key, String filter) {
        for (ConfigStructureProvider configStructureProvider : this.d.getStructureProviders()) {
            List<LocalizedKey> list = configStructureProvider.getSelectValues(key, filter, this.a);
            if (list == null) continue;
            return list;
        }
        return Collections.EMPTY_LIST;
    }

    public ConfigurationProvider getConfigProvider() {
        return this.d;
    }

    public ConfigStructureSettings getSettings() {
        return this.a;
    }

    public static final class SaveState
    extends Enum<SaveState> {
        public static final /* enum */ SaveState NONE = new SaveState();
        public static final /* enum */ SaveState SAVE = new SaveState();
        public static final /* enum */ SaveState RELOAD = new SaveState();
        private static final /* synthetic */ SaveState[] a;

        public static SaveState[] values() {
            return (SaveState[])a.clone();
        }

        public static SaveState valueOf(String name) {
            return Enum.valueOf(SaveState.class, name);
        }

        private static /* synthetic */ SaveState[] a() {
            return new SaveState[]{NONE, SAVE, RELOAD};
        }

        static {
            a = SaveState.a();
        }
    }
}

