/*
 * Decompiled with CFR 0.152.
 */
package com.inet.classloader.translations;

import com.inet.annotations.InternalApi;
import com.inet.classloader.LoaderUtils;
import com.inet.classloader.translations.BundleKey;
import com.inet.classloader.translations.ResourceEventListener;
import com.inet.classloader.translations.ResourceTools;
import com.inet.classloader.translations.TranslationKey;
import com.inet.classloader.translations.TranslationSearchIndex;
import com.inet.classloader.translations.b;
import com.inet.classloader.translations.c;
import com.inet.lib.util.StringFunctions;
import com.inet.logging.LogManager;
import com.inet.logging.Logger;
import com.inet.plugin.DynamicExtension;
import com.inet.plugin.ServerPluginDescription;
import com.inet.plugin.ServerPluginManager;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@InternalApi
public class ResourceManager {
    static final Logger a = ServerPluginManager.getInstance().isPluginLoaded("translations") ? LogManager.getLogger("Translations") : LogManager.getConfigLogger();
    private static final ResourceManager b = new ResourceManager();
    private final CopyOnWriteArrayList<ResourceEventListener> c = new CopyOnWriteArrayList();
    private final DynamicExtension<TranslationKey> d = new DynamicExtension<TranslationKey>(TranslationKey.class);
    private c e = new c(this.c);

    public static ResourceManager getInstance() {
        return b;
    }

    @Nonnull
    public Properties getOriginalLabels(@Nonnull BundleKey key) {
        ServerPluginDescription serverPluginDescription = ServerPluginManager.getInstance().getPluginDescription(key.pluginId);
        ClassLoader classLoader = serverPluginDescription.getClassLoader();
        Properties properties = new Properties();
        try {
            Enumeration<URL> enumeration = classLoader.getResources(key.getResourceFilename());
            if (enumeration.hasMoreElements()) {
                URL uRL = enumeration.nextElement();
                try (InputStream object = uRL.openStream();){
                    properties.load(object);
                }
            }
            for (TranslationKey translationKey : this.d.get()) {
                if (!key.bundleName.equals(translationKey.bundleName) || !key.pluginId.equals(translationKey.pluginId)) continue;
                properties.putIfAbsent(translationKey.key, "");
            }
        }
        catch (IOException iOException) {
            a.error(iOException);
        }
        return properties;
    }

    @Nonnull
    public Properties getCurrentLabels(@Nonnull BundleKey key) {
        ServerPluginDescription serverPluginDescription = ServerPluginManager.getInstance().getPluginDescription(key.pluginId);
        ClassLoader classLoader = serverPluginDescription.getClassLoader();
        Properties properties = new Properties();
        URL uRL = classLoader.getResource(key.getResourceFilename());
        if (uRL != null) {
            try (InputStream inputStream = uRL.openStream();){
                properties.load(inputStream);
            }
            catch (IOException iOException) {
                a.error(iOException);
            }
        }
        this.a(key, properties);
        return properties;
    }

    @Nonnull
    public Properties getUserLabels(@Nonnull BundleKey key) {
        Properties properties = new Properties();
        File file = ResourceTools.getResourceZip(key.pluginId);
        if (file.isFile()) {
            try (ZipFile zipFile = new ZipFile(file);){
                ZipEntry zipEntry = zipFile.getEntry(key.getResourceFilename());
                if (zipEntry != null) {
                    properties.load(zipFile.getInputStream(zipEntry));
                }
            }
            catch (IOException iOException) {
                a.error(iOException);
            }
        }
        this.a(key, properties);
        return properties;
    }

    private void a(@Nonnull BundleKey bundleKey, Properties properties) {
        for (Map.Entry<TranslationKey, String> entry : this.e.a()) {
            TranslationKey translationKey = entry.getKey();
            if (!bundleKey.equalsOrSub(translationKey)) continue;
            String string = entry.getValue();
            if (string == null) {
                string = "";
            }
            properties.put(translationKey.key, string);
        }
    }

    public int getOriginalLabelCount(@Nullable String pluginId, @Nonnull String language) {
        if (StringFunctions.isEmpty(pluginId)) {
            return this.a(language);
        }
        int n2 = 0;
        Set<String> set = LoaderUtils.getLoadedBundles().get(pluginId);
        if (set == null) {
            return 0;
        }
        for (String string : set) {
            BundleKey bundleKey = new BundleKey(pluginId, string, language);
            n2 += this.getOriginalLabels(bundleKey).size();
        }
        return n2;
    }

    private int a(@Nonnull String string) {
        int n2 = 0;
        for (Map.Entry<String, Set<String>> entry : LoaderUtils.getLoadedBundles().entrySet()) {
            for (String string2 : entry.getValue()) {
                BundleKey bundleKey = new BundleKey(entry.getKey(), string2, string);
                n2 += this.getOriginalLabels(bundleKey).size();
            }
        }
        return n2;
    }

    public int getCurrentLabelCount(@Nullable String pluginId, @Nonnull String language) {
        if (StringFunctions.isEmpty(pluginId)) {
            return this.b(language);
        }
        int n2 = 0;
        Set<String> set = LoaderUtils.getLoadedBundles().get(pluginId);
        if (set != null) {
            for (String string : set) {
                BundleKey bundleKey = new BundleKey(pluginId, string, language);
                n2 += this.a(this.getCurrentLabels(bundleKey));
            }
        }
        return n2;
    }

    private int b(@Nonnull String string) {
        int n2 = 0;
        for (Map.Entry<String, Set<String>> entry : LoaderUtils.getLoadedBundles().entrySet()) {
            for (String string2 : entry.getValue()) {
                BundleKey bundleKey = new BundleKey(entry.getKey(), string2, string);
                n2 += this.a(this.getCurrentLabels(bundleKey));
            }
        }
        return n2;
    }

    private int a(Properties properties) {
        properties.entrySet().removeIf(entry -> StringFunctions.isEmpty((String)entry.getValue()));
        return properties.size();
    }

    @Nonnull
    public Set<String> getSupportedLanguages(String pluginId) {
        if (pluginId == null) {
            return this.getSupportedLanguages();
        }
        HashSet<String> hashSet = new HashSet<String>();
        Set<String> set = LoaderUtils.getLoadedBundles().get(pluginId);
        if (set == null) {
            return hashSet;
        }
        for (String string : set) {
            hashSet.addAll(TranslationSearchIndex.b(pluginId, string));
        }
        return hashSet;
    }

    @Nonnull
    public Set<String> getSupportedLanguages(String pluginId, String bundleName) {
        return new HashSet<String>(TranslationSearchIndex.b(pluginId, bundleName));
    }

    @Nonnull
    public Set<String> getSupportedLanguages() {
        HashSet<String> hashSet = new HashSet<String>();
        for (Map.Entry<String, Set<String>> entry2 : LoaderUtils.getLoadedBundles().entrySet()) {
            for (String string : entry2.getValue()) {
                hashSet.addAll(TranslationSearchIndex.b(entry2.getKey(), string));
            }
        }
        hashSet.addAll(this.e.a().stream().map(entry -> ((TranslationKey)entry.getKey()).language).collect(Collectors.toSet()));
        return hashSet;
    }

    public void writeLabels(@Nonnull Map<TranslationKey, String> labels) {
        this.a(labels);
        TranslationSearchIndex.b();
    }

    void a(@Nonnull Map<TranslationKey, String> map) {
        TranslationSearchIndex.a(map);
        while (this.b(map)) {
        }
    }

    private boolean b(Map<TranslationKey, String> map) {
        b b2 = null;
        String string = null;
        Iterator<Object> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<TranslationKey, String> object = iterator.next();
            TranslationKey translationKey = object.getKey();
            if (string == null) {
                string = translationKey.pluginId;
                b2 = new b(string);
                b2.a();
            } else if (!string.equals(translationKey.pluginId)) continue;
            b2.a(translationKey, object.getValue());
            iterator.remove();
        }
        if (b2 != null) {
            try {
                b2.b();
                for (String string2 : b2.c()) {
                    TranslationSearchIndex.a(string, string2);
                }
                for (ResourceEventListener resourceEventListener : this.c) {
                    resourceEventListener.sendTranslationsProgress(string);
                }
            }
            catch (IOException iOException) {
                a.error(iOException);
                for (ResourceEventListener resourceEventListener : this.c) {
                    resourceEventListener.sendError(StringFunctions.getUserFriendlyErrorMessage(iOException));
                }
            }
            return true;
        }
        return false;
    }

    public void update(TranslationKey key, String oldLabel, String newLabel) {
        this.updateWithoutNotification(key, oldLabel, newLabel);
        for (ResourceEventListener resourceEventListener : this.c) {
            resourceEventListener.updateTranslations(key, newLabel);
        }
    }

    public void updateWithoutNotification(TranslationKey key, String oldLabel, String newLabel) {
        this.e.a(key, newLabel);
        TranslationSearchIndex.getInstance().a().a(key, oldLabel, newLabel);
    }

    public void addListner(ResourceEventListener listener) {
        this.c.add(listener);
    }
}

