/*
 * Decompiled with CFR 0.152.
 */
package com.inet.classloader;

import com.inet.classloader.UpdateableClassLoader;
import com.inet.classloader.jnlp.BaseUpdateableClassLoader;
import com.inet.lib.util.IOFunctions;
import com.inet.logging.LogManager;
import com.inet.logging.Logger;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;

public class UpdateableClassLoaderImpl
extends ClassLoader
implements UpdateableClassLoader {
    private ArrayList<UpdateableClassLoader.ClassLoaderListener> a = new ArrayList();
    private final BaseUpdateableClassLoader b;

    public UpdateableClassLoaderImpl(BaseUpdateableClassLoader parent) {
        super((ClassLoader)((Object)parent));
        this.b = parent;
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        return ((ClassLoader)((Object)this.b)).loadClass(name);
    }

    @Override
    public URL getResource(String name) {
        return ((ClassLoader)((Object)this.b)).getResource(name);
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        return ((ClassLoader)((Object)this.b)).getResources(name);
    }

    @Override
    public void addUrlOrPath(String urlOrPath) {
        if (urlOrPath == null || urlOrPath.trim().length() == 0) {
            return;
        }
        URL uRL = IOFunctions.getURLFromString(urlOrPath);
        if (uRL != null) {
            this.addUrl(uRL);
        } else {
            Logger logger = LogManager.getConfigLogger();
            if (logger.isDebug()) {
                logger.debug("[UpdateableClassLoader]  url or path \"" + urlOrPath + "\" could not be found");
            }
        }
    }

    @Override
    public void addUrl(URL url) {
        String string = url.getPath();
        if (!(string.endsWith(".jar") || string.endsWith(".zip") || string.endsWith(".dll") || string.endsWith(".exe"))) {
            return;
        }
        if ("file".equals(url.getProtocol()) && !IOFunctions.getFile(url).exists()) {
            return;
        }
        this.b.addUrl(url);
        Logger logger = LogManager.getConfigLogger();
        if (logger.isDebug()) {
            logger.debug("[UpdateableClassLoader] adding " + String.valueOf(url));
        }
        this.a(url);
    }

    @Override
    public void addUrls(URL[] urls) {
        for (int i2 = 0; i2 < urls.length; ++i2) {
            this.addUrl(urls[i2]);
        }
    }

    @Override
    public URL[] getUrls() {
        return this.b.getUrls();
    }

    @Override
    public void addClassLoaderListener(UpdateableClassLoader.ClassLoaderListener listener) {
        if (listener != null) {
            this.a.add(listener);
        }
    }

    @Override
    public void removeClassLoaderListener(UpdateableClassLoader.ClassLoaderListener listener) {
        this.a.remove(listener);
    }

    @Override
    public void close() {
        try {
            if (this.b instanceof URLClassLoader) {
                ((URLClassLoader)((Object)this.b)).close();
            }
        }
        catch (IOException iOException) {
            LogManager.getConfigLogger().error(iOException);
        }
        for (int i2 = 0; i2 < this.a.size(); ++i2) {
            this.a.get(i2).destroy(this);
        }
    }

    private void a(URL uRL) {
        for (int i2 = 0; i2 < this.a.size(); ++i2) {
            this.a.get(i2).addedUrl(uRL);
        }
    }

    @Override
    public void fireLibrariesLoadedEvent() {
        for (int i2 = 0; i2 < this.a.size(); ++i2) {
            this.a.get(i2).librariesLoaded(this);
        }
    }
}

