/*
 * Decompiled with CFR 0.152.
 */
package com.inet.cache.font;

import com.inet.cache.InetSerializer;
import com.inet.cache.PersistenceKey;
import com.inet.cache.font.SerializableDerivedFontData;
import com.inet.classloader.ObjectStreams;
import com.inet.lib.io.FastByteArrayInputStream;
import com.inet.lib.io.FastByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;

public class DerivedFontDataSerializer
implements InetSerializer<SerializableDerivedFontData, DerivedFontDataSerializer> {
    @Override
    public void write(OutputStream out, SerializableDerivedFontData serializable) throws IOException {
        DataOutputStream dataOutputStream = new DataOutputStream(out);
        byte[] byArray = serializable.getGeneralFontPersistenceKey().keyValue().getBytes(StandardCharsets.UTF_8);
        dataOutputStream.writeInt(byArray.length);
        dataOutputStream.write(byArray);
        FastByteArrayOutputStream fastByteArrayOutputStream = new FastByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(fastByteArrayOutputStream);
        objectOutputStream.writeObject(serializable.getFontAttributes());
        byte[] byArray2 = fastByteArrayOutputStream.toByteArray();
        dataOutputStream.writeInt(byArray2.length);
        dataOutputStream.write(byArray2);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public SerializableDerivedFontData read(InputStream in) throws IOException {
        DataInputStream dataInputStream = new DataInputStream(in);
        int n2 = dataInputStream.readInt();
        byte[] byArray = new byte[n2];
        dataInputStream.read(byArray, 0, n2);
        String string = new String(byArray, StandardCharsets.UTF_8);
        int n3 = dataInputStream.readInt();
        byte[] byArray2 = new byte[n3];
        dataInputStream.read(byArray2, 0, n3);
        try (FastByteArrayInputStream fastByteArrayInputStream = new FastByteArrayInputStream(byArray2);){
            SerializableDerivedFontData serializableDerivedFontData;
            try (ObjectStreams.CacheObjectInputStream cacheObjectInputStream = new ObjectStreams.CacheObjectInputStream(fastByteArrayInputStream);){
                HashMap hashMap = (HashMap)cacheObjectInputStream.readObject();
                serializableDerivedFontData = new SerializableDerivedFontData(PersistenceKey.create(string), hashMap);
            }
            return serializableDerivedFontData;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IOException(classNotFoundException);
        }
    }
}

