/*
 * Decompiled with CFR 0.152.
 */
package com.inet.cache;

import com.inet.annotations.JsonData;
import com.inet.persistence.spi.PersistenceHelper;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonData
public class PersistenceKey
implements Serializable {
    private static final int KEY_VALUE_LENGTH_LIMIT = 200;
    @Nonnull
    private final String keyValue;

    private PersistenceKey() {
        this.keyValue = null;
    }

    private PersistenceKey(String keyValue) {
        this.keyValue = keyValue.toLowerCase();
    }

    @Nonnull
    public static PersistenceKey create(String key) {
        PersistenceKey persistenceKey = new PersistenceKey(key);
        PersistenceKey.validateKeyValue(persistenceKey.keyValue);
        return persistenceKey;
    }

    @Nonnull
    public static PersistenceKey createForFilePersistenceOnly(String key) {
        return new PersistenceKey(key);
    }

    public String keyValue() {
        return this.keyValue;
    }

    static void validateKeyValue(String keyValue) {
        if (keyValue == null || keyValue.length() > 200) {
            throw new IllegalArgumentException("given key is invalid: " + keyValue);
        }
        PersistenceHelper.checkName(keyValue);
    }

    @Nonnull
    public String toString() {
        return this.keyValue;
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3 + (this.keyValue == null ? 0 : this.keyValue.hashCode());
        return n3;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PersistenceKey persistenceKey = (PersistenceKey)obj;
        return Objects.equals(this.keyValue, persistenceKey.keyValue);
    }
}

