/*
 * Decompiled with CFR 0.152.
 */
package com.inet.authentication.digest;

import com.inet.annotations.InternalApi;
import com.inet.authentication.AuthenticationDescription;
import com.inet.authentication.RemoteLoginProcessor;
import com.inet.authentication.digest.DigestAuthorizationHeader;
import com.inet.plugin.ApplicationDescription;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.UUID;
import javax.annotation.SuppressFBWarnings;

@InternalApi
public abstract class DigestAccessAuthWUI
extends RemoteLoginProcessor {
    private static String a;
    private String b;
    private String c;
    private long d;
    private String e;

    protected DigestAccessAuthWUI(AuthenticationDescription description) {
        super(description);
    }

    @Override
    public String getLoginID() {
        return this.b;
    }

    @Override
    public boolean isMasterPassword() {
        return false;
    }

    @Override
    public void requestLoginData(HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        if (a == null) {
            a = ApplicationDescription.get().getApplicationName();
        }
        this.b = null;
        this.d = 0L;
        String string = System.nanoTime() + ":" + UUID.randomUUID().toString();
        this.c = Base64.getEncoder().encodeToString(string.getBytes(StandardCharsets.UTF_8));
        this.e = httpRequest.getRequestURI();
        if (httpRequest.getQueryString() != null) {
            this.e = this.e + "?" + httpRequest.getQueryString();
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Digest ");
        stringBuilder.append("realm=\"").append(a).append("\"").append(",");
        stringBuilder.append("qop=\"auth\"").append(",");
        stringBuilder.append("nonce=\"").append(this.c).append("\"");
        httpResponse.addHeader("WWW-Authenticate", stringBuilder.toString());
        try {
            httpResponse.sendError(401);
        }
        catch (IOException iOException) {
            LOGGER.debug(iOException);
        }
    }

    @Override
    public boolean transferClientLoginData(HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        if (this.getLoginID() != null) {
            return true;
        }
        String string = httpRequest.getHeader("Authorization");
        DigestAuthorizationHeader digestAuthorizationHeader = DigestAuthorizationHeader.from(string);
        if (digestAuthorizationHeader == null) {
            LOGGER.error("Wrong authorization header: " + string);
            return true;
        }
        if (this.a(httpRequest.getMethod(), digestAuthorizationHeader)) {
            this.b = digestAuthorizationHeader.getUsername();
        } else {
            LOGGER.debug("Unsuccessful authentication with header: " + string);
        }
        return true;
    }

    protected abstract String getHashValueOfA1(String var1, String var2);

    private boolean a(String string, DigestAuthorizationHeader digestAuthorizationHeader) {
        if (!digestAuthorizationHeader.getRealm().equals(a)) {
            return false;
        }
        if (!digestAuthorizationHeader.getUri().equals(this.e)) {
            return false;
        }
        try {
            long l2 = Long.parseLong(digestAuthorizationHeader.getNc(), 16);
            if (l2 <= this.d) {
                LOGGER.debug("Bad nonce count (nc): " + l2 + " expected a value larger " + this.d);
                return false;
            }
            this.d = l2;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        if (!digestAuthorizationHeader.getQop().equals("auth")) {
            return false;
        }
        String string2 = this.getHashValueOfA1(digestAuthorizationHeader.getUsername(), digestAuthorizationHeader.getRealm());
        if (string2 == null) {
            return false;
        }
        String string3 = String.format("%s:%s", string, digestAuthorizationHeader.getUri());
        String string4 = String.format("%s:%s:%s:%s:%s:%s", string2, digestAuthorizationHeader.getNonce(), digestAuthorizationHeader.getNc(), digestAuthorizationHeader.getCnonce(), digestAuthorizationHeader.getQop(), DigestAccessAuthWUI.md5(string3));
        String string5 = DigestAccessAuthWUI.md5(string4);
        return string5.equals(digestAuthorizationHeader.getResponse());
    }

    @SuppressFBWarnings(value={"WEAK_MESSAGE_DIGEST_MD5"}, justification="legacy protocol required MD5")
    protected static String md5(String s) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            messageDigest.update(s.getBytes(), 0, s.length());
            Object object = new BigInteger(1, messageDigest.digest()).toString(16);
            while (((String)object).length() < 32) {
                object = "0" + (String)object;
            }
            return object;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException(noSuchAlgorithmException);
        }
    }
}

