/*
 * Decompiled with CFR 0.152.
 */
package com.inet.usersandgroups.api.user.search;

import com.inet.annotations.InternalApi;
import com.inet.id.GUID;
import com.inet.logging.LogManager;
import com.inet.search.DisplayNameCustomizer;
import com.inet.search.ResultLineFactory;
import com.inet.search.SearchResult;
import com.inet.search.SearchResultEntry;
import com.inet.search.SearchTag;
import com.inet.search.command.AndSearchExpression;
import com.inet.search.command.SearchCommand;
import com.inet.search.command.SearchCondition;
import com.inet.search.command.SearchExpression;
import com.inet.search.command.SearchID;
import com.inet.search.command.TextSearchCommandBuilder;
import com.inet.search.command.TokenMatcher;
import com.inet.search.index.IndexSearchEngine;
import com.inet.search.index.SearchResultEntryAdjuster;
import com.inet.search.resultlinefactory.DefaultResultLineFactory;
import com.inet.search.veto.SearchIndexVeto;
import com.inet.usersandgroups.api.user.LoginSettings;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.persistence.UserPersistence;
import com.inet.usersandgroups.api.user.search.UserDisplayNameCustomizer;
import com.inet.usersandgroups.api.user.search.UserSearchDataCache;
import com.inet.usersandgroups.user.search.SearchTagActive;
import com.inet.usersandgroups.user.search.SearchTagLoginSettings;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@InternalApi
public class UserSearchEngine {
    private IndexSearchEngine<GUID> a;
    private UserPersistence b;
    private UserSearchDataCache c;
    private final ResultLineFactory d;
    private final DisplayNameCustomizer e;
    private SearchIndexVeto f;

    public UserSearchEngine(boolean useOriginalInRecoveryMode) {
        this(Collections.emptyList(), useOriginalInRecoveryMode);
    }

    public UserSearchEngine(List<TokenMatcher> tokenMatchers, boolean useOriginalInRecoveryMode) {
        this(new DefaultResultLineFactory(), new UserDisplayNameCustomizer(), tokenMatchers, useOriginalInRecoveryMode);
    }

    public UserSearchEngine(ResultLineFactory resultLineFactory, DisplayNameCustomizer displayNameCustomizer, List<TokenMatcher> tokenMatchers, boolean useOriginalInRecoveryMode) {
        if (resultLineFactory == null) {
            throw new IllegalArgumentException("result line factory must not be null");
        }
        if (displayNameCustomizer == null) {
            throw new IllegalArgumentException("display name customizer must not be null");
        }
        if (tokenMatchers == null) {
            throw new IllegalArgumentException("map of token matchers must not be null");
        }
        this.a = this.createSearchEngine(useOriginalInRecoveryMode);
        this.d = resultLineFactory;
        this.e = displayNameCustomizer;
        for (TokenMatcher tokenMatcher : tokenMatchers) {
            this.a.addTokenMatcher(tokenMatcher);
        }
    }

    public void setSearchIndexVeto(@Nullable SearchIndexVeto searchIndexVeto) {
        this.f = searchIndexVeto;
    }

    protected IndexSearchEngine<GUID> createSearchEngine(boolean useOriginalInRecoveryMode) {
        return new IndexSearchEngine<GUID>("usersearch", this.createReindexKey(), useOriginalInRecoveryMode, GUID.class);
    }

    protected String createReindexKey() {
        return "v3";
    }

    public void init(UserPersistence persistence, UserSearchDataCache cache) throws IOException {
        if (cache == null) {
            throw new IllegalArgumentException("search data cache must not be null");
        }
        if (this.c != null) {
            throw new IllegalStateException("search data cache is already set");
        }
        try {
            this.b = persistence;
            this.c = cache;
            for (SearchTag searchTag : cache.a()) {
                this.a.addTag(searchTag);
            }
            this.a.setPrimaryTag(this.a.getTag("useraccountid"));
            if (this.f != null) {
                this.f.setStatusToStartingInitOfIndex(this.a);
            }
            boolean bl = false;
            boolean bl2 = false;
            while (!bl2) {
                try {
                    if (bl) {
                        this.a.reIndex();
                    } else {
                        this.a.setData(cache, 4);
                    }
                    bl2 = true;
                }
                catch (Throwable throwable) {
                    bl = true;
                    LogManager.getApplicationLogger().fatal(throwable);
                    try {
                        Thread.sleep(30000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            if (this.f != null) {
                this.f.setStatusToFinishedInitOfIndex();
            }
        }
        catch (IOException iOException) {
            if (this.f != null) {
                this.f.setStatusToFailedInitOfIndex();
            }
            throw iOException;
        }
    }

    public IndexSearchEngine<GUID> getSearchEngine() {
        return this.a;
    }

    public boolean hasTag(String key) {
        return this.a.getTag(key) != null;
    }

    public SearchResult<GUID> search(@Nonnull String searchPhrase, @Nonnull List<SearchExpression> additionalExpressions, @Nonnull List<SearchExpression> boostingExpressions, int maxResults, @Nullable SearchID searchID) {
        return this.search(searchPhrase, additionalExpressions, boostingExpressions, maxResults, searchID, this.a.getTags(), this.a.getTokenMatcher());
    }

    public SearchResult<GUID> search(@Nonnull String searchPhrase, @Nonnull List<SearchExpression> additionalExpressions, @Nonnull List<SearchExpression> boostingExpressions, int maxResults, @Nullable SearchID searchID, @Nonnull Set<SearchTag> searchTags, @Nullable List<TokenMatcher<GUID>> tokenMatcher) {
        if (maxResults <= 0) {
            throw new IllegalArgumentException("max number of search result entries must be greater than zero");
        }
        TextSearchCommandBuilder textSearchCommandBuilder = new TextSearchCommandBuilder(searchTags, tokenMatcher, searchPhrase);
        SearchCommand searchCommand = textSearchCommandBuilder.build();
        searchCommand.setID(searchID);
        searchCommand.setResultLimit(maxResults);
        searchCommand.getSearchExpression().addAll(additionalExpressions);
        for (SearchExpression searchExpression : boostingExpressions) {
            searchCommand.addBoostingExpression(searchExpression);
        }
        return this.search(searchCommand);
    }

    public SearchResult<GUID> search(@Nonnull SearchCommand command) {
        AndSearchExpression andSearchExpression = new AndSearchExpression();
        andSearchExpression.addAll(command.getSearchExpression());
        SearchResult<GUID> searchResult = this.a.search(command);
        List<SearchResultEntry<GUID>> list = searchResult.getEntries();
        List<GUID> list2 = list.stream().map(SearchResultEntry::getId).collect(Collectors.toList());
        List<UserAccount> list3 = this.b.load(list2, command.getResultLimit());
        Map map = list3.stream().collect(Collectors.toMap(UserAccount::getID, Function.identity()));
        SearchResultEntryAdjuster<GUID> searchResultEntryAdjuster = new SearchResultEntryAdjuster<GUID>(this.d, this.e, this.a, andSearchExpression);
        ArrayList arrayList = new ArrayList();
        for (SearchResultEntry<GUID> searchResultEntry : list) {
            UserAccount userAccount = (UserAccount)map.get(searchResultEntry.getId());
            if (userAccount == null) continue;
            Map<String, Object> map2 = this.c.toMap(userAccount, false);
            searchResultEntryAdjuster.processEntry(searchResultEntry, map2);
            arrayList.add(searchResultEntry);
        }
        Collections.sort(arrayList);
        boolean bl = searchResult.isPartialResult() || list.size() > arrayList.size();
        return new SearchResult<GUID>(arrayList, bl);
    }

    public SearchResult<GUID> findActiveUserAccount(String loginSource, String loginID) {
        LoginSettings.throwIfInvalidLoginSource(loginSource);
        LoginSettings.throwIfInvalidLoginID(loginID);
        SearchCondition searchCondition = new SearchCondition("active", SearchCondition.SearchTermOperator.Equals, SearchTagActive.valueAsString(true));
        SearchCondition searchCondition2 = new SearchCondition("loginsettings", SearchCondition.SearchTermOperator.Equals, SearchTagLoginSettings.settingsAsToken(loginSource, loginID));
        AndSearchExpression andSearchExpression = new AndSearchExpression();
        andSearchExpression.add(searchCondition2);
        andSearchExpression.add(searchCondition);
        SearchCommand searchCommand = new SearchCommand(andSearchExpression);
        return this.a.search(searchCommand);
    }

    public Set<GUID> findAuthGroupMembers(@Nonnull String authGroupName) {
        SearchCommand searchCommand = new SearchCommand("authgroupname", SearchCondition.SearchTermOperator.Equals, authGroupName);
        Set<GUID> set = this.a.simpleSearch(searchCommand);
        return set;
    }
}

