/*
 * Decompiled with CFR 0.152.
 */
package com.inet.usersandgroups.api.user;

import com.inet.annotations.InternalApi;
import com.inet.authentication.LoginProcessor;
import com.inet.id.GUID;
import com.inet.usersandgroups.api.user.UserAccountType;
import com.inet.usersandgroups.api.user.UserManager;
import java.io.Closeable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@InternalApi
public class UserAccountScope
implements Closeable {
    private GUID b;
    private LoginProcessor c;
    private boolean d;
    static final GUID a = GUID.valueOf("sys0000000000000000000000");

    public UserAccountScope(GUID accountID, LoginProcessor login) {
        if (accountID == null) {
            accountID = a;
            login = null;
        }
        UserManager userManager = UserManager.getInstance();
        this.c = LoginProcessor.getCurrent();
        this.b = userManager.b(accountID);
        LoginProcessor.setCurrent(login);
    }

    @Nonnull
    public static UserAccountScope create(GUID accountID) {
        if (UserManager.PRIVILEGED_ACCOUNT_ID.equals(accountID)) {
            return UserAccountScope.createPrivileged();
        }
        UserManager userManager = UserManager.getInstance();
        LoginProcessor loginProcessor = userManager.getNonSessionLoginProcessor(accountID);
        return new UserAccountScope(accountID, loginProcessor);
    }

    @Nonnull
    public static UserAccountScope createPrivileged() {
        PrivilegedLoginProcessor privilegedLoginProcessor = new PrivilegedLoginProcessor();
        return new UserAccountScope(privilegedLoginProcessor.getUserAccountID(), privilegedLoginProcessor);
    }

    @Nonnull
    public static UserAccountScope createUser(@Nonnull String loginID) {
        a a2 = new a(loginID);
        return new UserAccountScope(a2.getUserAccountID(), a2);
    }

    @Override
    public void close() {
        if (this.d) {
            throw new IllegalStateException("scope already closed");
        }
        UserManager userManager = UserManager.getInstance();
        userManager.b(this.b);
        LoginProcessor.setCurrent(this.c);
        this.d = true;
    }

    public static class PrivilegedLoginProcessor
    extends LoginProcessor {
        private PrivilegedLoginProcessor() {
            super(null);
        }

        @Override
        public boolean supportsRoles() {
            return true;
        }

        @Override
        public boolean isWebUserInRole(String role) {
            return true;
        }

        @Override
        @Nullable
        public String getLoginID() {
            return "privileged";
        }

        @Override
        @Nonnull
        public String getLoginSource() {
            return "privileged";
        }

        @Override
        public UserAccountType getUserAccountType() {
            return UserAccountType.Administrator;
        }

        @Override
        @Nullable
        public GUID getUserAccountID() {
            return UserManager.PRIVILEGED_ACCOUNT_ID;
        }
    }

    private static class a
    extends LoginProcessor {
        private String a;

        a(String string) {
            super(null);
            this.a = string;
        }

        @Override
        @Nonnull
        public String getLoginSource() {
            return "system";
        }

        @Override
        public boolean supportsRoles() {
            return false;
        }

        @Override
        public boolean isWebUserInRole(String role) {
            return false;
        }

        @Override
        @Nullable
        public String getLoginID() {
            return this.a;
        }

        @Override
        public UserAccountType getUserAccountType() {
            return UserAccountType.Standard;
        }

        @Override
        @Nullable
        public GUID getUserAccountID() {
            return this.getOrCreateUserAccount(this.getLoginID()).getID();
        }
    }
}

