/*
 * Decompiled with CFR 0.152.
 */
package com.inet.usersandgroups.api.ui.fields.group;

import com.inet.field.SelectOption;
import com.inet.field.SelectOptionResult;
import com.inet.http.ClientMessageException;
import com.inet.lib.json.Json;
import com.inet.lib.util.StringFunctions;
import com.inet.usersandgroups.UsersAndGroups;
import com.inet.usersandgroups.api.BasicFieldValidation;
import com.inet.usersandgroups.api.groups.UserGroupInfo;
import com.inet.usersandgroups.api.ui.fieldgroups.GeneralAuthenticationGroupFieldPanelDefinition;
import com.inet.usersandgroups.api.ui.fields.UserGroupUpdateData;
import com.inet.usersandgroups.api.ui.fields.group.SelectGroupFieldDefinition;
import com.inet.usersandgroups.api.user.AuthGroupManager;
import java.util.ArrayList;
import java.util.List;

public class AuthenticationGroupNameFieldDefinition
extends SelectGroupFieldDefinition<String> {
    public AuthenticationGroupNameFieldDefinition(int prio) {
        super(GeneralAuthenticationGroupFieldPanelDefinition.FIELD_PANEL_KEY, "groupname.authentication", prio);
    }

    @Override
    public String convertFromString(String value) {
        if (!StringFunctions.isEmpty(value)) {
            value = new Json().fromJson(value, SelectOption.class).getValue();
        }
        return value;
    }

    @Override
    public String getLabel() {
        return UsersAndGroups.getFieldDisplayName("groupname");
    }

    @Override
    public void validate(Object value) throws ClientMessageException {
        super.validate(value);
        if (value == null || ((String)value).trim().isEmpty()) {
            throw new ClientMessageException(UsersAndGroups.MSG.getMsg("usersandgroupsmanager.validation.namenotset", new Object[0]));
        }
        try {
            BasicFieldValidation.throwIfLengthExceedsLimit((String)value, 100);
        }
        catch (Throwable throwable) {
            throw new ClientMessageException(throwable.getMessage());
        }
    }

    @Override
    public void save(UserGroupInfo userGroup, UserGroupUpdateData userGroupUpdateData, Object value) {
        userGroupUpdateData.setName((String)value);
    }

    @Override
    public SelectOption getValue(UserGroupInfo groupInfo) {
        String string = "";
        if (groupInfo != null) {
            string = groupInfo.getName();
        }
        return new SelectOption(string, string);
    }

    @Override
    public SelectOptionResult getOptions(UserGroupInfo groupInfo, String searchTerm, int currentSize, int chunkSize) {
        List<String> list = AuthGroupManager.getInstance().createDisplayValuesIterator(searchTerm);
        ArrayList<SelectOption> arrayList = new ArrayList<SelectOption>();
        if (currentSize == 0 && chunkSize > 0) {
            arrayList.add(new SelectOption(searchTerm, searchTerm));
            ++currentSize;
        }
        int n2 = Math.min(currentSize + chunkSize - 1, list.size());
        for (int i2 = currentSize - 1; i2 < n2; ++i2) {
            String string = list.get(i2);
            arrayList.add(new SelectOption(string, string));
        }
        return new SelectOptionResult(list.size() + 1, arrayList);
    }

    @Override
    public boolean allowsCustomValue() {
        return true;
    }

    @Override
    public boolean isAvailable(UserGroupInfo userGroup) {
        return true;
    }
}

