/*
 * Decompiled with CFR 0.152.
 */
package com.inet.plugin.uninstall;

import com.inet.cache.internal.HardDiskExternalDataWriterFactory;
import com.inet.classloader.I18nMessages;
import com.inet.config.ConfigKey;
import com.inet.config.Configuration;
import com.inet.config.ConfigurationManager;
import com.inet.lib.util.IOFunctions;
import com.inet.logging.LogManager;
import com.inet.logging.Logger;
import com.inet.persistence.MaintenanceMode;
import com.inet.persistence.Persistence;
import com.inet.persistence.PersistenceEntry;
import com.inet.persistence.file.FilePersistenceFactory;
import com.inet.plugin.CoreServerPlugin;
import com.inet.plugin.ServerPluginDescription;
import com.inet.plugin.ServerPluginManager;
import java.awt.AWTError;
import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Properties;
import javax.annotation.SuppressFBWarnings;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class Uninstaller {
    public static final String SYSTEM_PROPERTY = "inetuninstall";
    private String[] a;
    private String b;
    private Logger c = LogManager.getConfigLogger();
    private ServerPluginManager d;
    private CoreServerPlugin e;

    public Uninstaller(String[] args, String applicationName, ServerPluginManager spm) {
        this.a = args;
        this.b = applicationName;
        this.d = spm;
    }

    public void uninstall(CoreServerPlugin corePlugin) {
        this.uninstall(corePlugin, null, null);
    }

    public void uninstall(CoreServerPlugin corePlugin, URL titleImage, URL dialogImage) {
        try {
            this.c.status("Perform uninstallation");
            System.setProperty(SYSTEM_PROPERTY, "true");
            this.e = corePlugin;
            boolean bl = this.isFullUninstall(titleImage, dialogImage);
            this.c.status(String.format("Perform full uninstall: %s", bl ? "YES" : "NO"));
            ServerPluginDescription serverPluginDescription = ServerPluginDescription.create(corePlugin, null);
            this.d.uninstall(serverPluginDescription, bl);
            if (bl) {
                this.c.status("Remove all files, config and application data.");
                this.removeAll();
            }
            this.c.status("Uninstall done.");
        }
        catch (Throwable throwable) {
            this.c.fatal(throwable);
        }
    }

    protected boolean isFullUninstall(URL titleImage, URL dialogImage) {
        boolean bl = false;
        for (String string : this.a) {
            if (string.toLowerCase().equals("-full")) {
                return true;
            }
            if (!string.toLowerCase().equals("-quiet")) continue;
            bl = true;
        }
        if (bl) {
            return false;
        }
        if (GraphicsEnvironment.isHeadless()) {
            this.c.status("Environment is headless!");
            return false;
        }
        return this.a(titleImage, dialogImage);
    }

    private boolean a(URL uRL, URL uRL2) {
        Object object;
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (AWTError aWTError) {
            this.c.error(aWTError);
            return false;
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException exception) {
            this.c.error(exception);
        }
        I18nMessages i18nMessages = new I18nMessages("com.inet.plugin.uninstall.Translations", Uninstaller.class);
        String string = i18nMessages.getMsg("uninstall_message", new Object[0]);
        String string2 = i18nMessages.getMsg("uninstall_title", this.b);
        ImageIcon imageIcon = null;
        BufferedImage bufferedImage = null;
        try {
            if (uRL != null) {
                bufferedImage = ImageIO.read(uRL);
            }
            if (uRL2 != null) {
                object = ImageIO.read(uRL2);
                imageIcon = new ImageIcon((Image)object);
            }
        }
        catch (IOException iOException) {
            this.c.error(iOException);
        }
        object = new JOptionPane(string, 3, 0, imageIcon);
        ((Component)object).setComponentOrientation(JOptionPane.getRootFrame().getComponentOrientation());
        JDialog jDialog = ((JOptionPane)object).createDialog(string2);
        jDialog.setIconImage(bufferedImage);
        jDialog.setAlwaysOnTop(true);
        jDialog.setModal(true);
        ((JOptionPane)object).selectInitialValue();
        jDialog.setDefaultCloseOperation(2);
        jDialog.setVisible(true);
        jDialog.dispose();
        Object object2 = ((JOptionPane)object).getValue();
        if (object2 == null) {
            return false;
        }
        if (object2 instanceof Integer) {
            switch ((Integer)object2) {
                case 0: {
                    return true;
                }
                case 1: {
                    return false;
                }
            }
        }
        return false;
    }

    protected void removeAll() {
        this.c();
        this.d();
        this.b();
        try {
            MaintenanceMode.start();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.a();
        this.c();
    }

    private void b() {
        this.a(HardDiskExternalDataWriterFactory.getDefaultDir().toPath());
    }

    void a() {
        this.a(Paths.get(".", new String[0]));
    }

    private void c() {
        if (Persistence.isFilePersistence()) {
            try {
                Path path = FilePersistenceFactory.createFilePersistenceFactory(this.e.getDefaultConfig()).getPersistenceFolder();
                this.c.status("Remove " + String.valueOf(path));
                this.a(path);
            }
            catch (IOException iOException) {
                this.c.status(iOException);
            }
        } else {
            Persistence persistence = Persistence.getInstance();
            PersistenceEntry persistenceEntry = persistence.resolve("/");
            this.c.status("Remove persistence " + String.valueOf(persistenceEntry));
            persistenceEntry.deleteTree();
        }
    }

    private final void a(Path path) {
        if (!Files.exists(path, new LinkOption[0])) {
            return;
        }
        if (Files.isRegularFile(path, new LinkOption[0])) {
            try {
                IOFunctions.deleteDir(path);
                this.b(path);
            }
            catch (IOException iOException) {
                this.a(path, iOException);
            }
            return;
        }
        try {
            Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                public FileVisitResult a(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
                    try {
                        IOFunctions.deleteDir(path);
                        Uninstaller.this.b(path);
                    }
                    catch (IOException iOException) {
                        Uninstaller.this.a(path, iOException);
                        path.toFile().deleteOnExit();
                    }
                    return FileVisitResult.CONTINUE;
                }

                public FileVisitResult a(Path path, IOException iOException) throws IOException {
                    try {
                        IOFunctions.deleteDir(path);
                        Uninstaller.this.b(path);
                    }
                    catch (IOException iOException2) {
                        Uninstaller.this.a(path, iOException2);
                        path.toFile().deleteOnExit();
                    }
                    return FileVisitResult.CONTINUE;
                }

                public FileVisitResult b(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
                    path.toFile().deleteOnExit();
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public /* synthetic */ FileVisitResult postVisitDirectory(Object object, IOException iOException) throws IOException {
                    return this.a((Path)object, iOException);
                }

                @Override
                public /* synthetic */ FileVisitResult visitFile(Object object, BasicFileAttributes basicFileAttributes) throws IOException {
                    return this.a((Path)object, basicFileAttributes);
                }

                @Override
                public /* synthetic */ FileVisitResult preVisitDirectory(Object object, BasicFileAttributes basicFileAttributes) throws IOException {
                    return this.b((Path)object, basicFileAttributes);
                }
            });
            Files.delete(path);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void a(Path path, IOException iOException) {
        String string = iOException.getMessage();
        if (string == null || string.isEmpty()) {
            string = iOException.getClass().getSimpleName();
        }
        LogManager.getConfigLogger().debug(String.format("Could not delete %s: %s", path.toString(), string));
    }

    private void b(Path path) {
        LogManager.getConfigLogger().debug(String.format("Deleted %s", path.toString()));
    }

    private void d() {
        ConfigurationManager configurationManager = ConfigurationManager.getInstance();
        Configuration configuration = configurationManager.get(this.e.getDefaultConfig());
        if (configuration == null) {
            this.c.status("No configuration found " + this.e.getDefaultConfig());
            return;
        }
        this.c.status("Remove configuration " + configuration.getName());
        Configuration configuration2 = configurationManager.setTemporaryProperties(new Properties());
        String string = configuration.get(ConfigKey.LOG_FILE.getKey());
        if (this.a(string)) {
            if (this.b(string)) {
                configuration2.put(ConfigKey.LOG_FILE.getKey(), string);
                configuration2.put(ConfigKey.LOG_LEVELS.getKey(), configuration.get(ConfigKey.LOG_LEVELS.getKey()));
            } else {
                LogManager.stopSpooler();
            }
        }
        configurationManager.delete(configuration);
        configurationManager.setCurrent(configuration2);
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="Caller must check it")
    private boolean a(String string) {
        try {
            if (string == null) {
                return false;
            }
            Paths.get(string, new String[0]);
            return true;
        }
        catch (InvalidPathException invalidPathException) {
            return false;
        }
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="this is the security check")
    private boolean b(String string) {
        if (string == null) {
            return false;
        }
        Path path = Paths.get(string, new String[0]).toAbsolutePath().normalize();
        Path path2 = Paths.get(".", new String[0]).toAbsolutePath().normalize();
        this.c.debug("Logger Path is " + String.valueOf(path));
        this.c.debug("Current Dir is " + String.valueOf(path2));
        return !path.startsWith(path2);
    }
}

