/*
 * Decompiled with CFR 0.152.
 */
package com.inet.field.fieldtypes;

import com.inet.field.fieldtypes.FieldOperator;
import com.inet.field.fieldtypes.FieldType;
import com.inet.field.fieldtypes.FieldTypeFactory;
import com.inet.lib.util.StringFunctions;
import com.inet.search.SearchDataType;
import com.inet.search.SearchTag;
import com.inet.search.tokenizers.TextSearchTokenizer;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class FieldTypeRating
extends FieldType<Integer> {
    public FieldTypeRating(String key, Supplier<String> displayname) {
        super(key, displayname);
    }

    @Override
    @Nullable
    public String getDisplayValue(@Nullable Integer value) {
        if (value == null) {
            return null;
        }
        double d2 = (double)value.intValue() / 2.0;
        return String.format("\u2605 %.1f", d2);
    }

    @Override
    public SearchTag createSearchTag(Supplier<String> labelProvider, @Nonnull FieldTypeFactory fieldTypeFactory) {
        return fieldTypeFactory.applyConfiguredChangesToSearchTag(new SearchTag(this.getKey(), SearchDataType.IntegerMap, true, TextSearchTokenizer.DEFAULT, 100, labelProvider, true){

            @Override
            @Nonnull
            public Map<? extends Comparable<?>, String> getMapData() {
                HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
                for (int i2 = 0; i2 <= 10; ++i2) {
                    hashMap.put(i2, FieldTypeRating.this.getDisplayValue(i2));
                }
                hashMap.put(null, this.getDisplayValue(null));
                return hashMap;
            }
        });
    }

    @Override
    @Nullable
    public Integer valueOf(@Nullable String value) {
        if (StringFunctions.isEmpty(value)) {
            return null;
        }
        return Integer.valueOf(value);
    }

    @Override
    public Set<FieldOperator> getSupportedOperators() {
        return Set.of(FieldOperator.EQUALS, FieldOperator.EQUALS_NOT, FieldOperator.LESS_THAN, FieldOperator.GREATER_THAN, FieldOperator.GREATER_OR_EQUAL, FieldOperator.LESS_OR_EQUAL, FieldOperator.IS_NOT_EMPTY);
    }
}

