/*
 * Decompiled with CFR 0.152.
 */
package com.inet.config.structure.core.license;

import com.inet.annotations.JsonData;
import com.inet.config.LicenseInfo;
import com.inet.config.structure.core.CoreSystemStructureProvider;
import com.inet.config.structure.model.LocalizedKey;
import com.inet.config.structure.provider.ConfigStructureSettings;
import com.inet.http.servlet.ClientLocale;
import com.inet.plugin.FeatureLicenseInformation;
import com.inet.plugin.ServerPluginDescription;
import com.inet.plugin.ServerPluginManager;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;

@JsonData
public class LicenseEntry {
    private ArrayList<LocalizedKey> details = new ArrayList();
    private String currentlicensekey;
    private String displayname;
    private String error;
    private boolean valid;
    private boolean active;
    private long expires;
    private boolean existing;

    private LicenseEntry() {
    }

    public LicenseEntry(String licenseKey) {
        this.currentlicensekey = licenseKey;
    }

    public LicenseEntry(LicenseInfo license, CoreSystemStructureProvider instance, @Nonnull ConfigStructureSettings settings, boolean active) {
        String string;
        this.existing = true;
        this.active = active;
        HashMap<String, String> hashMap = new HashMap<String, String>(license.getAttributes());
        this.currentlicensekey = (String)hashMap.remove("key");
        this.displayname = license.getDisplayName();
        hashMap.remove("displayname");
        hashMap.remove("error");
        this.error = license.getErrorMessage();
        this.valid = license.isValid();
        String string2 = (String)hashMap.remove("expires");
        if (string2 != null && this.displayname != null) {
            string = DateFormat.getDateInstance().format(java.sql.Date.valueOf(string2));
            this.displayname = MessageFormat.format(this.displayname, string);
        }
        if (string2 != null) {
            this.expires = java.sql.Date.valueOf(string2).getTime();
            string = DateFormat.getDateInstance(1, settings.getLocale()).format(new Date(this.expires));
            this.details.add(new LocalizedKey(instance.translate(settings, "license.info.expires", new Object[0]), string));
        }
        string = (String)hashMap.remove("licensee");
        this.details.add(new LocalizedKey(instance.translate(settings, "license.info.licensee", new Object[0]), string));
        block30: for (Map.Entry entry : hashMap.entrySet()) {
            String string3 = (String)entry.getValue();
            switch ((String)entry.getKey()) {
                case "crplus": {
                    String string4 = (String)hashMap.get("app");
                    if (!"i-net Clear Reports".equals(string4)) continue block30;
                }
                case "app": 
                case "watermark": 
                case "additional": 
                case "hwid": 
                case "domain": 
                case "email": 
                case "ip": 
                case "clientcount": 
                case "cpu": 
                case "api": 
                case "server": 
                case "commandline": 
                case "gui": 
                case "trial": 
                case "version": 
                case "namedusers": 
                case "usercount": 
                case "rent": 
                case "fqdn": 
                case "nodecount": 
                case "cloudhost": {
                    if ("true".equalsIgnoreCase(string3.trim())) {
                        string3 = instance.translate(settings, "license.info.true", new Object[0]);
                    }
                    if ("false".equalsIgnoreCase(string3.trim())) {
                        string3 = instance.translate(settings, "license.info.false", new Object[0]);
                    }
                    this.details.add(new LocalizedKey(instance.translate(settings, "license.info." + (String)entry.getKey(), new Object[0]), string3));
                    continue block30;
                }
                case "features": {
                    StringBuffer stringBuffer = new StringBuffer();
                    String[] stringArray = string3.split(",");
                    List<FeatureLicenseInformation> list = ServerPluginManager.getInstance().get(FeatureLicenseInformation.class);
                    block31: for (String string5 : stringArray) {
                        if (stringBuffer.length() > 0) {
                            stringBuffer.append(", ");
                        }
                        for (FeatureLicenseInformation featureLicenseInformation : list) {
                            if (!string5.equals(featureLicenseInformation.getFeature())) continue;
                            stringBuffer.append(featureLicenseInformation.getDisplayName());
                            continue block31;
                        }
                        ServerPluginDescription serverPluginDescription = ServerPluginManager.getInstance().getPluginDescription(string5);
                        if (serverPluginDescription != null) {
                            stringBuffer.append(serverPluginDescription.getDisplayName("id", ClientLocale.getThreadLocale()));
                            continue;
                        }
                        if (string5.isEmpty()) continue;
                        stringBuffer.append(string5.substring(0, 1).toUpperCase() + string5.substring(1));
                    }
                    this.details.add(new LocalizedKey(instance.translate(settings, "license.info.features", new Object[0]), stringBuffer.toString()));
                    continue block30;
                }
            }
            this.details.add(new LocalizedKey((String)entry.getKey(), (String)entry.getValue()));
        }
    }

    public String getLicenseKey() {
        return this.currentlicensekey;
    }

    public List<LocalizedKey> getDetails() {
        return this.details;
    }

    boolean isExisting() {
        return this.existing;
    }

    public boolean isActive() {
        return this.active;
    }

    public String getError() {
        return this.error;
    }

    public String getDisplayName() {
        return this.displayname;
    }
}

