/*
 * Decompiled with CFR 0.152.
 */
package com.inet.classloader.translations;

import com.inet.classloader.translations.ResourceManager;
import com.inet.lib.util.LocaleUtils;
import com.inet.lib.util.StringFunctions;
import com.inet.plugin.ServerPluginManager;
import com.inet.plugin.fs.ResourceFile;
import java.io.File;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.SuppressFBWarnings;

public class ResourceTools {
    private static final String TRANSLATION_ZIP = ".translation.zip";

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="The file is a well known ressource, determined internally without user interaction.")
    public static File getResourceZip(@Nonnull String pluginId) {
        if (pluginId == null) {
            throw new IllegalArgumentException("pluginId may not be null");
        }
        if (pluginId.isEmpty()) {
            throw new IllegalArgumentException("pluginId may not be empty");
        }
        ResourceFile resourceFile = ServerPluginManager.getInstance().getTranslationsDir();
        File file = new File(resourceFile.getAbsolutePath());
        if (!file.exists()) {
            file.mkdirs();
        }
        return new File(resourceFile.getAbsolutePath() + "/" + ResourceTools.getZipFilName(pluginId));
    }

    protected static String getZipFilName(@Nonnull String pluginId) {
        return pluginId + TRANSLATION_ZIP;
    }

    @Nullable
    public static String getPluginIdFromTranslationsFile(@Nonnull File translationsFile) {
        String string = translationsFile.getName();
        if (!string.endsWith(TRANSLATION_ZIP)) {
            return null;
        }
        return string.substring(0, string.length() - TRANSLATION_ZIP.length());
    }

    public static String extractLocale(String propertiesFileName) {
        if (!propertiesFileName.endsWith(".properties")) {
            return null;
        }
        String string = "";
        int n2 = 0;
        while ((n2 = propertiesFileName.indexOf("_", n2)) > 0) {
            if (LocaleUtils.checkLocaleString(string = propertiesFileName.substring(++n2, propertiesFileName.lastIndexOf("."))) == null) {
                return string;
            }
            ResourceManager.a.debug("Translations. Method: extractLocale; propertiesFileName -> " + propertiesFileName + "; lang -> " + string);
        }
        return StringFunctions.isEmpty(string) ? "en" : string;
    }
}

