/*
 * Decompiled with CFR 0.152.
 */
package com.inet.authentication.stayloggedin;

import com.inet.annotations.JsonData;
import com.inet.authentication.AuthenticationDescription;
import com.inet.authentication.AuthenticationProvider;
import com.inet.authentication.LoginProcessor;
import com.inet.authentication.SystemAuthenticationProvider;
import com.inet.authentication.base.LoginManager;
import com.inet.authentication.base.TwoFactorManager;
import com.inet.authentication.stayloggedin.FieldStayLoggedIn;
import com.inet.authentication.stayloggedin.StayLoggedInSession;
import com.inet.cache.MemoryStoreMap;
import com.inet.config.ConfigKey;
import com.inet.config.ConfigValue;
import com.inet.http.ExpandableHttpSessionListener;
import com.inet.http.utils.UserAgent;
import com.inet.id.GUID;
import com.inet.lib.json.Json;
import com.inet.lib.json.JsonParameterizedType;
import com.inet.lib.util.PasswordHashing;
import com.inet.lib.util.StringFunctions;
import com.inet.logging.SecurityEventLog;
import com.inet.persistence.Persistence;
import com.inet.persistence.PersistenceListener;
import com.inet.plugin.ServerPluginManager;
import com.inet.plugin.veto.VetoManager;
import com.inet.thread.ThreadUtils;
import com.inet.usersandgroups.api.user.MutableUserData;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserAccountScope;
import com.inet.usersandgroups.api.user.UserManager;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.SuppressFBWarnings;

public class StayLoggedInHandler {
    public static final ConfigValue<String> SAME_SITE = new ConfigValue(ConfigKey.COOKIE_SAME_SITE);
    public static final ConfigValue<Boolean> AUTHENTICATION_STAY_LOGGED_IN = new ConfigValue(ConfigKey.AUTHENTICATION_STAY_LOGGED_IN);
    private static final String COOKIE = "SID";
    private static final int MAX_LOGIN_TIME_SECONDS = 2419200;
    private static final int MAX_SESSION_COUNT = 100;
    private static final Json a = new Json();
    private static final MemoryStoreMap<StayLoggedInSession, String[]> b = new MemoryStoreMap(5, false);
    private static final TwoFactorManager c;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean handleCookie(String loginProvider, @Nonnull HttpServletRequest request, @Nonnull HttpServletResponse response, boolean addNewSession) {
        Object object;
        if (addNewSession) {
            if (!AUTHENTICATION_STAY_LOGGED_IN.get().booleanValue()) {
                HttpSession httpSession = request.getSession(false);
                if (httpSession != null && httpSession.getAttribute(UserAgent.class.getName()) == null) {
                    httpSession.setAttribute(UserAgent.class.getName(), (Object)new UserAgent(request.getHeader("User-Agent")));
                }
                return false;
            }
            if (request.getRequestURI().contains("/api/")) {
                return false;
            }
        }
        UserManager userManager = UserManager.getInstance();
        GUID gUID = userManager.getCurrentUserAccountID();
        String string = StayLoggedInHandler.a(request);
        String[] stringArray = StayLoggedInHandler.a(string);
        if (VetoManager.getInstance().isCurrentlyVetoed() && !LoginManager.isUserManagerAvailable()) {
            return true;
        }
        if (stringArray != null) {
            object = stringArray[0];
            if (gUID != null && !StringFunctions.isEmpty((String)object) && !((String)object).equals(gUID.toString())) {
                StayLoggedInHandler.a(null, stringArray, string, request, false);
                stringArray = null;
                string = null;
            }
        }
        if (stringArray == null) {
            if (gUID == null) {
                return false;
            }
            if (loginProvider == null) {
                return false;
            }
            stringArray = new String[3];
            stringArray[0] = gUID.toString();
        }
        if (string != null && addNewSession) {
            Object object2 = object = ThreadUtils.getSemaphore(string);
            synchronized (object2) {
                HttpSession httpSession = request.getSession(false);
                if (httpSession != null && httpSession.getAttribute("WebUserInfo") != null) {
                    LoginManager.initUserAccount(request.getSession());
                    return true;
                }
                return StayLoggedInHandler.a(loginProvider, stringArray, string, request, response, addNewSession);
            }
        }
        return StayLoggedInHandler.a(loginProvider, stringArray, string, request, response, addNewSession);
    }

    private static boolean a(String string, String @Nonnull [] stringArray, String string2, @Nonnull HttpServletRequest httpServletRequest, @Nonnull HttpServletResponse httpServletResponse, boolean bl) {
        StayLoggedInHandler.a(string, stringArray, string2, httpServletRequest, bl);
        String string3 = StayLoggedInHandler.a(stringArray);
        String string4 = COOKIE + httpServletRequest.getLocalPort();
        Cookie cookie = new Cookie(string4, string3);
        cookie.setHttpOnly(true);
        cookie.setSecure(httpServletRequest.isSecure());
        String string5 = httpServletRequest.getContextPath();
        cookie.setPath(string5.isEmpty() ? "/" : string5);
        cookie.setAttribute("SameSite", SAME_SITE.get());
        if (StringFunctions.isEmpty(string3)) {
            cookie.setMaxAge(0);
            LoginProcessor.LOGGER.debug("Delete login cookie: " + string2);
            SecurityEventLog.DeleteLoginCookie.log(string2);
        } else {
            cookie.setMaxAge(2419200);
            LoginProcessor.LOGGER.debug("Send new login cookie: " + string3);
            httpServletRequest.getSession().setAttribute(COOKIE, (Object)cookie);
            SecurityEventLog.NewLoginCookie.log(string3);
        }
        httpServletResponse.addCookie(cookie);
        return !StringFunctions.isEmpty(stringArray[0]);
    }

    @SuppressFBWarnings(value={"COOKIE_USAGE"}, justification="cookie data need live longer as session")
    public static void checkCookie(@Nonnull HttpSession session, @Nonnull HttpServletRequest request, @Nonnull HttpServletResponse response) {
        Object object = session.getAttribute(COOKIE);
        if (object != null && object instanceof Cookie) {
            Cookie cookie = (Cookie)object;
            String string = StayLoggedInHandler.a(request);
            if (Objects.equals(string, cookie.getValue())) {
                request.getSession().removeAttribute(COOKIE);
            } else {
                if (LoginProcessor.LOGGER.isDebug()) {
                    StringBuilder stringBuilder = new StringBuilder("Resend login cookie: ").append(cookie.getName()).append('=').append(cookie.getValue());
                    stringBuilder.append("\tReceived cookies:\n");
                    Cookie[] cookieArray = request.getCookies();
                    if (cookieArray != null) {
                        for (Cookie cookie2 : cookieArray) {
                            stringBuilder.append('\t').append(cookie2.getName()).append('=').append(cookie2.getValue()).append('\n');
                        }
                    }
                    LoginProcessor.LOGGER.debug(stringBuilder);
                }
                response.addCookie(cookie);
            }
        }
    }

    @Nullable
    @SuppressFBWarnings(value={"COOKIE_USAGE"}, justification="cookie data need live longer as session")
    private static String a(@Nonnull HttpServletRequest httpServletRequest) {
        String string = COOKIE + httpServletRequest.getLocalPort();
        Cookie[] cookieArray = httpServletRequest.getCookies();
        if (cookieArray != null) {
            for (Cookie cookie : cookieArray) {
                if (!string.equals(cookie.getName())) continue;
                return cookie.getValue();
            }
        }
        return null;
    }

    private static void a(String string2, String @Nonnull [] stringArray, String string4, @Nonnull HttpServletRequest httpServletRequest, boolean bl) {
        GUID gUID = GUID.valueOf(stringArray[0]);
        UserManager userManager = UserManager.getInstance();
        UserAccount userAccount = userManager.getUserAccount(gUID);
        if (userAccount == null || !userAccount.isActive()) {
            stringArray[0] = null;
            return;
        }
        if (c != null && c.forceTwoFactor() && !c.hasTwoFactorSettings(userAccount)) {
            try (UserAccountScope userAccountScope = UserAccountScope.create(gUID);){
                SecurityEventLog.LostLoginCookies.log("forcing two factor");
            }
            LoginProcessor.LOGGER.debug("All login cookies lost when forcing two factor for the user: " + String.valueOf(gUID));
            stringArray[0] = null;
            userManager.updateUserData(gUID, FieldStayLoggedIn.INSTANCE, string -> null);
            return;
        }
        userManager.updateUserData(gUID, FieldStayLoggedIn.INSTANCE, string3 -> {
            Object object;
            ArrayList arrayList;
            block38: {
                try {
                    arrayList = (ArrayList)a.fromJson((String)string3, (Type)new JsonParameterizedType((Type)((Object)ArrayList.class), new Type[]{StayLoggedInSession.class}));
                }
                catch (Throwable throwable) {
                    arrayList = new ArrayList();
                    if (StringFunctions.isEmpty(string3)) break block38;
                    object = UserAccountScope.create(gUID);
                    try {
                        SecurityEventLog.LostLoginCookies.log("parsing");
                    }
                    finally {
                        if (object != null) {
                            ((UserAccountScope)object).close();
                        }
                    }
                    LoginProcessor.LOGGER.debug("All login cookies lost when parsing for the user: " + String.valueOf(gUID));
                }
            }
            int n2 = arrayList.size();
            object = string2;
            boolean bl2 = bl;
            String string4 = stringArray[1];
            boolean bl3 = string4 == null;
            String[] stringArray2 = null;
            long l2 = System.currentTimeMillis() - 2419200000L;
            Object object2 = arrayList.iterator();
            while (object2.hasNext()) {
                UserAccountScope userAccountScope;
                StayLoggedInSession stayLoggedInSession = (StayLoggedInSession)object2.next();
                if (stayLoggedInSession.getLastUse() < l2) {
                    object2.remove();
                    if (!LoginProcessor.LOGGER.isDebug()) continue;
                    LoginProcessor.LOGGER.debug("Login token removed because outdated: user: " + userAccount.getDisplayName() + "; os: " + String.valueOf((Object)stayLoggedInSession.getOS()) + "; browser: " + String.valueOf((Object)stayLoggedInSession.getBrowser()) + "; date: " + String.valueOf(new Timestamp(stayLoggedInSession.getLastUse())));
                    continue;
                }
                if (string4 == null || !string4.equals(stayLoggedInSession.getClientID())) continue;
                object2.remove();
                object = stayLoggedInSession.getProvider();
                if (!bl2) break;
                stringArray2 = (String[])b.get(stayLoggedInSession);
                if (stringArray2 == null && !PasswordHashing.isMatching(stayLoggedInSession.getHashToken(), stringArray[2].toCharArray())) {
                    bl3 = false;
                    string4 = null;
                    stringArray[1] = null;
                    userAccountScope = UserAccountScope.create(gUID);
                    try {
                        SecurityEventLog.InvalidLoginCookie.log("old token " + string4);
                    }
                    finally {
                        if (userAccountScope != null) {
                            userAccountScope.close();
                        }
                    }
                    LoginProcessor.LOGGER.debug("Invalid login cookie: " + string4);
                    break;
                }
                if (!LoginManager.getActiveStayLoginProviders().contains(object)) {
                    bl3 = false;
                    string4 = null;
                    stringArray[1] = null;
                    stringArray2 = null;
                    userAccountScope = UserAccountScope.create(gUID);
                    try {
                        SecurityEventLog.InvalidLoginCookie.log("inactive provider " + (String)object);
                    }
                    finally {
                        if (userAccountScope != null) {
                            userAccountScope.close();
                        }
                    }
                    LoginProcessor.LOGGER.debug("Provider '" + (String)object + "' of login cookie is not active");
                    break;
                }
                bl3 = true;
                LoginProcessor.LOGGER.debug("Login token validated: " + string4);
                break;
            }
            if (bl2 && !bl3 && string2 != null && stringArray[0] != null) {
                object = string2;
                string4 = null;
                bl3 = true;
            }
            if (bl2 && bl3) {
                if (stringArray2 != null) {
                    stringArray[2] = stringArray2[2];
                } else {
                    if (string4 == null) {
                        stringArray[1] = string4 = GUID.generateNew().toString();
                    }
                    stringArray[2] = GUID.generateNew().toString();
                }
                object2 = new StayLoggedInSession(httpServletRequest, (String)object, stringArray);
                b.put((StayLoggedInSession)object2, stringArray);
                httpServletRequest.getSession().setAttribute(StayLoggedInSession.class.getName(), object2);
                arrayList.add(object2);
            } else {
                stringArray[0] = null;
            }
            if (arrayList.size() > 100) {
                arrayList.remove(0);
            }
            if (arrayList.size() == 0 && n2 > 0) {
                object2 = UserAccountScope.create(gUID);
                try {
                    SecurityEventLog.LostLoginCookies.log("validating");
                }
                finally {
                    if (object2 != null) {
                        ((UserAccountScope)object2).close();
                    }
                }
                LoginProcessor.LOGGER.debug("All login cookies lost when validation for the user: " + String.valueOf(gUID));
            }
            return a.toJson(arrayList);
        });
        if (!StringFunctions.isEmpty(stringArray[0]) && string2 == null) {
            Object object;
            String string5 = null;
            StayLoggedInSession stayLoggedInSession = (StayLoggedInSession)httpServletRequest.getSession().getAttribute(StayLoggedInSession.class.getName());
            if (stayLoggedInSession != null) {
                object = stayLoggedInSession.getProvider();
                for (AuthenticationDescription authenticationDescription : LoginManager.getAllAuthenticationDescriptions()) {
                    if (!authenticationDescription.getName().equals(object)) continue;
                    AuthenticationProvider authenticationProvider = authenticationDescription.getProvider();
                    string5 = authenticationProvider instanceof SystemAuthenticationProvider ? "system" : string2;
                }
            }
            object = userManager.getNonSessionLoginProcessor(gUID, null, string5);
            LoginManager.setCurrentLoginProcessor(httpServletRequest, (LoginProcessor)object);
            LoginManager.initUserAccount(httpServletRequest.getSession());
        }
    }

    private static String a(String[] stringArray) {
        if (stringArray == null || StringFunctions.isEmpty(stringArray[0])) {
            return "";
        }
        Base64.Encoder encoder = Base64.getUrlEncoder();
        byte[] byArray = a.toJson(stringArray).getBytes(StandardCharsets.ISO_8859_1);
        return encoder.encodeToString(byArray);
    }

    private static String[] a(@Nullable String string) {
        if (StringFunctions.isEmpty(string)) {
            return null;
        }
        try {
            byte[] byArray = Base64.getUrlDecoder().decode(string);
            String[] stringArray = a.fromJson(byArray, String[].class);
            if (stringArray == null || stringArray.length != 3) {
                return null;
            }
            if (stringArray[0] == null || stringArray[1] == null || stringArray[2] == null) {
                return null;
            }
            return stringArray;
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Nonnull
    public static List<StayLoggedInSession> getSessions(GUID accountID) {
        return StayLoggedInHandler.getSessions(accountID, UserManager.getInstance());
    }

    @Nonnull
    public static List<StayLoggedInSession> getSessions(GUID accountID, UserManager userManager) {
        UserAccount userAccount = userManager.getUserAccount(accountID);
        if (userAccount == null) {
            return Collections.emptyList();
        }
        String string = userAccount.getValue(FieldStayLoggedIn.INSTANCE);
        if (string == null) {
            return Collections.emptyList();
        }
        List list = (List)new Json().fromJson(string, (Type)new JsonParameterizedType((Type)((Object)ArrayList.class), new Type[]{StayLoggedInSession.class}));
        return list;
    }

    public static void deleteAllStayLoggedInSessions() {
        SecurityEventLog.DeleteAllLoginCookies.log(new Object[0]);
        LoginProcessor.LOGGER.debug("Delete all login cookies of all users");
        UserManager userManager = UserManager.getRecoveryEnabledInstance();
        MutableUserData mutableUserData = new MutableUserData();
        mutableUserData.put(FieldStayLoggedIn.INSTANCE, null);
        Iterator<GUID> iterator = userManager.getIteratorOverUserAccountIDs();
        while (iterator.hasNext()) {
            GUID gUID = iterator.next();
            userManager.updateUserData(gUID, mutableUserData);
        }
    }

    public static void deleteSessions(@Nonnull GUID accountID, @Nonnull List<StayLoggedInSession> toDelete) {
        StayLoggedInHandler.deleteSessions(accountID, toDelete, UserManager.getInstance());
    }

    public static void deleteSessions(@Nonnull GUID accountID, @Nonnull List<StayLoggedInSession> toDelete, UserManager userManager) {
        if (toDelete.isEmpty()) {
            return;
        }
        try (Object object = UserAccountScope.create(accountID);){
            StringBuilder stringBuilder = new StringBuilder();
            if (stringBuilder.length() > 0) {
                stringBuilder.append(", ");
            }
            for (StayLoggedInSession stayLoggedInSession : toDelete) {
                stringBuilder.append(stayLoggedInSession.getOS().getDisplayName()).append('-').append(stayLoggedInSession.getBrowser().getDisplayName());
            }
            SecurityEventLog.DeleteLoginCookie.log(stringBuilder);
            LoginProcessor.LOGGER.debug("Delete login cookie sessions: " + String.valueOf(stringBuilder));
        }
        userManager.updateUserData(accountID, FieldStayLoggedIn.INSTANCE, string -> {
            ArrayList arrayList;
            try {
                arrayList = (ArrayList)a.fromJson((String)string, (Type)new JsonParameterizedType((Type)((Object)ArrayList.class), new Type[]{StayLoggedInSession.class}));
            }
            catch (Throwable throwable) {
                arrayList = new ArrayList();
            }
            arrayList.removeAll(toDelete);
            return a.toJson(arrayList);
        });
        try {
            StayLoggedInHandler.a(toDelete);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        object = new StayLoggedinNodeEvent();
        ((StayLoggedinNodeEvent)object).delete = toDelete;
        Persistence.getInstance().sendEvent(object);
    }

    private static void a(List<StayLoggedInSession> list) {
        Collection<HttpSession> collection = ExpandableHttpSessionListener.getActiveSessions();
        for (HttpSession httpSession : collection) {
            Object object = httpSession.getAttribute(StayLoggedInSession.class.getName());
            if (object == null || !list.contains(object)) continue;
            try {
                httpSession.invalidate();
            }
            catch (IllegalStateException illegalStateException) {}
        }
    }

    static {
        Persistence.getInstance().registerListener(new a());
        c = ServerPluginManager.getInstance().getOptionalInstance(TwoFactorManager.class);
    }

    @JsonData
    private static class StayLoggedinNodeEvent {
        private List<StayLoggedInSession> delete;

        private StayLoggedinNodeEvent() {
        }
    }

    private static class a
    implements PersistenceListener<StayLoggedinNodeEvent> {
        private a() {
        }

        public void a(StayLoggedinNodeEvent stayLoggedinNodeEvent) {
            StayLoggedInHandler.a(stayLoggedinNodeEvent.delete);
        }

        @Override
        public /* synthetic */ void eventReceived(Object object) {
            this.a((StayLoggedinNodeEvent)object);
        }
    }
}

