/*
 * Decompiled with CFR 0.152.
 */
package com.inet.plugin.image;

import com.inet.id.GUID;
import com.inet.lib.util.IOFunctions;
import com.inet.logging.LogManager;
import com.inet.plugin.image.AvatarMetadataField;
import com.inet.plugin.image.AvatarProviderField;
import com.inet.usersandgroups.api.user.BinaryDataKey;
import com.inet.usersandgroups.api.user.UserAccount;
import com.inet.usersandgroups.api.user.UserManager;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.stream.ImageInputStream;

public class UserAvatar {
    public static final BinaryDataKey BINARYKEY_USERAVATAR = new BinaryDataKey("useravatar", true);
    public static final AvatarProviderField FIELD_AVATAR_PROVIDER = new AvatarProviderField();
    public static final AvatarMetadataField FIELD_AVATAR_METADATA = new AvatarMetadataField();

    public static byte[] getAvatar(GUID userId) {
        return UserAvatar.getAvatar(userId, 300, false);
    }

    public static byte[] getCircleAvatar(GUID userId) {
        return UserAvatar.getCircleAvatar(userId, 300);
    }

    public static byte[] getCircleAvatar(GUID userId, int size) {
        return UserAvatar.getCircleAvatar(userId, size, UserManager.getInstance());
    }

    public static byte[] getCircleAvatar(GUID userId, int size, UserManager userManager) {
        byte[] byArray = UserAvatar.getAvatar(userId, size, false, userManager);
        if (byArray != null) {
            try {
                BufferedImage bufferedImage = ImageIO.read(new ByteArrayInputStream(byArray));
                BufferedImage bufferedImage2 = new BufferedImage(size, size, 2);
                Graphics2D graphics2D = (Graphics2D)bufferedImage2.getGraphics();
                graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                graphics2D.setClip(new Ellipse2D.Float(0.0f, 0.0f, size, size));
                graphics2D.drawImage(bufferedImage, 0, 0, size, size, null);
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)bufferedImage2, "PNG", byteArrayOutputStream);
                byArray = byteArrayOutputStream.toByteArray();
            }
            catch (IOException iOException) {
                LogManager.getApplicationLogger().error(iOException);
            }
        }
        return byArray;
    }

    public static byte[] getGeneratedCircleAvatar(String userName, int size) {
        return UserAvatar.getGeneratedCircleAvatar(null, userName, size);
    }

    public static byte[] getGeneratedCircleAvatar(GUID userId, String userName, int size) {
        Object object;
        BufferedImage bufferedImage;
        byte[] byArray = null;
        try {
            bufferedImage = UserAvatar.a(userId, userName, size);
            if (bufferedImage != null) {
                object = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)bufferedImage, "PNG", (OutputStream)object);
                byArray = ((ByteArrayOutputStream)object).toByteArray();
            }
        }
        catch (Throwable throwable) {
            LogManager.getApplicationLogger().error(throwable);
        }
        if (byArray != null) {
            try {
                bufferedImage = ImageIO.read(new ByteArrayInputStream(byArray));
                object = new BufferedImage(size, size, 2);
                Graphics2D graphics2D = (Graphics2D)((BufferedImage)object).getGraphics();
                graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                graphics2D.setClip(new Ellipse2D.Float(0.0f, 0.0f, size, size));
                graphics2D.drawImage(bufferedImage, 0, 0, size, size, null);
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)object, "PNG", byteArrayOutputStream);
                byArray = byteArrayOutputStream.toByteArray();
            }
            catch (IOException iOException) {
                LogManager.getApplicationLogger().error(iOException);
            }
        }
        return byArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] getAvatar(GUID userId, int size, boolean onlyGenerated, UserManager userManager) {
        try {
            Object object;
            if (userId == null) {
                return IOFunctions.getFileBuffer(UserAvatar.class.getResource("noimage.png"));
            }
            UserAccount userAccount = userManager.getUserAccount(userId);
            if (userAccount == null) {
                return IOFunctions.getFileBuffer(UserAvatar.class.getResource("noimage.png"));
            }
            if (!onlyGenerated) {
                object = userManager.getBinaryData(userId, BINARYKEY_USERAVATAR);
                try {
                    if (object != null) {
                        byte[] byArray = IOFunctions.readBytes((InputStream)object);
                        return byArray;
                    }
                }
                finally {
                    if (object != null) {
                        ((InputStream)object).close();
                    }
                }
            }
            if (!userAccount.getLoginSettingsFor("guest").isEmpty()) {
                return IOFunctions.getFileBuffer(UserAvatar.class.getResource("noimage.png"));
            }
            object = UserAvatar.a(userId, userAccount.getDisplayName(), size);
            if (object != null) {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)object, "PNG", byteArrayOutputStream);
                return byteArrayOutputStream.toByteArray();
            }
        }
        catch (IOException iOException) {
            LogManager.getApplicationLogger().error(iOException);
        }
        try {
            return IOFunctions.getFileBuffer(UserAvatar.class.getResource("noimage.png"));
        }
        catch (IOException iOException) {
            LogManager.getApplicationLogger().error(iOException);
            return null;
        }
    }

    public static byte[] getAvatar(GUID userId, int size, boolean onlyGenerated) {
        return UserAvatar.getAvatar(userId, size, onlyGenerated, UserManager.getInstance());
    }

    private static BufferedImage a(GUID gUID, String string, int n2) {
        int n3 = (string = string.replace('/', '\\')).lastIndexOf(92);
        if (n3 >= 0) {
            String string2 = string.substring(n3 + 1);
            if (string2.length() == 0) {
                string = string.substring(0, n3);
                string = string.replace("/", "");
                string = string.replace("\\", "");
            } else {
                string = string2;
            }
        }
        return UserAvatar.b(gUID, string, n2);
    }

    private static BufferedImage b(GUID gUID, String string, int n2) {
        BufferedImage bufferedImage = new BufferedImage(n2, n2, 5);
        Graphics graphics = bufferedImage.getGraphics();
        Font font = graphics.getFont();
        String[] stringArray = string.split(" |-");
        StringBuilder stringBuilder = new StringBuilder(stringArray.length);
        for (String string2 : stringArray) {
            if (string2.isEmpty()) continue;
            for (int i2 = 0; i2 < string2.length(); ++i2) {
                char c2 = string2.charAt(i2);
                if (!font.canDisplay(c2) || stringBuilder.length() != 0 && i2 != 0 && (c2 < 'A' || c2 > 'Z')) continue;
                stringBuilder.append(c2);
            }
        }
        Object object = stringBuilder.toString().toUpperCase();
        Color color = null;
        color = gUID != null ? UserAvatar.a(gUID) : UserAvatar.a(string);
        graphics.setColor(color);
        graphics.fillRect(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
        if (!((String)object).isEmpty()) {
            double d2;
            if (((String)object).length() > 5) {
                object = ((String)object).substring(0, 5);
            }
            ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            TextLayout textLayout = null;
            double d3 = n2;
            double d4 = n2;
            float f2 = n2;
            double d5 = 0.6;
            double d6 = d2 = ((String)object).length() == 1 ? d5 : 0.75;
            while (d3 >= (double)bufferedImage.getWidth(null) * d2 || d4 >= (double)bufferedImage.getHeight(null) * d5) {
                font = font.deriveFont(f2 -= 1.0f);
                textLayout = new TextLayout((String)object, font, ((Graphics2D)graphics).getFontRenderContext());
                d3 = textLayout.getBounds().getWidth();
                d4 = textLayout.getBounds().getHeight();
            }
            graphics.setFont(font);
            int n3 = (int)(((double)bufferedImage.getWidth(null) - d3) / 2.0 - (textLayout == null ? 0.0 : textLayout.getBounds().getX()));
            int n4 = (int)(((double)bufferedImage.getHeight(null) + d4) / 2.0);
            graphics.setColor(Color.WHITE);
            graphics.drawString((String)object, n3, n4);
        }
        return bufferedImage;
    }

    private static char a(char c2) {
        if (c2 >= '0' && c2 <= '9') {
            c2 = (char)(c2 - 48);
        }
        if (c2 >= 'a' && c2 <= 'z') {
            c2 = (char)(c2 - 87);
        }
        return c2;
    }

    private static Color a(GUID gUID) {
        int n2;
        int n3;
        if (UserManager.MASTER_ACCOUNT_ID.equals(gUID)) {
            return Color.getHSBColor(0.0f, 0.8f, 0.8f);
        }
        String string = gUID.toString();
        float f2 = (float)UserAvatar.a(string.charAt(1)) / 35.0f;
        float f3 = (float)UserAvatar.a(string.charAt(9)) / 35.0f;
        float f4 = (float)UserAvatar.a(string.charAt(17)) / 35.0f;
        boolean bl = true;
        for (n3 = 0; n3 < 9; ++n3) {
            n2 = string.charAt(n3);
            if (n2 >= 48 && n2 <= 57) continue;
            bl = false;
            break;
        }
        if (bl) {
            n3 = 1;
            for (n2 = 9; n2 < 25; ++n2) {
                char c2 = string.charAt(n2);
                if (c2 <= 'f') continue;
                n3 = 0;
                break;
            }
            if (n3 != 0) {
                float f5 = 0.21818182f;
                f2 = (float)Math.round((float)(UserAvatar.a(string.charAt(12)) * 10 + UserAvatar.a(string.charAt(13))) * f5) / 35.0f;
                f3 = (float)Math.round((float)(UserAvatar.a(string.charAt(17)) * 10 + UserAvatar.a(string.charAt(18))) * f5) / 35.0f;
                f4 = (float)Math.round((float)(UserAvatar.a(string.charAt(23)) * 10 + UserAvatar.a(string.charAt(24))) * f5) / 35.0f;
            } else {
                f2 = (float)UserAvatar.a(string.charAt(10)) / 35.0f;
                f3 = (float)UserAvatar.a(string.charAt(17)) / 35.0f;
                f4 = (float)UserAvatar.a(string.charAt(24)) / 35.0f;
            }
        }
        f2 *= 0.98f;
        f3 *= 0.6f;
        f4 /= 2.0f;
        f4 *= (f3 += 0.3f);
        return Color.getHSBColor(f2 += 0.01f, f3, f4 += 0.5f);
    }

    private static Color a(String string) {
        Color color = null;
        int n2 = 60;
        int n3 = 160;
        int n4 = n3 - n2;
        int n5 = string.hashCode();
        int n6 = Math.abs(n5 % (6 * n4));
        switch (n6 / n4) {
            case 0: {
                color = new Color(n3, n2, n2 + n6);
                break;
            }
            case 1: {
                color = new Color(n3 - (n6 -= n4), n2, n3);
                break;
            }
            case 2: {
                color = new Color(n2, n2 + (n6 -= 2 * n4), n3);
                break;
            }
            case 3: {
                color = new Color(n2, n3, n3 - (n6 -= 3 * n4));
                break;
            }
            case 4: {
                color = new Color(n2 + (n6 -= 4 * n4), n3, n2);
                break;
            }
            case 5: {
                color = new Color(n3, n3 - (n6 -= 5 * n4), n2);
            }
        }
        return color;
    }

    public static byte[] createScaledUserImage(InputStream imageStream, int width, int height, int left, int top) throws Exception {
        ByteArrayOutputStream byteArrayOutputStream;
        block31: {
            byteArrayOutputStream = new ByteArrayOutputStream();
            Object object = null;
            if (imageStream != null) {
                int n2 = -1;
                try (ImageInputStream imageInputStream = ImageIO.createImageInputStream(imageStream);){
                    Object object2;
                    Object object3;
                    int n3;
                    Object object4;
                    int n4;
                    Object object5;
                    Object object6;
                    Object object7;
                    Object object8;
                    int n5;
                    ImageReader imageReader;
                    block30: {
                        Iterator<ImageReader> iterator = ImageIO.getImageReaders(imageInputStream);
                        if (iterator != null && iterator.hasNext() && (imageReader = iterator.next()) != null) {
                            imageReader.setInput(imageInputStream);
                            n5 = imageReader.getNumImages(true);
                            if (n5 > 0) {
                                object = imageReader.read(0);
                            }
                            try {
                                object8 = imageReader.getImageMetadata(0);
                                if (!((IIOMetadata)object8).isStandardMetadataFormatSupported() || !(object7 = Arrays.asList(((IIOMetadata)object8).getMetadataFormatNames())).contains("javax_imageio_jpeg_image_1.0")) break block30;
                                object6 = ((IIOMetadata)object8).getAsTree("javax_imageio_jpeg_image_1.0");
                                object5 = object6.getChildNodes();
                                for (n4 = 0; n4 < object5.getLength(); ++n4) {
                                    if ("markerSequence".equals(object5.item(n4).getNodeName())) {
                                        object4 = object5.item(n4).getChildNodes();
                                        for (n3 = 0; n3 < object4.getLength(); ++n3) {
                                            IIOMetadataNode iIOMetadataNode = (IIOMetadataNode)object4.item(n3);
                                            object3 = (byte[])iIOMetadataNode.getUserObject();
                                            if (object3 == null) continue;
                                            object2 = new byte[4];
                                            ByteBuffer.wrap((byte[])object3).get((byte[])object2);
                                            if ("Exif".equals(new String((byte[])object2))) {
                                                n2 = UserAvatar.a((byte[])object3);
                                            }
                                            if (n2 != -1) break;
                                        }
                                    }
                                    if (n2 == -1) {
                                        continue;
                                    }
                                    break;
                                }
                            }
                            catch (Throwable throwable) {
                                LogManager.getApplicationLogger().debug("Error reading user image meta data");
                                LogManager.getApplicationLogger().debug(throwable);
                            }
                        }
                    }
                    if (object != null) {
                        int n6 = ((BufferedImage)object).getWidth();
                        n5 = ((BufferedImage)object).getHeight();
                        if (n2 != -1) {
                            object8 = new AffineTransform();
                            switch (n2) {
                                case 1: {
                                    break;
                                }
                                case 2: {
                                    ((AffineTransform)object8).scale(-1.0, 1.0);
                                    ((AffineTransform)object8).translate(-n6, 0.0);
                                    break;
                                }
                                case 3: {
                                    ((AffineTransform)object8).translate(n6, n5);
                                    ((AffineTransform)object8).rotate(Math.PI);
                                    break;
                                }
                                case 4: {
                                    ((AffineTransform)object8).scale(1.0, -1.0);
                                    ((AffineTransform)object8).translate(0.0, -n5);
                                    break;
                                }
                                case 5: {
                                    ((AffineTransform)object8).rotate(-1.5707963267948966);
                                    ((AffineTransform)object8).scale(-1.0, 1.0);
                                    break;
                                }
                                case 6: {
                                    ((AffineTransform)object8).translate(n5, 0.0);
                                    ((AffineTransform)object8).rotate(1.5707963267948966);
                                    break;
                                }
                                case 7: {
                                    ((AffineTransform)object8).scale(-1.0, 1.0);
                                    ((AffineTransform)object8).translate(-n5, 0.0);
                                    ((AffineTransform)object8).translate(0.0, n6);
                                    ((AffineTransform)object8).rotate(4.71238898038469);
                                    break;
                                }
                                case 8: {
                                    ((AffineTransform)object8).translate(0.0, n6);
                                    ((AffineTransform)object8).rotate(4.71238898038469);
                                    break;
                                }
                            }
                            object7 = new AffineTransformOp((AffineTransform)object8, 3);
                            object6 = ((AffineTransformOp)object7).createCompatibleDestImage((BufferedImage)object, ((BufferedImage)object).getType() == 10 ? ((BufferedImage)object).getColorModel() : null);
                            object5 = (Graphics2D)((BufferedImage)object6).getGraphics();
                            ((Graphics2D)object5).setTransform((AffineTransform)object8);
                            ((Graphics)object5).drawImage((Image)object, 0, 0, null);
                            ((Graphics)object5).dispose();
                            object = object6;
                            n6 = ((BufferedImage)object).getWidth();
                            n5 = ((BufferedImage)object).getHeight();
                        }
                        double d2 = (double)n6 / (double)width;
                        double d3 = (double)n5 / (double)height;
                        if (d2 < 1.0) {
                            BufferedImage bufferedImage = new BufferedImage(300, 300, 2);
                            object4 = (Graphics2D)bufferedImage.getGraphics();
                            ((Graphics2D)object4).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                            ((Graphics2D)object4).setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                            ((Graphics2D)object4).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                            ((Graphics2D)object4).setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                            ((Graphics)object4).drawImage((Image)object, 0, 0, 300, 300, (int)Math.round((double)(-left) * d2), (int)Math.round((double)(-top) * d3), (int)Math.round((double)(-left) * d2) + (int)Math.round(300.0 * d2), (int)Math.round((double)(-top) * d3) + (int)Math.round(300.0 * d3), null);
                            ((Graphics)object4).dispose();
                            object = bufferedImage;
                        } else {
                            n4 = (int)Math.round(300.0 * d2);
                            int n7 = (int)Math.round(300.0 * d3);
                            n3 = (int)Math.round((double)(-left) * d2);
                            int n8 = (int)Math.round((double)(-top) * d3);
                            object3 = new BufferedImage(n4, n7, 2);
                            object2 = (Graphics2D)((BufferedImage)object3).getGraphics();
                            ((Graphics)object2).drawImage((Image)object, 0, 0, n4, n7, n3, n8, n3 + n4, n8 + n7, null);
                            ((Graphics)object2).dispose();
                            Image image = ((Image)object3).getScaledInstance(300, 300, 4);
                            object = new BufferedImage(300, 300, 2);
                            Graphics graphics = ((BufferedImage)object).getGraphics();
                            graphics.drawImage(image, 0, 0, null);
                            graphics.dispose();
                        }
                        ImageIO.write((RenderedImage)object, "PNG", byteArrayOutputStream);
                        break block31;
                    }
                    imageReader = null;
                    return imageReader;
                }
            }
        }
        return byteArrayOutputStream.toByteArray();
    }

    private static int a(byte[] byArray) {
        if (byArray == null || byArray.length == 0) {
            return -1;
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        if (byteBuffer.getInt() != 1165519206 || byteBuffer.getShort() != 0) {
            throw new IllegalArgumentException("Invalid EXIF Header!");
        }
        byteBuffer = byteBuffer.slice();
        switch (byteBuffer.getShort()) {
            case 18761: {
                byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
                break;
            }
            case 19789: {
                byteBuffer.order(ByteOrder.BIG_ENDIAN);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid byte order!");
            }
        }
        if (byteBuffer.getShort() != 42) {
            throw new IllegalArgumentException("Invalid TIFF Header!");
        }
        byteBuffer.position(byteBuffer.getInt());
        int n2 = byteBuffer.getShort() & 0xFFFF;
        for (int i2 = 0; i2 < n2; ++i2) {
            short s = byteBuffer.getShort();
            if (s == 274) {
                byteBuffer.position(byteBuffer.position() + 6);
                return byteBuffer.getShort() & 0xFF;
            }
            byteBuffer.position(byteBuffer.position() + 10);
        }
        return -1;
    }
}

