/*
 * Decompiled with CFR 0.152.
 */
package com.inet.persistence.crypto;

import com.inet.annotations.InternalApi;
import com.inet.persistence.crypto.CryptoAlgorithm;
import com.inet.persistence.crypto.CryptoAlgorithmFactory;
import com.inet.persistence.crypto.EncryptionData;
import com.inet.persistence.crypto.aes.AESAlgorithmFactory;
import com.inet.plugin.ServerPluginManager;
import java.security.GeneralSecurityException;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@InternalApi
public class Crypto {
    private static final AESAlgorithmFactory a = new AESAlgorithmFactory();

    @Nullable
    public static CryptoAlgorithm create(char @Nonnull [] password, byte @Nonnull [] salt, @Nullable EncryptionData data) throws GeneralSecurityException {
        List<CryptoAlgorithmFactory> list = ServerPluginManager.getInstance().get(CryptoAlgorithmFactory.class);
        if (list.isEmpty()) {
            list.add(a);
        }
        String string = data != null && data.getAlgorithm() != null ? data.getAlgorithm() : a.getExtensionName();
        Optional<CryptoAlgorithmFactory> optional = list.stream().filter(cryptoAlgorithmFactory -> cryptoAlgorithmFactory.supports(string)).findFirst();
        if (optional.isEmpty()) {
            return null;
        }
        return optional.get().create(password, salt, data != null ? data.getCustomData() : null);
    }

    @Nullable
    public static CryptoAlgorithm create(char @Nonnull [] password, byte @Nonnull [] salt, @Nonnull String transformation) throws GeneralSecurityException {
        if (transformation == null || transformation.isEmpty()) {
            throw new IllegalArgumentException("Transformation must not ne empty");
        }
        List<CryptoAlgorithmFactory> list = ServerPluginManager.getInstance().get(CryptoAlgorithmFactory.class);
        list.add(a);
        Optional<CryptoAlgorithmFactory> optional = list.stream().filter(cryptoAlgorithmFactory -> cryptoAlgorithmFactory.supports(transformation)).findFirst();
        if (optional.isEmpty()) {
            return null;
        }
        return optional.get().create(password, salt, null);
    }

    @Nonnull
    public static List<String> getSupportedAlgorithms() {
        List<CryptoAlgorithmFactory> list = ServerPluginManager.getInstance().get(CryptoAlgorithmFactory.class);
        list.add(a);
        return list.stream().map(cryptoAlgorithmFactory -> cryptoAlgorithmFactory.getExtensionName()).collect(Collectors.toList());
    }
}

