/*
 * Decompiled with CFR 0.152.
 */
package com.inet.http.servlet;

import com.inet.lib.util.LocaleUtils;
import com.inet.lib.util.Scope;
import com.inet.lib.util.StringFunctions;
import com.inet.logging.LogID;
import com.inet.thread.SessionLocal;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.SuppressFBWarnings;

public class ClientLocale {
    private static final SessionLocal<Locale> a = new SessionLocal();

    @SuppressFBWarnings(value={"TRUST_BOUNDARY_VIOLATION"}, justification="data was validated for saving")
    public static void setThreadLocale(HttpServletRequest request) {
        LogID.reset();
        String string = request.getParameter("locale");
        Locale locale = null;
        HttpSession httpSession = request.getSession(false);
        if (string == null || string.length() == 0) {
            if (httpSession != null) {
                locale = (Locale)httpSession.getAttribute("RemoteGuiLocale");
            }
            if (locale == null && StringFunctions.isEmpty((locale = request.getLocale()).getCountry())) {
                Enumeration enumeration = request.getLocales();
                while (enumeration.hasMoreElements()) {
                    Locale locale2 = (Locale)enumeration.nextElement();
                    if (!Objects.equals(locale.getLanguage(), locale2.getLanguage()) || StringFunctions.isEmpty(locale2.getCountry())) continue;
                    locale = locale2;
                    break;
                }
            }
        } else {
            locale = LocaleUtils.valueOf(string);
            if (httpSession == null) {
                httpSession = request.getSession(true);
            }
            httpSession.setAttribute("RemoteGuiLocale", (Object)locale);
        }
        a.set(locale);
    }

    public static void setThreadLocale(@Nullable Locale locale) {
        a.set(locale);
    }

    @Nonnull
    public static Locale getThreadLocale() {
        Locale locale = a.get();
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return locale;
    }

    public static Scope scope(final Locale locale) {
        return new Scope(){
            private Locale b = ClientLocale.getThreadLocale();
            {
                ClientLocale.setThreadLocale(locale);
            }

            @Override
            public void close() {
                ClientLocale.setThreadLocale(this.b);
            }
        };
    }
}

