/*
 * Decompiled with CFR 0.152.
 */
package com.inet.http.security;

import com.inet.annotations.InternalApi;
import java.io.IOException;
import java.net.Socket;
import java.net.URLConnection;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.annotation.SuppressFBWarnings;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509ExtendedTrustManager;
import javax.net.ssl.X509TrustManager;

@InternalApi
public class TrustAllTrustManager
extends X509ExtendedTrustManager
implements X509TrustManager {
    private static SSLSocketFactory a;

    public static void trustAllCerticates(URLConnection conn, boolean checkHostname) throws IOException {
        if (conn instanceof HttpsURLConnection) {
            HttpsURLConnection httpsURLConnection = (HttpsURLConnection)conn;
            try {
                httpsURLConnection.setSSLSocketFactory(TrustAllTrustManager.getSSLSocketFactory());
                if (!checkHostname) {
                    httpsURLConnection.setHostnameVerifier(new HostnameVerifier(){

                        @Override
                        @SuppressFBWarnings(value={"WEAK_HOSTNAME_VERIFIER"}, justification="use for self signed certifcates only")
                        public boolean verify(String paramString, SSLSession paramSSLSession) {
                            return true;
                        }
                    });
                }
            }
            catch (Exception exception) {
                IOException iOException = new IOException();
                iOException.initCause(exception);
                throw iOException;
            }
        }
    }

    public static SSLSocketFactory getSSLSocketFactory() throws NoSuchAlgorithmException, KeyManagementException {
        if (a == null) {
            SSLContext sSLContext = SSLContext.getInstance("TLS");
            TrustManager[] trustManagerArray = new X509TrustManager[]{new TrustAllTrustManager()};
            sSLContext.init(null, trustManagerArray, null);
            a = sSLContext.getSocketFactory();
        }
        return a;
    }

    @Override
    @SuppressFBWarnings(value={"WEAK_TRUST_MANAGER"}, justification="use for self signed certifcates only")
    public void checkClientTrusted(X509Certificate[] chain, String authType) {
    }

    @Override
    @SuppressFBWarnings(value={"WEAK_TRUST_MANAGER"}, justification="use for self signed certifcates only")
    public void checkServerTrusted(X509Certificate[] chain, String authType) {
    }

    @Override
    @SuppressFBWarnings(value={"WEAK_TRUST_MANAGER"}, justification="use for self signed certifcates only")
    public X509Certificate[] getAcceptedIssuers() {
        return new X509Certificate[0];
    }

    @Override
    @SuppressFBWarnings(value={"WEAK_TRUST_MANAGER"}, justification="use for self signed certifcates only")
    public void checkClientTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
    }

    @Override
    @SuppressFBWarnings(value={"WEAK_TRUST_MANAGER"}, justification="use for self signed certifcates only")
    public void checkServerTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
    }

    @Override
    @SuppressFBWarnings(value={"WEAK_TRUST_MANAGER"}, justification="use for self signed certifcates only")
    public void checkClientTrusted(X509Certificate[] chain, String authType, SSLEngine engine) throws CertificateException {
    }

    @Override
    @SuppressFBWarnings(value={"WEAK_TRUST_MANAGER"}, justification="use for self signed certifcates only")
    public void checkServerTrusted(X509Certificate[] chain, String authType, SSLEngine engine) throws CertificateException {
    }
}

