/*
 * Decompiled with CFR 0.152.
 */
package com.inet.http.error;

import com.inet.annotations.JsonData;
import com.inet.authentication.LoginProcessor;
import com.inet.authentication.base.LoginManager;
import com.inet.error.ErrorCodeHelper;
import com.inet.http.error.ServletErrorHandler;
import com.inet.http.error.ServletErrorHandlerProvider;
import com.inet.http.servlet.NopServletOutputStream;
import com.inet.lib.io.UTF8StreamWriter;
import com.inet.lib.json.EncodedWriter;
import com.inet.lib.json.Json;
import com.inet.lib.util.StringFunctions;
import com.inet.logging.LogManager;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpServletResponseWrapper;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nonnull;

public class JsonErrorHandlerProvider
implements ServletErrorHandlerProvider {
    @Override
    public int priority(@Nonnull HttpServletRequest request, @Nonnull HttpServletResponse response, @Nonnull Throwable th) {
        String string = response.getContentType();
        boolean bl = string != null && (string.startsWith("application/json") || string.startsWith("application/binary-json"));
        String string2 = request.getHeader("Accept");
        bl = bl || string2 != null && string2.contains("application/error-json");
        return bl && LoginManager.isApplicationRequest(request) ? 300 : -300;
    }

    @Override
    public void sendErrorPage(HttpServletRequest request, HttpServletResponse response, Throwable error) {
        block7: {
            Object object;
            if (error != null && ServletErrorHandler.isClientAbort(error)) {
                return;
            }
            while (response instanceof HttpServletResponseWrapper) {
                response = (HttpServletResponse)((HttpServletResponseWrapper)response).getResponse();
            }
            int n2 = response.getStatus();
            if (n2 == 200) {
                n2 = ErrorCodeHelper.getHttpStatusCode(error);
                response.setStatus(n2);
                if (n2 == 401) {
                    object = new HttpServletResponseWrapper(response){

                        public void sendError(int sc) throws IOException {
                        }

                        @Nonnull
                        public ServletOutputStream getOutputStream() throws IOException {
                            return new NopServletOutputStream();
                        }
                    };
                    LoginManager.forceLogin(request, (HttpServletResponse)object);
                }
            }
            if (n2 == 401) {
                LoginProcessor.LOGGER.debug(error);
            }
            try {
                response.setCharacterEncoding(StandardCharsets.UTF_8.name());
                object = "application/binary-json".equals(response.getContentType()) ? new EncodedWriter((OutputStream)response.getOutputStream()) : new UTF8StreamWriter((OutputStream)response.getOutputStream());
                ExceptionJsonizer.toJson(error, (Writer)object);
                ((Writer)object).close();
            }
            catch (Throwable throwable) {
                if (ServletErrorHandler.isClientAbort(throwable)) break block7;
                LogManager.getConfigLogger().error(throwable);
            }
        }
    }

    public static class ExceptionJsonizer {
        public static void toJson(Throwable exception, Writer writer) throws IOException {
            new Json().toJson((Object)new JsonizableException(exception), writer);
        }

        @JsonData
        private static class JsonizableException {
            private String error;

            public JsonizableException(Throwable exception) {
                this.error = StringFunctions.getUserFriendlyErrorMessage(exception);
            }
        }
    }
}

