/*
 * Decompiled with CFR 0.152.
 */
package com.inet.font.truetype;

import com.inet.font.IRendererPostscript;
import com.inet.font.cache.FontNameProcessor;
import com.inet.font.truetype.FontFactoriesCache;
import com.inet.font.truetype.FontFactory;
import com.inet.font.truetype.InstalledFontTT;
import com.inet.font.truetype.ReplacingFontFinder;
import com.inet.font.truetype.SessionFontFactoryCache;
import com.inet.font.truetype.SubFontTT;
import com.inet.font.truetype.SubFontTrueType;
import com.inet.font.truetype.TTFont;
import com.inet.font.type1.SubFontType1;

public class InstalledFontTTSupplier {
    public static final InstalledFontTT getInstalledFont(String family_name, int style, IRendererPostscript postscript, boolean embedding, ReplacingFontFinder fontFinder) {
        FontFactory fontFactory = FontFactoriesCache.a(family_name, style &= 3);
        if (fontFactory == null && style != 0 && (fontFactory = FontFactoriesCache.a(family_name, 0)) == null && style == 3 && (fontFactory = FontFactoriesCache.a(family_name, 1)) == null) {
            fontFactory = FontFactoriesCache.a(family_name, 2);
        }
        if (fontFactory == null) {
            fontFactory = SessionFontFactoryCache.a(family_name);
            if (fontFactory == null) {
                fontFactory = SessionFontFactoryCache.a(FontNameProcessor.getCompositeName(family_name, style));
            }
            if (fontFactory == null) {
                fontFactory = SessionFontFactoryCache.a(FontNameProcessor.getCompositeName(family_name, 0));
            }
        }
        if (fontFactory != null) {
            TTFont tTFont = fontFactory.getFontTT(postscript);
            if (embedding && tTFont.isEmbedded()) {
                SubFontTT subFontTT;
                SubFontTT subFontTT2 = subFontTT = fontFinder != null ? (SubFontTT)fontFinder.getInstalledFontMap().get(tTFont) : null;
                if (subFontTT == null) {
                    subFontTT = tTFont.getFontCollection().isType1() ? new SubFontType1(tTFont, fontFinder) : new SubFontTrueType(tTFont, fontFinder);
                    if (fontFinder != null) {
                        fontFinder.getInstalledFontMap().put(tTFont, subFontTT);
                    }
                }
                return subFontTT;
            }
            return new InstalledFontTT(tTFont, fontFinder);
        }
        return null;
    }
}

