/*
 * Decompiled with CFR 0.152.
 */
package com.inet.font.layout;

import com.inet.font.FontUtils;
import com.inet.font.layout.FontLayout;
import com.inet.logging.LogManager;

public abstract class AdobeFontLayout
extends FontLayout {
    private static final int CHAR_INTERVAL_UNDEFINED = 0;
    private static final int CHAR_INTERVAL_LATIN = 1;
    public static final int CHAR_INTERVAL_SYMBOL = 2;
    private static final int CHAR_INTERVAL_EUROPEAN = 4;
    private static final int CHAR_INTERVAL_ASIAN = 8;
    public static final int FONT_FAMILY_UNDEFINED = -1;
    public static final int FONT_FAMILY_SERIF_ID = 0;
    public static final int FONT_FAMILY_SANSSERIF_ID = 1;
    public static final int FONT_FAMILY_MONOSPACED_ID = 2;
    public static final int FONT_FAMILY_SYMBOL_ID = 3;
    private int a;
    private int b;
    private int c;
    private long d;

    AdobeFontLayout(FontLayout lineLayout) {
        super(lineLayout.getName(), lineLayout.getStyle(), lineLayout.getSizeTwips());
        this.a = lineLayout.getAscent();
        this.b = lineLayout.getDescent();
        this.c = lineLayout.getLeading();
    }

    @Override
    public int getAscent() {
        return this.a;
    }

    @Override
    public int getDescent() {
        return this.b;
    }

    @Override
    public int getLeading() {
        return this.c;
    }

    @Override
    public boolean equals(Object layout) {
        boolean bl = super.equals(layout);
        if (bl && layout instanceof AdobeFontLayout) {
            bl = this.getRange() == ((AdobeFontLayout)layout).getRange();
        }
        return bl;
    }

    @Override
    public int stringWidthSpecial(String text) {
        return 0;
    }

    public void setRange(long range) {
        this.d = range;
    }

    public long getRange() {
        return this.d != 0L ? this.d : 1L;
    }

    public static int substitute(int c2) {
        switch (c2) {
            case 338: {
                c2 = 140;
                break;
            }
            case 339: {
                c2 = 156;
                break;
            }
            case 352: {
                c2 = 138;
                break;
            }
            case 353: {
                c2 = 154;
                break;
            }
            case 402: {
                c2 = 102;
                break;
            }
            case 710: {
                c2 = 94;
                break;
            }
            case 732: {
                c2 = 152;
                break;
            }
            case 8194: 
            case 8195: {
                c2 = 32;
                break;
            }
            case 8211: {
                c2 = 150;
                break;
            }
            case 8212: {
                c2 = 151;
                break;
            }
            case 8216: {
                c2 = 145;
                break;
            }
            case 8217: {
                c2 = 146;
                break;
            }
            case 8218: {
                c2 = 130;
                break;
            }
            case 8220: {
                c2 = 147;
                break;
            }
            case 8221: {
                c2 = 148;
                break;
            }
            case 8222: {
                c2 = 132;
                break;
            }
            case 8225: {
                c2 = 135;
                break;
            }
            case 8226: {
                c2 = 149;
                break;
            }
            case 8230: {
                c2 = 133;
                break;
            }
            case 8240: {
                c2 = 137;
                break;
            }
            case 8249: {
                c2 = 139;
                break;
            }
            case 8250: {
                c2 = 155;
                break;
            }
            case 8364: {
                c2 = 128;
                break;
            }
            case 8482: {
                c2 = 153;
                break;
            }
            default: {
                if (LogManager.getApplicationLogger().isDebug()) {
                    LogManager.getApplicationLogger().debug("char " + c2 + " not found in table");
                }
                c2 = 0;
            }
        }
        return c2;
    }

    public static int getFontFamilyId(String font_name, long range) {
        if (font_name.equalsIgnoreCase("Symbol") || range == 2L) {
            return 3;
        }
        String string = FontUtils.getFontMapping(font_name);
        int n2 = string.equalsIgnoreCase("SERIF") ? 0 : (string.equalsIgnoreCase("SANSSERIF") ? 1 : (string.equalsIgnoreCase("MONOSPACED") ? 2 : 0));
        return n2;
    }
}

