/*
 * Decompiled with CFR 0.152.
 */
package com.inet.html.parser.converter;

import com.inet.html.InetHtmlDocument;
import com.inet.html.parser.converter.AttributeValue;
import com.inet.html.parser.converter.HtmlAttribute;

public class WhiteSpace
extends HtmlAttribute {
    static final WhiteSpace PARSER = new WhiteSpace();
    public static final byte NORMAL = 0;
    public static final byte PRE = 1;
    public static final byte NOWRAP = 2;
    public static final byte PREWRAP = 3;
    public static final byte PRELINE = 4;
    public static final byte AUTOWRAP = 5;
    private byte value;
    private boolean writeValue = true;

    public byte getValue() {
        return this.value;
    }

    @Override
    AttributeValue parseHtmlValue(InetHtmlDocument doc, String valueStr) {
        if (valueStr == null || valueStr.isEmpty()) {
            WhiteSpace whiteSpace = new WhiteSpace();
            whiteSpace.value = (byte)2;
            whiteSpace.setString(null);
            whiteSpace.writeValue = false;
            return whiteSpace;
        }
        return this.parseCssValue(valueStr, false);
    }

    @Override
    public boolean isWriteValue() {
        return this.writeValue;
    }

    @Override
    protected AttributeValue parseCssValue(String valueStr, boolean important) {
        WhiteSpace whiteSpace = new WhiteSpace();
        String string = valueStr = valueStr != null ? valueStr.toLowerCase() : null;
        if ("inherit".equals(valueStr)) {
            return AttributeValue.INHERIT;
        }
        if (valueStr == null || valueStr.length() == 0) {
            whiteSpace.value = (byte)5;
        } else if (valueStr.equals("normal")) {
            whiteSpace.value = 0;
        } else if (valueStr.equals("pre")) {
            whiteSpace.value = 1;
        } else if (valueStr.equals("nowrap")) {
            whiteSpace.value = (byte)2;
        } else if (valueStr.equals("pre-wrap")) {
            whiteSpace.value = (byte)3;
        } else if (valueStr.equals("pre-line")) {
            whiteSpace.value = (byte)4;
        } else {
            return null;
        }
        whiteSpace.setString(valueStr);
        return whiteSpace;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof WhiteSpace)) {
            return false;
        }
        WhiteSpace other = (WhiteSpace)obj;
        if (this.isImportant() != other.isImportant()) {
            return false;
        }
        return this.value == other.value;
    }

    @Override
    boolean allowesEmptyValue() {
        return true;
    }

    public boolean isCollapseSpaces() {
        return this.value != 1 && this.value != 3;
    }
}

