/*
 * Decompiled with CFR 0.152.
 */
package com.inet.html.parser.converter;

import com.inet.html.InetHtmlDocument;
import com.inet.html.parser.converter.AttributeValue;
import com.inet.html.parser.converter.UriValue;
import com.inet.html.parser.converter.UrlValue;

public class SrcDataValue
extends UrlValue {
    private boolean isCSSattribute;

    public SrcDataValue(String value) {
        super(value);
    }

    public void setCSSattribute(boolean isCSSattribute) {
        this.isCSSattribute = isCSSattribute;
    }

    @Override
    public String toString() {
        return this.isCSSattribute ? "url(" + super.toString() + ")" : super.toString();
    }

    @Override
    protected AttributeValue parseCssValue(String valueStr, boolean important) {
        int idx;
        String lower = valueStr.toLowerCase();
        if (lower.startsWith("url(") && (idx = valueStr.lastIndexOf(41)) > 0) {
            char c2;
            char c1;
            String urlValue = valueStr.substring(4, idx).trim();
            if (urlValue.length() >= 2 && (c1 = urlValue.charAt(0)) == (c2 = urlValue.charAt(urlValue.length() - 1)) && (c1 == '\'' || c1 == '\"')) {
                urlValue = urlValue.substring(1, urlValue.length() - 1);
            }
            SrcDataValue value = new SrcDataValue(urlValue);
            value.setString(urlValue);
            value.isCSSattribute = true;
            return value;
        }
        UriValue result = new UriValue();
        result.parseCssValue(valueStr, important);
        return result;
    }

    @Override
    AttributeValue parseHtmlValue(InetHtmlDocument doc, String value) {
        if (value != null && value.startsWith("data:")) {
            SrcDataValue result = new SrcDataValue(value);
            result.isCSSattribute = true;
            return result;
        }
        return new UrlValue(value, doc.getBase());
    }
}

