/*
 * Decompiled with CFR 0.152.
 */
package com.inet.editor;

import com.inet.editor.BaseEditor;
import com.inet.editor.HtmlConverter;
import com.inet.editor.HtmlEditorUtils;
import com.inet.editor.handler.HyperlinkHandler;
import com.inet.html.utils.Logger;
import java.net.URL;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class DefaultHyperlinkListener
implements HyperlinkListener {
    private static HyperlinkHandler defaultHandler = null;
    private HyperlinkHandler customHandler = null;
    private BaseEditor editor;

    public DefaultHyperlinkListener(BaseEditor editor) {
        this.editor = editor;
    }

    public static void setDefaultHyperlinkHandler(HyperlinkHandler defaultHandler) {
        DefaultHyperlinkListener.defaultHandler = defaultHandler;
    }

    public void setCustomHyperlinkHandler(HyperlinkHandler customHandler) {
        this.customHandler = customHandler;
    }

    private boolean checkHandler(HyperlinkHandler handler, HyperlinkEvent ev) {
        if (handler != null) {
            try {
                if (ev.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    return handler.processActivated(ev);
                }
                if (ev.getEventType() == HyperlinkEvent.EventType.ENTERED) {
                    return handler.processEntered(ev);
                }
                if (ev.getEventType() == HyperlinkEvent.EventType.EXITED) {
                    return handler.processExited(ev);
                }
            }
            catch (Exception e) {
                Logger.error(e);
            }
        }
        return false;
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent ev) {
        if (this.checkHandler(this.customHandler, ev)) {
            return;
        }
        if (this.checkHandler(defaultHandler, ev)) {
            return;
        }
        if (ev.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            URL url = ev.getURL();
            if (url != null) {
                this.editor.showDocument(url, "_blank");
            }
        } else if (ev.getEventType() == HyperlinkEvent.EventType.ENTERED) {
            boolean showDesc;
            String title = ev.getDescription();
            String desc = null;
            if (ev.getURL() != null) {
                desc = ev.getURL().toString();
            }
            if (title != null && title.equals(desc) || !this.editor.isShowLinkURL()) {
                desc = null;
            }
            StringBuilder text = new StringBuilder("<html><body>");
            boolean showTitle = title != null && title.length() > 0;
            boolean bl = showDesc = desc != null && desc.length() > 0;
            if (this.editor.isEditable()) {
                text.append(HtmlEditorUtils.getTranslation("openLinkToolTip"));
                text.append("<br>");
            }
            if (showTitle) {
                text.append(HtmlConverter.text2html(title, null));
            }
            if (showTitle && showDesc) {
                text.append("<br>");
            }
            if (showDesc) {
                text.append(HtmlConverter.text2html(desc, null));
            }
            text.append("</body></html>");
            this.editor.getEditor().setToolTipText(text.toString());
        } else if (ev.getEventType() == HyperlinkEvent.EventType.EXITED) {
            this.editor.getEditor().setToolTipText(null);
        }
    }
}

