/*
 * Decompiled with CFR 0.152.
 */
package com.inet.html.views.layouts;

import com.inet.html.css.StyleResolver;
import com.inet.html.finder.AttributeFinder;
import com.inet.html.parser.converter.LengthUnit;
import com.inet.html.parser.converter.ListPositionValue;
import com.inet.html.views.BlockView;
import com.inet.html.views.BoxView;
import com.inet.html.views.HtmlRootView;
import com.inet.html.views.ImageView;
import com.inet.html.views.RenderContext;
import com.inet.html.views.TableView;
import com.inet.html.views.ViewPositionInfo;
import com.inet.html.views.layouts.ILayouted;
import com.inet.html.views.layouts.Layout;
import com.inet.html.views.layouts.StackManager;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JEditorPane;
import javax.swing.JViewport;
import javax.swing.text.BadLocationException;
import javax.swing.text.Position;
import javax.swing.text.View;

public class BlockLayout
extends Layout {
    private Rectangle span = new Rectangle();

    public BlockLayout(BoxView view) {
        super(view);
        this.childPositions = new ArrayList(view.getViewCount());
    }

    @Override
    protected void calculateCollapsedMargins() {
        View parent = this.view.getParent();
        boolean collapseTop = this.view.getBottomInset() == 0;
        boolean collapseBottom = this.view.getBottomInset() == 0;
        Insets margins = ((BlockView)this.view).getMargins();
        if (parent != null && parent instanceof BoxView && !(parent instanceof HtmlRootView)) {
            Layout layout;
            BoxView boxParent = (BoxView)parent;
            if (parent instanceof ILayouted && (layout = ((ILayouted)((Object)parent)).getLayout()) instanceof BlockLayout) {
                if (boxParent.getTopInset() == 0 && this.getChild(boxParent, true) == this.view) {
                    collapseTop = false;
                    margins.top = 0;
                }
                if (boxParent.getBottomInset() == 0 && this.getChild(boxParent, false) == this.view) {
                    collapseBottom = false;
                    margins.bottom = 0;
                }
            }
        }
        if (collapseTop) {
            margins.top = this.getCollapsedMargin(true);
        }
        if (collapseBottom) {
            margins.bottom = this.getCollapsedMargin(false);
        }
    }

    private int getCollapsedMargin(boolean top) {
        BoxView currentView = this.view;
        Insets margins = null;
        int maxMargin = Integer.MIN_VALUE;
        int minMargin = Integer.MAX_VALUE;
        do {
            margins = ((BlockView)currentView).getOriginalMargins();
            maxMargin = Math.max(maxMargin, top ? margins.top : margins.bottom);
            minMargin = Math.min(minMargin, top ? margins.top : margins.bottom);
        } while (currentView.getTopInset() <= 0 && currentView.getBottomInset() <= 0 && (currentView = (BoxView)this.getChild(currentView, top)) != null && currentView instanceof BlockView && currentView.isBlock());
        return this.collapseMargin(maxMargin, minMargin);
    }

    private Point getReferencePoint() {
        return ((BlockView)this.view).getLeftUpperCorner(this.view);
    }

    @Override
    public Rectangle layout(boolean hard) {
        Dimension size;
        JEditorPane text;
        RenderContext rc;
        int viewportHeight;
        Dimension dim;
        int cssHeight = this.adjustHeight();
        if (cssHeight != Integer.MIN_VALUE) {
            this.setCurrentHeight(cssHeight);
        }
        if ((dim = this.applyMinMaxValue(true, this.width, 0)) != null) {
            this.width = dim.width;
        }
        int height = 0;
        int n = this.view.getViewCount();
        this.childPositions.clear();
        Layout.PositionInfo markerPos = null;
        StackManager posManager = ((BlockView)this.view).getPositionManager(false);
        Point reference = null;
        this.span.setBounds(0, 0, this.width, 0);
        Rectangle bounds = new Rectangle(0, 0, this.width, 0);
        Rectangle minRequired = new Rectangle();
        StackManager.LineSpaceInfo line = null;
        int prevMarginBottom = 0;
        for (int i = 0; i < n; ++i) {
            Rectangle childSpan;
            int marginJustify;
            ListPositionValue listPos;
            BoxView childView = (BoxView)this.view.getView(i);
            Layout.PositionInfo currentPos = new Layout.PositionInfo(childView);
            if (!childView.isInFlow() && (posManager = ((BlockView)this.view).getPositionManager(true)) != null) {
                if (childView.isFloating()) {
                    childView.performLayoutWidth();
                    childView.performLayout(hard);
                }
                posManager.addView(childView, 0, height + prevMarginBottom);
                posManager.notifyNewLine(height + prevMarginBottom);
                if (!((BlockView)this.view).isAtomicInlineLevelBox() || !childView.isFloating() && childView.getPosition() != 1) continue;
                if (reference == null) {
                    reference = this.getReferencePoint();
                }
                Point pos = posManager.getPositionInfo(childView);
                pos.x -= reference.x;
                pos.y -= reference.y;
                Rectangle childSpan2 = new Rectangle(pos.x, pos.y, childView.getOuterWidth(), childView.getOuterHeight());
                BlockLayout.union(this.span, childSpan2);
                continue;
            }
            childView.performLayoutWidth();
            this.childPositions.add(currentPos);
            if (childView.isMarker() && (listPos = StyleResolver.getAttributeValue(childView.getElement(), AttributeFinder.LIST_STYLE_POSITION)) != null && listPos.getType() == 0) {
                markerPos = currentPos;
                continue;
            }
            if (posManager != null && childView.getClear() != 0) {
                minRequired.width = Math.max(this.width - 2, 1);
                minRequired.height = 1;
                if (reference == null) {
                    reference = this.getReferencePoint();
                }
                bounds.y = height + reference.y;
                line = posManager.findLineSpace(minRequired, bounds, childView.getClear(), this.view.getJustification());
                height = line.getY() - reference.y;
            }
            Insets margin = childView.getMargins();
            height += i == 0 ? margin.top : this.collapseMargin(margin.top, prevMarginBottom);
            if (posManager != null && childView.getDisplay() == 8) {
                minRequired.width = childView.getOuterWidth();
                minRequired.height = 1;
                if (reference == null) {
                    reference = this.getReferencePoint();
                }
                bounds.y = height + reference.y;
                bounds.x = reference.x;
                line = posManager.findLineSpace(minRequired, bounds, childView.getClear(), this.view.getJustification());
                height = line.getY() - reference.y;
                int x = line.getX() - reference.x;
                margin = new Insets(margin.top, x + margin.left, margin.bottom, this.width - x - line.getMaxWidth() + margin.right);
            }
            currentPos.y = height;
            int localJustify = this.view.getJustification();
            if ((childView instanceof ImageView || childView instanceof TableView) && childView.getJustification() == 1) {
                localJustify = 1;
            }
            if ((marginJustify = childView.getAutoMarginJustify()) >= 0) {
                localJustify = marginJustify;
            }
            switch (localJustify) {
                case 2: {
                    currentPos.x = Math.max(this.width - childView.getOuterWidth() - margin.right, margin.left);
                    break;
                }
                case 1: {
                    currentPos.x = Math.max((this.width - childView.getOuterWidth()) / 2, margin.left);
                    break;
                }
                default: {
                    currentPos.x = margin.left;
                }
            }
            if (childView.getPosition() == 1) {
                BlockLayout.offsetRelative(currentPos);
            }
            if ((childSpan = childView.performLayout(hard)) != null && childView.getPosition() != 3) {
                Rectangle child = childSpan.getBounds();
                child.translate(currentPos.x, currentPos.y);
                BlockLayout.union(this.span, child);
            }
            if (childView.isBlock() && posManager == null) {
                posManager = ((BlockView)this.view).getPositionManager(false);
            }
            height += childView.getOuterHeight();
            prevMarginBottom = margin.bottom;
            if (markerPos != null) {
                markerPos.x = childView.isLTR() ? currentPos.x - markerPos.view.getOuterWidth() - MARKER_OFFSET : currentPos.x + currentPos.width + MARKER_OFFSET;
                markerPos.y = 0 + childView.getFirstLineBaseLine() - (int)markerPos.view.getPreferredSpan(2) + childView.getTopInset() + childView.getMargins().top;
                markerPos = null;
            }
            if (this.view.getFirstLineBaseLine() == 0) {
                this.view.setFirstLineBaseLine((short)(childView.getFirstLineBaseLine() + childView.getTopInset() + childView.getMargins().top));
            }
            if (childView.getPosition() != 1 || (posManager = ((BlockView)this.view).getPositionManager(true)) == null) continue;
            posManager.addView(childView, currentPos.x, currentPos.y);
            currentPos.paintInFlow = false;
        }
        int calculatedHeight = height + prevMarginBottom;
        if (this.view instanceof HtmlRootView && (viewportHeight = (rc = this.view.getRenderContext()).getViewportHeight()) > 0 && (text = rc.getTextContainer()) != null && text.getParent() instanceof JViewport) {
            calculatedHeight = Math.max(calculatedHeight, viewportHeight);
        }
        this.span.height = Math.max(this.span.height, calculatedHeight);
        this.setFinalHight(cssHeight, calculatedHeight, this.span);
        if (((BlockView)this.view).isAtomicInlineLevelBox()) {
            this.setCurrentWidth(this.span.width);
            this.setCurrentHeight(this.span.height);
        }
        if ((size = this.applyMinMaxValue(false, this.getCurrentWidth(), this.getCurrentHeight())) != null) {
            this.setCurrentWidth(size.width);
            this.setCurrentHeight(size.height);
        }
        return this.span;
    }

    @Override
    public Shape modelToView(int pos, Shape a, Position.Bias b) throws BadLocationException {
        Shape shape;
        Rectangle rect = a.getBounds();
        if (this.view.getVisibility() != 0) {
            throw new BadLocationException("Location is within a unvisible Element", pos);
        }
        int boxX = rect.x + this.view.getLeftInset();
        int boxY = rect.y + this.view.getTopInset() + this.view.getContentVerticalOffset();
        Shape returnValue = null;
        StackManager floatManager = ((BlockView)this.view).getPositionManager(false);
        if (floatManager != null && (shape = floatManager.modelToView(pos, a, b, 5)) != null) {
            return shape;
        }
        List<Layout.PositionInfo> children = this.getChildren();
        Layout.PositionInfo lastChild = children.size() > 0 ? children.get(children.size() - 1) : null;
        for (Layout.PositionInfo child : children) {
            boolean upperEndCondition;
            if (child.view.isMarker()) continue;
            int startOffset = child.view.getStartOffset();
            int endOffset = child.view.getEndOffset();
            if (b == Position.Bias.Forward && child != lastChild) {
                upperEndCondition = endOffset > pos;
            } else {
                boolean bl = upperEndCondition = endOffset >= pos;
            }
            if (startOffset >= endOffset || startOffset > pos || !upperEndCondition) continue;
            rect.x = child.x + boxX;
            rect.y = child.y + boxY;
            rect.width = child.view.getOuterWidth();
            rect.height = child.view.getOuterHeight();
            returnValue = child.view.modelToView(pos, rect, b);
            break;
        }
        if (floatManager != null && returnValue == null) {
            return floatManager.modelToView(pos, a, b, 0);
        }
        if (returnValue == null && children.size() > 0) {
            FontMetrics metrics = this.getFallbackFontMetrics();
            Layout.PositionInfo firstChild = children.get(0);
            int firstIndex = firstChild.view.getStartOffset();
            if (pos < firstIndex) {
                int hOffset = Math.max(firstChild.view.getFirstLineBaseLine(), metrics.getAscent());
                rect.x = firstChild.x + boxX - 1;
                rect.y = firstChild.y + boxY + firstChild.view.getFirstLineBaseLine() - hOffset;
                rect.width = 1;
                rect.height = metrics.getHeight();
                return rect.getBounds();
            }
            int lastIndex = lastChild.view.getEndOffset();
            if (pos >= lastIndex) {
                rect.x = lastChild.x + boxX + lastChild.view.getOuterWidth();
                rect.y = lastChild.y + boxY + lastChild.view.getOuterHeight() - metrics.getHeight();
                rect.width = 1;
                rect.height = metrics.getHeight();
                return rect.getBounds();
            }
        }
        return returnValue;
    }

    @Override
    public int viewToModel(float x, float y, Shape a, Position.Bias[] biasReturn) {
        Rectangle rect = a.getBounds();
        if (this.view.getVisibility() != 0) {
            return -1;
        }
        StackManager floatManager = ((BlockView)this.view).isPositionRoot() ? ((BlockView)this.view).getPositionManager(false) : null;
        int boxX = rect.x + this.view.getLeftInset();
        int boxY = rect.y + this.view.getTopInset() + this.view.getContentVerticalOffset();
        int returnValue = -1;
        if (floatManager != null && (returnValue = floatManager.viewToModel(x, y, a, biasReturn, 5)) >= 0) {
            return returnValue;
        }
        for (Layout.PositionInfo pos : this.getChildren()) {
            Rectangle span = pos.view.getSpan();
            rect.setBounds(pos.x + boxX + span.x, pos.y + boxY + span.y, span.width, span.height);
            if (!rect.contains(x, y)) continue;
            this.spanToView(rect, span);
            returnValue = pos.view.viewToModel(x, y, rect, biasReturn);
            break;
        }
        if (floatManager != null) {
            returnValue = floatManager.viewToModel(x, y, a, biasReturn, 0);
        }
        if (returnValue == -1) {
            Layout.PositionInfo prev = null;
            for (Layout.PositionInfo pos : this.getChildren()) {
                rect.width = pos.view.getOuterWidth();
                rect.setBounds(pos.x + boxX, pos.y + boxY, rect.width, pos.view.getOuterHeight());
                if ((float)rect.y <= y && (float)(rect.y + rect.height) >= y) {
                    return pos.view.viewToModel(x, y, rect, biasReturn);
                }
                if ((float)rect.y > y) {
                    if (prev != null) {
                        pos = prev;
                        rect.width = pos.view.getOuterWidth();
                        rect.setBounds(pos.x + boxX, pos.y + boxY, rect.width, pos.view.getOuterHeight());
                    }
                    return pos.view.viewToModel(x, y, rect, biasReturn);
                }
                prev = pos;
            }
            if (prev != null) {
                rect.setBounds(boxX, boxY, this.view.getOuterWidth(), this.view.getOuterHeight());
                return prev.view.viewToModel(x, y, rect, biasReturn);
            }
        }
        return returnValue;
    }

    private int collapseMargin(int margin1, int margin2) {
        if (margin1 < 0 && margin2 < 0) {
            return Math.min(margin1, margin2);
        }
        if (margin1 < 0) {
            return margin2 + margin1;
        }
        if (margin2 < 0) {
            return margin1 + margin2;
        }
        return Math.max(margin1, margin2);
    }

    @Override
    public void preLayout() {
        int n = this.view.getViewCount();
        this.preferredWidth = 0;
        this.setPreferredHeight(0);
        this.minimumWidth = 0;
        this.minimumHeight = 0;
        this.currentWidth = 0;
        this.currentHeight = 0;
        this.width = 0;
        LengthUnit l = this.view.getWidthUnit();
        if (l != null && !l.isAuto() && l.isAbsolute()) {
            this.preferredWidth = Math.round(l.calculateValue(1.0f, this.view));
        }
        int prevMarginBottom = 0;
        for (int i = 0; i < n; ++i) {
            int minWidth;
            int prefWidth;
            Insets margin;
            View v = this.view.getView(i);
            Insets insets = margin = v instanceof BoxView ? ((BoxView)v).getMargins() : new Insets(0, 0, 0, 0);
            if (i == 0) {
                this.setPreferredHeight(this.getPreferredHeight() + margin.top);
            }
            if (v instanceof BoxView) {
                BoxView bv = (BoxView)v;
                int widthGain = bv.getBox().getTotalWidthGain();
                if (v instanceof ILayouted) {
                    Layout layout = ((ILayouted)((Object)bv)).getLayout();
                    prefWidth = layout.getPreferredWidth() + widthGain;
                    minWidth = layout.getMinimumWidth() + widthGain;
                } else {
                    prefWidth = (int)v.getPreferredSpan(0) + widthGain;
                    minWidth = (int)v.getMinimumSpan(0) + widthGain;
                }
            } else {
                prefWidth = (int)v.getPreferredSpan(0);
                minWidth = (int)v.getMinimumSpan(0);
            }
            this.minimumWidth = Math.max(this.minimumWidth, minWidth);
            this.preferredWidth = Math.max(this.preferredWidth, prefWidth);
            if (this.view.isTableCell() && this.preferredWidth < this.minimumWidth) {
                this.preferredWidth = this.minimumWidth;
            }
            if (this.view.isInFlow()) {
                this.setPreferredHeight(this.getPreferredHeight() - this.collapseMargin(margin.top, prevMarginBottom));
            }
            this.setPreferredHeight(this.getPreferredHeight() + (int)v.getPreferredSpan(1));
            prevMarginBottom = margin.bottom;
        }
        this.setPreferredHeight(this.getPreferredHeight() + prevMarginBottom);
        this.minimumHeight = this.getPreferredHeight();
        this.setPreLayouted();
    }

    @Override
    public void predictWidth(int width) {
        this.width = width;
        this.currentWidth = width;
    }

    @Override
    public void layoutVerticalAlign(int align, int baselineOffset) {
        int availableHight = this.view.getContentHeight();
        int diff = availableHight - this.currentHeight;
        this.currentHeight = this.view.getContentHeight();
        if (diff > 0) {
            switch (align) {
                case 8: {
                    this.view.setContentVerticalOffset(diff);
                    break;
                }
                case 2: {
                    this.view.setContentVerticalOffset(diff / 2);
                    break;
                }
                case 7: {
                    this.view.setContentVerticalOffset(0);
                    break;
                }
            }
        } else {
            this.view.setContentVerticalOffset(0);
        }
    }

    @Override
    public ViewPositionInfo getViewForPosition(Point position, Rectangle a) {
        StackManager floatManager;
        Rectangle rect = a.getBounds();
        if (this.view.getVisibility() != 0) {
            return null;
        }
        int boxX = rect.x + this.view.getLeftInset();
        int boxY = rect.y + this.view.getTopInset() + this.view.getContentVerticalOffset();
        ViewPositionInfo returnValue = null;
        StackManager stackManager = floatManager = ((BlockView)this.view).isPositionRoot() ? ((BlockView)this.view).getPositionManager(false) : null;
        if (floatManager != null && (returnValue = floatManager.getViewForPosition(position, a, 5)) != null) {
            return returnValue;
        }
        List<Layout.PositionInfo> children = this.getChildren();
        ViewPositionInfo fallback = null;
        for (int i = children.size() - 1; i >= 0; --i) {
            Layout.PositionInfo pos = children.get(i);
            Rectangle childSpan = pos.view.getSpan();
            rect.setBounds(childSpan.x + boxX + pos.x, childSpan.y + boxY + pos.y, childSpan.width, childSpan.height);
            if (!rect.contains(position)) continue;
            this.spanToView(rect, childSpan);
            returnValue = pos.view.getViewForPosition(position, rect);
            if (returnValue == null) {
                fallback = new ViewPositionInfo(rect, pos.view, pos.view.getViewCount() != 0);
                continue;
            }
            if (returnValue.isFallback()) {
                fallback = returnValue;
                continue;
            }
            return returnValue;
        }
        if (fallback != null) {
            return fallback;
        }
        if (floatManager != null && (returnValue = floatManager.getViewForPosition(position, a, 0)) != null) {
            return returnValue;
        }
        return null;
    }

    private void spanToView(Rectangle viewRect, Rectangle viewSpan) {
        if (viewSpan.x != 0) {
            viewRect.x -= viewSpan.x;
            viewRect.width += viewSpan.x;
        }
        if (viewSpan.y != 0) {
            viewRect.y -= viewSpan.y;
            viewRect.height += viewSpan.y;
        }
    }

    @Override
    public Rectangle getSpan() {
        return this.span;
    }
}

