/*
 * Decompiled with CFR 0.152.
 */
package com.inet.html.views;

import com.inet.html.InetHtmlDocument;
import com.inet.html.ViewPainter;
import com.inet.html.css.CSS;
import com.inet.html.css.HTML;
import com.inet.html.css.StyleResolver;
import com.inet.html.event.AttributeUndoableEdit;
import com.inet.html.finder.AttributeFinder;
import com.inet.html.image.AnimationObserver;
import com.inet.html.image.ImageCache;
import com.inet.html.image.RemoteImage;
import com.inet.html.parser.URLResolver;
import com.inet.html.parser.converter.FloatValue;
import com.inet.html.parser.converter.IntegerValue;
import com.inet.html.parser.converter.LengthUnit;
import com.inet.html.parser.converter.UriValue;
import com.inet.html.parser.converter.UrlValue;
import com.inet.html.utils.ColorUtils;
import com.inet.html.utils.DOMUtils;
import com.inet.html.utils.DocumentImage;
import com.inet.html.utils.Logger;
import com.inet.html.views.BoxPainter;
import com.inet.html.views.BoxView;
import com.inet.html.views.IBoxPainter;
import com.inet.html.views.MinMaxControl;
import com.inet.html.views.layouts.ILayouted;
import com.inet.html.views.layouts.Layout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.lang.ref.SoftReference;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.Icon;
import javax.swing.JEditorPane;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.LayeredHighlighter;
import javax.swing.text.Position;
import javax.swing.text.StyleConstants;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.undo.UndoableEdit;

public class ImageView
extends BoxView {
    private static final int DEFAULT_SIZE = 32;
    private Image image;
    private SoftReference<Image> scaledImage;
    private Dimension scaledImageSize = null;
    private RemoteImage fetcher;
    private Rectangle lastPaint = new Rectangle();
    private boolean loadComplete = false;
    private final AnimationObserver imageObserver;
    private UriValue predictSource;
    private Dimension imageSize = new Dimension(32, 32);
    private Dimension calculatedSize = null;
    private Dimension displaySize = null;
    private static Icon pendingImage;
    private static Icon missingImage;
    private BoxView listItemFallback;
    private boolean listItemFallBackActive;
    private URL url;
    private static Font ALT_TEXT_FONT;
    private Rectangle gifDeltaBounds = null;
    private MinMaxControl minMaxControl;
    private MinMaxControl sizeLimitControl;
    private boolean showZoomIcon = false;

    public ImageView(Element elem) {
        super(elem);
        this.imageObserver = new ImageHandler(elem.getDocument().getProperty(InetHtmlDocument.PROPERTY_MEDIA) != "print");
    }

    public ImageView(Element elem, ViewPainter painter) {
        super(elem, painter);
        this.imageObserver = new ImageHandler(elem.getDocument().getProperty(InetHtmlDocument.PROPERTY_MEDIA) != "print");
    }

    @Override
    public int getContentWidth() {
        if (this.listItemFallback != null && this.listItemFallBackActive) {
            return this.listItemFallback.getContentWidth();
        }
        int contentWidth = super.getContentWidth();
        if (contentWidth <= 0) {
            return 32;
        }
        return contentWidth;
    }

    @Override
    public int getContentHeight() {
        if (this.listItemFallback != null && this.listItemFallBackActive) {
            return this.listItemFallback.getContentHeight();
        }
        int contentHeight = super.getContentHeight();
        if (contentHeight <= 0) {
            return 32;
        }
        return contentHeight;
    }

    @Override
    public int getOuterHeight() {
        if (this.listItemFallback != null && this.listItemFallBackActive) {
            return this.listItemFallback.getOuterHeight();
        }
        int contentHeight = super.getOuterHeight();
        if (contentHeight <= 0) {
            return 32 + this.getTopInset() + this.getBottomInset();
        }
        return contentHeight;
    }

    @Override
    public int getOuterWidth() {
        if (this.listItemFallback != null && this.listItemFallBackActive) {
            return this.listItemFallback.getOuterWidth();
        }
        int contentWidth = super.getOuterWidth();
        if (contentWidth <= 0) {
            return 32 + this.getLeftInset() + this.getRightInset();
        }
        return contentWidth;
    }

    @Override
    public float getPreferredSpan(int axis) {
        if (this.listItemFallback != null && this.listItemFallBackActive) {
            return this.listItemFallback.getPreferredSpan(axis);
        }
        if (axis == 0) {
            return this.getContentWidth() + this.getLeftInset() + this.getRightInset();
        }
        if (axis == 2) {
            if (this.listItemFallback != null && this.listItemFallBackActive) {
                return this.listItemFallback.getPreferredSpan(2) + (float)this.getTopInset();
            }
            switch ((int)this.getAlignment(1)) {
                case 5: 
                case 7: {
                    return 0.0f;
                }
                case 2: {
                    return this.getOuterHeight() / 2;
                }
            }
            return this.getOuterHeight();
        }
        return this.getContentHeight() + this.getTopInset() + this.getBottomInset();
    }

    @Override
    public int getResizeWeight(int axis) {
        return 0;
    }

    @Override
    protected IBoxPainter createBoxPainter() {
        return BoxPainter.createRootPainter(this);
    }

    @Override
    public Shape modelToView(int pos, Shape a, Position.Bias b) throws BadLocationException {
        int p0 = this.getStartOffset();
        int p1 = this.getEndOffset();
        if (pos >= p0 && pos <= p1) {
            Rectangle r = a.getBounds();
            if (pos == p1) {
                r.x += r.width;
            }
            r.width = 0;
            return r;
        }
        return null;
    }

    @Override
    public int viewToModel(float x, float y, Shape a, Position.Bias[] biasReturn) {
        Rectangle alloc = (Rectangle)a;
        if (x < (float)(alloc.x + alloc.width)) {
            biasReturn[0] = Position.Bias.Forward;
            return this.getStartOffset();
        }
        biasReturn[0] = Position.Bias.Backward;
        return this.getEndOffset();
    }

    @Override
    public void paint(Graphics g, Shape allocation) {
        JTextComponent textComp;
        Highlighter highlighter;
        if (this.getVisibility() != 0) {
            return;
        }
        Rectangle clip = g.getClipBounds();
        Rectangle rect = (Rectangle)allocation;
        if (clip != null && !clip.intersects(rect)) {
            return;
        }
        if (this.isCanceledByPainter(g, allocation)) {
            return;
        }
        Rectangle restoreClip = null;
        if (this.gifDeltaBounds != null && (this.gifDeltaBounds.x != 0 || this.gifDeltaBounds.y != 0 || this.gifDeltaBounds.width != this.getContentWidth() || this.gifDeltaBounds.height != this.getContentHeight())) {
            restoreClip = ((Graphics2D)g).getClipBounds();
            ((Graphics2D)g).setClip(rect.x + this.getLeftInset() + this.gifDeltaBounds.x, rect.y + this.getTopInset() + this.gifDeltaBounds.y, this.gifDeltaBounds.width, this.gifDeltaBounds.height);
        }
        this.getBox().paint(g, rect, 0, this);
        this.lastPaint.setBounds(rect);
        Container container = this.getContainer();
        boolean isHighlight = false;
        if (container instanceof JTextComponent && !this.isMarker() && (highlighter = (textComp = (JTextComponent)container).getHighlighter()) instanceof LayeredHighlighter) {
            int start = this.getStartOffset();
            int end = this.getEndOffset();
            ((LayeredHighlighter)highlighter).paintLayeredHighlights(g, start, end, allocation, textComp, this);
            for (Highlighter.Highlight h : highlighter.getHighlights()) {
                if (h.getEndOffset() <= start || h.getStartOffset() >= end) continue;
                isHighlight = true;
            }
        }
        boolean drawImage = false;
        Image currentImage = this.getImage();
        try {
            drawImage = currentImage != null && currentImage.getWidth(this.imageObserver) > 0 && currentImage.getHeight(this.imageObserver) > 0 && this.isLoadComplete();
        }
        catch (SecurityException start) {
            // empty catch block
        }
        if (drawImage) {
            if (this.gifDeltaBounds == null) {
                this.drawImage(currentImage, g, rect.x + this.getLeftInset(), rect.y + this.getTopInset(), this.getContentWidth(), this.getContentHeight(), this.imageObserver);
            } else {
                g.drawImage(currentImage, rect.x + this.getLeftInset() + this.gifDeltaBounds.x, rect.y + this.getTopInset() + this.gifDeltaBounds.y, this.gifDeltaBounds.width, this.gifDeltaBounds.height, this.imageObserver);
            }
            if (this.showZoomIcon) {
                g.setColor(this.sizeLimitControl != null ? Color.RED : Color.GREEN);
                g.fillRect(rect.x + this.getLeftInset(), rect.y + this.getTopInset(), 20, 20);
            }
        } else {
            if (this.listItemFallback != null && this.listItemFallBackActive) {
                this.listItemFallback.paint(g, allocation);
                return;
            }
            Icon missing = currentImage == null ? ImageView.getMissingImage() : ImageView.getPendingImage();
            int y1 = rect.y + this.getTopInset();
            int x1 = rect.x + this.getLeftInset();
            int x2 = x1 + this.getContentWidth();
            int y2 = y1 + this.getContentHeight();
            String altText = this.getAltText();
            if (missing != null || altText != null && !altText.isEmpty()) {
                Shape origClip = g.getClip();
                if (origClip != null) {
                    g.setClip(new Rectangle(x1, y1, x2 - x1, y2 - y1).intersection(origClip.getBounds()));
                }
                int imageOffset = 0;
                if (missing != null) {
                    imageOffset += missing.getIconWidth();
                    missing.paintIcon(this.getContainer(), g, rect.x + this.getLeftInset(), rect.y + this.getTopInset());
                }
                if (altText != null && !altText.isEmpty()) {
                    g.setFont(ALT_TEXT_FONT);
                    FontMetrics metrics = g.getFontMetrics();
                    if (isHighlight && this.getRenderContext().getTextContainer() != null) {
                        g.setColor(this.getRenderContext().getTextContainer().getSelectedTextColor());
                    } else {
                        g.setColor(AttributeFinder.COLOR.getAttributeValue(this).getValue());
                    }
                    g.drawString(altText, x1 + imageOffset, y1 + metrics.getHeight());
                }
                g.setClip(origClip);
            }
            g.setColor(ColorUtils.get3DDark());
            g.drawLine(x1, y1, x2, y1);
            g.drawLine(x1, y1, x1, y2);
            g.setColor(ColorUtils.get3DLight());
            g.drawLine(x1, y2, x2, y2);
            g.drawLine(x2, y1, x2, y2);
        }
        if (isHighlight) {
            JTextComponent textComp2 = (JTextComponent)container;
            Color c = textComp2.getSelectionColor();
            Color cTransparent = new Color(c.getRed(), c.getGreen(), c.getBlue(), 128);
            g.setColor(cTransparent);
            g.fillRect(rect.x + this.getLeftInset(), rect.y + this.getTopInset(), this.getContentWidth(), this.getContentHeight());
        }
        if (restoreClip != null) {
            ((Graphics2D)g).setClip(restoreClip);
        }
    }

    private void drawImage(Image image, Graphics g, int x, int y, int width, int height, ImageObserver obs) {
        Image scaledInstance;
        int endW = image.getWidth(obs);
        int endH = image.getHeight(obs);
        if (!this.isLoadComplete() || width >= image.getWidth(obs) / 2 && height >= image.getHeight(obs) / 2 || this.getRenderContext().isBlockOnImageLoad()) {
            Graphics2D sourceGraphics = (Graphics2D)g;
            Object prevHint = sourceGraphics.getRenderingHint(RenderingHints.KEY_INTERPOLATION);
            boolean hintSet = false;
            if ((width != endW || height != endH) && prevHint != RenderingHints.VALUE_INTERPOLATION_BICUBIC && prevHint != RenderingHints.VALUE_INTERPOLATION_BILINEAR) {
                sourceGraphics.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                hintSet = true;
            }
            g.drawImage(image, x, y, width, height, obs);
            if (prevHint != null && hintSet) {
                sourceGraphics.setRenderingHint(RenderingHints.KEY_INTERPOLATION, prevHint);
            }
            return;
        }
        if (this.scaledImageSize != null && this.scaledImageSize.width == width && this.scaledImageSize.height == height && (scaledInstance = this.scaledImage.get()) != null) {
            g.drawImage(scaledInstance, x, y, obs);
            return;
        }
        ArrayList<Dimension> steps = new ArrayList<Dimension>();
        int w = width;
        int h = height;
        while (w < endW || h < endH) {
            steps.add(new Dimension(w, h));
            w = Math.min(w * 2, endW);
            h = Math.min(h * 2, endH);
        }
        Collections.reverse(steps);
        for (Dimension d : steps) {
            BufferedImage newImage = new BufferedImage(d.width, d.height, 6);
            Graphics2D g2 = (Graphics2D)newImage.getGraphics();
            g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            g2.drawImage(image, 0, 0, d.width, d.height, null);
            image = newImage;
        }
        this.scaledImage = new SoftReference<Image>(image);
        this.scaledImageSize = new Dimension(width, height);
        g.drawImage(image, x, y, obs);
    }

    public boolean isLoadComplete() {
        return this.loadComplete;
    }

    @Override
    protected void setPropertiesFromAttributes(boolean inline) {
        if (this.getParent() == null) {
            return;
        }
        super.setPropertiesFromAttributes(false);
        this.loadImage();
        IntegerValue vspace = StyleResolver.getAttributeValue(this.getElement(), AttributeFinder.VSPACE);
        IntegerValue hspace = StyleResolver.getAttributeValue(this.getElement(), AttributeFinder.HSPACE);
        if (vspace != null) {
            LengthUnit mBottom;
            LengthUnit mTop = StyleResolver.getAttributeValue(this.getElement(), AttributeFinder.MARGIN_TOP);
            if (mTop == null || mTop.getValue() == 0.0f) {
                this.getBox().setMargins().top = vspace.getInt();
            }
            if ((mBottom = StyleResolver.getAttributeValue(this.getElement(), AttributeFinder.MARGIN_BOTTOM)) == null || mBottom.getValue() == 0.0f) {
                this.getBox().setMargins().bottom = vspace.getInt();
            }
        }
        if (hspace != null) {
            LengthUnit mRight;
            LengthUnit mLeft = StyleResolver.getAttributeValue(this.getElement(), AttributeFinder.MARGIN_LEFT);
            if (mLeft == null || mLeft.getValue() == 0.0f) {
                this.getBox().setMargins().left = hspace.getInt();
            }
            if ((mRight = StyleResolver.getAttributeValue(this.getElement(), AttributeFinder.MARGIN_RIGHT)) == null || mRight.getValue() == 0.0f) {
                this.getBox().setMargins().right = hspace.getInt();
            }
        }
        this.performLayoutWidth();
        FloatValue floatValue = StyleResolver.getAttributeValue(this.getElement(), AttributeFinder.FLOAT_ALIGN);
        if (floatValue != null && floatValue.getFloat() == 1) {
            this.setJustification((byte)1);
        }
        this.minMaxControl = new MinMaxControl(this);
        if (!this.minMaxControl.hasWHConstraint()) {
            this.minMaxControl = null;
        }
    }

    private void loadImage() {
        DocumentImage documentImage;
        if (this.getImage() != null) {
            return;
        }
        URLResolver imageSrc = this.getImageSrc();
        if (this.getAttributes().isDefined(StyleConstants.IconAttribute) && (documentImage = (DocumentImage)this.getAttributes().getAttribute(StyleConstants.IconAttribute)) != null && documentImage.getImageData() != null) {
            Image cachedImg = documentImage.getImageData().getImage();
            if (!ImageCache.isCacheReference(documentImage.getUrl())) {
                if (documentImage.getUrl() != null) {
                    if (cachedImg != null) {
                        documentImage.removeChachedImage();
                        ImageCache.getStaticInstance().addImage(documentImage.getUrl(), imageSrc.getBaseURL(), cachedImg);
                        this.setImage(cachedImg);
                        return;
                    }
                } else {
                    if (cachedImg != null) {
                        String id = ImageCache.getStaticInstance().registerImage(cachedImg);
                        documentImage.setURL(id);
                        this.setImage(cachedImg);
                        return;
                    }
                    if (Logger.doesLog(2)) {
                        Logger.warning("Image load failed: empty document image.");
                    }
                }
            } else {
                if (cachedImg != null) {
                    this.setImage(cachedImg);
                    return;
                }
                imageSrc = new URLResolver(documentImage.getUrl());
            }
        }
        if (imageSrc != null) {
            InetHtmlDocument.TimeoutProvider timeout = null;
            if (this.getDocument() instanceof InetHtmlDocument) {
                timeout = ((InetHtmlDocument)this.getDocument()).getTimeoutProvider();
            }
            this.fetcher = ImageCache.getStaticInstance().getImage(imageSrc, timeout, !this.getRenderContext().isBlockOnImageLoad(), this.imageObserver);
            if (this.fetcher != null && this.fetcher.getStatus() <= 1) {
                this.getRenderContext().notifyImageLoad(this.fetcher);
            }
        } else {
            this.setImage(null);
        }
    }

    protected URLResolver getImageSrc() {
        if (this.predictSource != null) {
            return this.predictSource.getResolver();
        }
        UrlValue link = StyleResolver.getAttributeValue(this.getElement(), AttributeFinder.SRC);
        if (link != null) {
            return link.getResolver();
        }
        return null;
    }

    private String getAltText() {
        if (this.getAttributes().isDefined((Object)HTML.Attribute.ALT)) {
            return this.getAttributes().getAttribute((Object)HTML.Attribute.ALT).toString();
        }
        URLResolver source = this.getImageSrc();
        return source != null ? source.getOriginalURI() : null;
    }

    void repaint(boolean sizeChange) {
        if (sizeChange) {
            this.setStatus(2);
            this.performLayoutWidth();
            this.forceLayout(500L);
        } else {
            if (this.lastPaint == null) {
                return;
            }
            Container container = this.getContainer();
            if (container != null) {
                container.repaint(this.lastPaint.x, this.lastPaint.y, this.lastPaint.width, this.lastPaint.height);
            }
        }
    }

    public Image getImage() {
        return this.image;
    }

    private synchronized void setImage(Image img) {
        this.image = img;
        boolean bl = this.loadComplete = img != null;
        if (img == null) {
            if (this.listItemFallback == null) {
                if (this.getWidthUnit() != null && !this.getWidthUnit().isAuto()) {
                    return;
                }
                String altText = this.getAltText();
                if (altText != null && !altText.isEmpty()) {
                    FontMetrics metrics = this.getFontMetrics();
                    int newWidth = metrics.stringWidth(altText);
                    int additional = ImageView.getMissingImage() != null ? ImageView.getMissingImage().getIconWidth() : 0;
                    int newContentWidth = Math.max(32, newWidth + additional + 1);
                    this.setContentWidth(newContentWidth);
                    this.imageSize.width = newContentWidth;
                    if (newContentWidth != 32) {
                        this.repaint(true);
                    }
                }
            }
        } else {
            this.listItemFallBackActive = false;
            this.listItemFallback = null;
            try {
                this.imageSize = new Dimension(img.getWidth(this.imageObserver), img.getHeight(this.imageObserver));
            }
            catch (SecurityException e) {
                if (Logger.doesLog(1)) {
                    Logger.error("Unable to display image '" + this.getImageSrc() + "' due to security restrictions");
                }
                this.setImage(null);
            }
        }
    }

    private FontMetrics getFontMetrics() {
        JEditorPane c = this.getRenderContext().getTextContainer();
        return c != null ? ((Component)c).getFontMetrics(ALT_TEXT_FONT) : Toolkit.getDefaultToolkit().getFontMetrics(ALT_TEXT_FONT);
    }

    @Override
    public void performPreLayout() {
        this.setStatusLocal(1);
        this.setStatus(1);
    }

    @Override
    public Rectangle performLayout(boolean hard) {
        this.setStatusLocal(0);
        this.displaySize = new Dimension(this.calculatedSize != null ? this.calculatedSize : this.imageSize);
        if (this.minMaxControl != null && ((ILayouted)((Object)this.getParent())).getLayout().isPreLayouted()) {
            this.displaySize = this.minMaxControl.getMinMaxValues(false, this.displaySize.width, this.displaySize.height);
        }
        if (this.sizeLimitControl != null && ((ILayouted)((Object)this.getParent())).getLayout().isPreLayouted()) {
            this.displaySize = this.sizeLimitControl.getMinMaxValues(false, this.displaySize.width, this.displaySize.height);
        }
        this.setFirstLineBaseLine((short)this.displaySize.height);
        this.setSizeContent(this.displaySize.width, this.displaySize.height);
        return new Rectangle(this.displaySize);
    }

    @Override
    public void performLayoutWidth() {
        Dimension size;
        if (this.getParent() == null) {
            return;
        }
        if (this.listItemFallback != null && this.listItemFallBackActive) {
            this.setSizeContent((int)this.listItemFallback.getPreferredSpan(0), (int)this.listItemFallback.getPreferredSpan(1));
            return;
        }
        this.calculatedSize = new Dimension(this.imageSize);
        ILayouted parent = (ILayouted)((Object)this.getParent());
        if (parent == null) {
            return;
        }
        Layout layout = parent.getLayout();
        boolean widthSet = false;
        boolean heightSet = false;
        if (this.getWidthUnit() != null && !this.getWidthUnit().isAuto() && layout != null) {
            this.calculatedSize.width = (int)this.getWidthUnit().calculateValue(layout.getCurrentWidth(), this);
            widthSet = true;
        }
        if (this.getHeightUnit() != null && !this.getHeightUnit().isAuto() && layout != null) {
            this.calculatedSize.height = (int)this.getHeightUnit().calculateValue(layout.getCurrentHeight(), this);
            heightSet = true;
        }
        if (widthSet && !heightSet && this.imageSize.width > 0 && this.calculatedSize.width > 0) {
            this.calculatedSize.height = this.calculatedSize.width * this.calculatedSize.height / this.imageSize.width;
        }
        if (heightSet && !widthSet && this.imageSize.height > 0 && this.calculatedSize.height > 0) {
            this.calculatedSize.width = this.calculatedSize.width * this.calculatedSize.height / this.imageSize.height;
        }
        this.displaySize = new Dimension(this.calculatedSize.width < 0 ? 32 : this.calculatedSize.width, this.calculatedSize.height < 0 ? 32 : this.calculatedSize.height);
        if (this.minMaxControl != null && ((ILayouted)((Object)this.getParent())).getLayout().isPreLayouted()) {
            size = this.minMaxControl.getMinMaxValues(true, this.displaySize.width, this.displaySize.height);
            this.displaySize.width = size.width;
        }
        if (this.sizeLimitControl != null && ((ILayouted)((Object)this.getParent())).getLayout().isPreLayouted()) {
            size = this.sizeLimitControl.getMinMaxValues(true, this.displaySize.width, this.displaySize.height);
            this.displaySize.width = size.width;
        }
        this.setFirstLineBaseLine((short)this.displaySize.height);
        this.setSizeContent(this.displaySize.width, this.displaySize.height);
    }

    public String toString() {
        return "IMG: " + this.getImageSrc();
    }

    private static Icon getMissingImage() {
        if (missingImage == null) {
            try {
                missingImage = (Icon)UIManager.getLookAndFeelDefaults().get("html.missingImage");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return missingImage;
    }

    private static Icon getPendingImage() {
        if (pendingImage == null) {
            try {
                pendingImage = (Icon)UIManager.getLookAndFeelDefaults().get("html.pendingImage");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return pendingImage;
    }

    @Override
    public void performLayoutVAlign(int baseline) {
        int diff;
        if (this.listItemFallback != null && this.listItemFallBackActive) {
            return;
        }
        int availableHight = this.getContentHeight();
        Image currentImage = this.getImage();
        int imgHeight = 32;
        if (currentImage != null) {
            try {
                imgHeight = currentImage.getHeight(this.imageObserver);
            }
            catch (SecurityException e) {
                if (Logger.doesLog(1)) {
                    Logger.error("Unable to display image '" + this.getImageSrc() + "' due to security restrictions");
                }
                this.setImage(null);
            }
        }
        if ((diff = availableHight - imgHeight) > 0) {
            switch ((int)this.getAlignment(1)) {
                case 8: {
                    this.setContentVerticalOffset(diff);
                    break;
                }
                case 2: {
                    this.setContentVerticalOffset(diff / 2);
                    break;
                }
                case 7: {
                    this.setContentVerticalOffset(0);
                    break;
                }
            }
        } else {
            this.setContentVerticalOffset(0);
        }
    }

    public void predictSource(UriValue newSource) {
        this.predictSource = newSource;
    }

    public void setListItemFallback(BoxView view) {
        this.listItemFallback = view;
    }

    public URL getUrl() {
        return this.url;
    }

    @Override
    public void setParent(View parent) {
        super.setParent(parent);
        if (parent == null && this.fetcher != null) {
            this.fetcher.removeObserver(this.imageObserver);
        }
        if (parent != null && this.listItemFallback != null && this.image == null) {
            this.listItemFallback.setParent(this);
            this.listItemFallBackActive = true;
        }
    }

    public void setAutoScaleMode(boolean active) {
        this.sizeLimitControl = active ? new MinMaxControl(this, new LengthUnit("100%"), null) : null;
        if (this.getParent() != null) {
            this.repaint(true);
        }
    }

    public boolean isAutoScaleMode() {
        return this.sizeLimitControl != null;
    }

    public void setZoomIconVisible(boolean show) {
        this.showZoomIcon = show;
        this.repaint(false);
    }

    @Override
    public void changedUpdate(DocumentEvent e, Shape a, ViewFactory f) {
        if (e instanceof InetHtmlDocument.ExtendedDocuementEvent) {
            InetHtmlDocument.ExtendedDocuementEvent ee = (InetHtmlDocument.ExtendedDocuementEvent)e;
            if (ee.getStructureChangeStart() > this.getEndOffset() || ee.getStructureChangeStart() + ee.getStructureChangeLen() < this.getStartOffset()) {
                return;
            }
            ArrayList<UndoableEdit> changes = ee.getAllChanges();
            for (UndoableEdit change : changes) {
                if (!(change instanceof AttributeUndoableEdit) || ((AttributeUndoableEdit)change).getElement() != this.getElement()) continue;
                int prevDisplay = this.getDisplay();
                boolean floating = this.getFloat() != 0;
                this.setPropertiesFromAttributes(false);
                this.setStatus(2);
                if (this.getDisplay() == prevDisplay && this.getFloat() != 0 == floating) continue;
                View parent = this.getParent();
                View parentParent = parent.getParent();
                parent.setParent(null);
                parent.setParent(parentParent);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean getVisibleDOM(Rectangle2D clip, DOMUtils.ResultMap result) {
        if (this.getPainter() != null && this.getPainter().wasPainted()) {
            return false;
        }
        int h = this.getOuterHeight();
        boolean partial = false;
        if (clip.getHeight() < 0.0 || clip.getMinY() > (double)h || clip.getMaxY() < (double)h) {
            if (!Boolean.TRUE.equals(result.getProperty(DOMUtils.ClippingProperty.FirstLineRendered))) {
                partial = true;
                result.setLastVisibleContentLocation(-clip.getY() + clip.getHeight());
                result.setFirstClippedContentLocation(-clip.getY() + clip.getHeight());
            } else {
                if (result.isSet(DOMUtils.ClippingProperty.WholeContentOnly)) {
                    result.setFirstClippedContentLocation(-clip.getY());
                    return false;
                }
                partial = true;
                result.setLastVisibleContentLocation(-clip.getY() + clip.getHeight());
                result.setFirstClippedContentLocation(-clip.getY());
            }
        } else {
            result.setLastVisibleContentLocation(-clip.getY() + (double)h);
        }
        DOMUtils.DOMVisibilityResult visResult = new DOMUtils.DOMVisibilityResult(this, partial ? DOMUtils.Visibility.visible_paged : DOMUtils.Visibility.visible);
        result.put(this.getElement(), visResult);
        if (this.sizeLimitControl != null && (this.displaySize.width != this.calculatedSize.width || this.displaySize.height != this.calculatedSize.height)) {
            visResult.setAttribute((Object)CSS.Attribute.WIDTH, new LengthUnit(this.displaySize.width));
            visResult.setAttribute((Object)CSS.Attribute.HEIGHT, new LengthUnit(this.displaySize.height));
            visResult.setAttribute((Object)HTML.Attribute.HEIGHT, null);
            visResult.setAttribute((Object)HTML.Attribute.WIDTH, null);
        }
        if (this.listItemFallback == null || !this.listItemFallBackActive) {
            visResult.setAttribute((Object)HTML.Attribute.ALT, this.getAltText());
        }
        return true;
    }

    static {
        ALT_TEXT_FONT = new Font("Sans Serif", 0, 10);
    }

    private class ImageHandler
    implements AnimationObserver {
        private final boolean doAnimate;

        public ImageHandler(boolean doAnimate) {
            this.doAnimate = doAnimate;
        }

        @Override
        public boolean imageUpdate(Image img, int flags, int x, int y, int newWidth, int newHeight) {
            boolean sizeChange;
            boolean hasHeight;
            Image currentImg = ImageView.this.getImage();
            boolean hasWidth = (flags & 1) != 0;
            boolean bl = hasHeight = (flags & 2) != 0;
            if (img != null && currentImg != img && (flags & 0xC0) == 0) {
                Dimension before = ImageView.this.imageSize;
                ImageView.this.setImage(img);
                if (!before.equals(ImageView.this.imageSize)) {
                    ImageView.this.repaint(true);
                }
            }
            if (ImageView.this.getParent() == null) {
                return false;
            }
            boolean bl2 = sizeChange = hasWidth && newWidth != ((ImageView)ImageView.this).imageSize.width || hasHeight && newHeight != ((ImageView)ImageView.this).imageSize.height;
            if ((hasWidth || hasHeight) && sizeChange) {
                ImageView.this.imageSize = new Dimension(hasWidth ? newWidth : ((ImageView)ImageView.this).imageSize.width, hasHeight ? newHeight : ((ImageView)ImageView.this).imageSize.height);
                ImageView.this.repaint(true);
            }
            if ((flags & 0xC0) != 0) {
                ImageView.this.loadComplete = false;
                ImageView.this.setImage(null);
                ImageView.this.getRenderContext().notifyImageLoadDone(ImageView.this.fetcher);
                return false;
            }
            if ((flags & 0x30) != 0) {
                if (x == 0 && y == 0) {
                    ImageView.this.gifDeltaBounds = null;
                    if (sizeChange) {
                        ImageView.this.imageSize = new Dimension(hasWidth ? newWidth : ((ImageView)ImageView.this).imageSize.width, hasHeight ? newHeight : ((ImageView)ImageView.this).imageSize.height);
                    }
                    ImageView.this.repaint(sizeChange);
                } else {
                    Container container;
                    ImageView.this.gifDeltaBounds = new Rectangle(x, y, newWidth, newHeight);
                    if (ImageView.this.lastPaint != null && (container = ImageView.this.getContainer()) != null) {
                        container.repaint(((ImageView)ImageView.this).lastPaint.x + x, ((ImageView)ImageView.this).lastPaint.y + y, newWidth, newHeight);
                    }
                }
                ImageView.this.getRenderContext().notifyImageLoadDone(ImageView.this.fetcher);
                ImageView.this.loadComplete = true;
            } else if ((flags & 8) != 0) {
                ImageView.this.loadComplete = false;
            }
            return (flags & 0x20) == 0;
        }

        @Override
        public boolean doAnimate() {
            return this.doAnimate;
        }
    }
}

