/*
 * Decompiled with CFR 0.152.
 */
package com.inet.html.utils;

import java.io.ByteArrayOutputStream;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.spec.PKCS8EncodedKeySpec;
import javax.annotation.SuppressFBWarnings;
import javax.crypto.Cipher;

public class JWebEngineLicense {
    static final byte[] PRIVATE_KEY = new byte[]{48, -126, 2, 117, 2, 1, 0, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 1, 5, 0, 4, -126, 2, 95, 48, -126, 2, 91, 2, 1, 0, 2, -127, -127, 0, -76, -25, 28, 113, -54, -13, 26, 110, -84, -111, -115, 119, 57, 83, -64, 61, -72, -17, 79, 25, 34, -45, 86, -105, 88, -31, 110, 36, 60, -51, 60, -124, 72, -22, 48, -94, 65, -18, 31, -42, 84, 111, 22, -17, -20, -37, 68, 87, -124, 105, -65, 61, 74, 43, -8, -55, -121, -107, 102, 9, 64, -5, -54, -73, 72, -71, -55, 33, -16, -24, 99, 5, 30, -119, 35, -67, 80, -125, -14, -3, 22, -75, 115, 30, 17, 13, 102, -117, -125, -27, -5, 38, 69, -62, 7, 61, 83, 72, -74, -101, 33, -125, 87, -94, 47, -4, 34, 83, -66, 34, -57, 5, -56, 119, 109, -73, 38, -63, -102, -51, -104, 91, 6, -91, 62, 73, -115, -119, 2, 3, 1, 0, 1, 2, -127, -128, 74, 74, -121, 17, -20, 72, -67, -40, 41, -94, 116, -72, 59, -96, -69, 88, 29, -76, -103, -123, 55, 26, 23, 123, 124, 18, -56, 10, -75, -75, -117, 94, -64, 26, -4, -14, 5, -91, 103, 9, -68, 15, 11, 26, 104, -24, -5, 61, -3, -80, -9, -54, -111, -59, 81, 28, 98, 67, -26, 109, 114, 116, 117, 32, -16, -71, 66, 103, 88, 47, -73, -25, -65, -4, 30, 28, 71, -117, -24, -5, 69, -92, -93, -9, -82, -8, 103, -13, 117, -94, -98, 40, 30, 123, 47, 4, 22, -94, -98, -69, 85, 30, -90, -117, 73, -114, -4, -2, -122, 72, -50, 64, 63, -100, 108, 58, -36, -73, -112, -85, 92, -82, 46, 113, -109, 4, 11, -95, 2, 65, 0, -1, 28, -86, 124, -29, -9, 63, 45, 31, -59, -115, 17, 9, 85, -8, -103, 57, 46, -84, -77, 126, 101, -37, 45, 24, -47, -41, -29, 44, 108, 86, -97, -36, -56, 65, 45, 93, -112, 77, -2, -75, 122, -23, -118, 74, 39, 17, -98, -39, -16, 106, -114, 10, 70, 49, 72, -21, -56, -86, 49, -126, 89, -48, 85, 2, 65, 0, -75, -120, 80, -12, -49, -118, -10, -81, -42, 101, -76, -41, 45, -18, -4, 110, -13, 59, -79, 90, -87, 6, 123, 114, -121, -75, 88, 104, 43, 120, -122, -35, -124, -66, 98, -21, 87, 97, -48, -91, 4, -70, 49, 46, -96, -113, -46, 39, -39, -41, -89, -101, 101, 81, -73, -25, -49, -30, 63, -41, -51, -100, -20, 101, 2, 64, 71, 5, 110, -3, 39, -27, -36, 67, -82, -75, -85, -87, 19, -123, 72, -103, 55, -113, 35, -21, 48, -124, 32, -71, 116, 80, 111, 30, -62, 110, 66, -53, 108, -122, -97, -122, -122, -90, -74, -33, -13, 28, 13, -54, 63, 12, -109, 94, 58, -28, 48, 117, -20, -84, 79, -22, 50, 34, 2, 39, -104, 87, 114, -91, 2, 64, 9, -86, -62, -76, -26, -64, 125, -74, -117, 114, 75, 25, 18, 103, 33, -90, 62, -23, -76, -34, 33, 22, 41, 72, -58, 21, 80, 41, -21, -10, -75, 39, -30, -61, -56, -68, -61, -96, 127, -35, -23, -52, -120, -123, -11, 34, -13, -116, 15, -69, -66, 63, 54, 60, 13, -47, 24, 110, -15, -5, 106, 5, -85, 73, 2, 64, 20, -22, 92, -73, -90, 23, 79, -59, 78, -48, 102, -37, -82, -18, -56, -31, 121, -62, 45, -39, -109, -121, -47, 33, -37, -30, 2, 1, 0, -44, -86, 48, 42, 9, 59, -101, -60, -3, 112, 47, 14, 122, -30, 9, -17, 86, 53, 1, -126, -67, -46, 97, -102, -10, 117, 15, -15, 57, 55, 15, -54, 12, -123, 29};
    private String license = null;
    private int checksum;
    private long timestamp;
    private int licenseType;
    private int majorVersion = -1;
    private String licenseE;

    public JWebEngineLicense(String license) {
        if (license != null) {
            String[] lines;
            String breakChar = "\n";
            if (license.indexOf(breakChar) < 0) {
                breakChar = "\r";
            }
            StringBuilder licenseBuilder = new StringBuilder();
            for (String line : lines = license.split(breakChar)) {
                if ((line = line.trim()).length() <= 0 || line.startsWith("#")) continue;
                licenseBuilder.append(line);
            }
            this.license = licenseBuilder.toString();
        }
        try {
            this.decodeLicense();
        }
        catch (Exception e) {
            this.checksum = -1;
            this.licenseType = -1;
            this.majorVersion = -1;
            this.licenseE = "Trial License";
        }
    }

    /*
     * WARNING - void declaration
     */
    @SuppressFBWarnings(value={"HARD_CODE_KEY"}, justification="Simple key for checksums")
    private void decodeLicense() throws Exception {
        int kIdx;
        if (this.license == null) {
            throw new IllegalArgumentException("License must be set");
        }
        this.license = this.license.replace("-", "");
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        PrivateKey key = keyFactory.generatePrivate(new PKCS8EncodedKeySpec(PRIVATE_KEY));
        Cipher cipher = Cipher.getInstance(key.getAlgorithm());
        cipher.init(2, key);
        ByteArrayOutputStream bytesLicenseKey = new ByteArrayOutputStream();
        for (kIdx = 0; kIdx < this.license.length(); kIdx += 2) {
            bytesLicenseKey.write((byte)Integer.parseInt(this.license.substring(kIdx, kIdx + 2), 16));
        }
        byte[] decryptedData = cipher.doFinal(bytesLicenseKey.toByteArray());
        this.license = new String(decryptedData);
        char[] step1 = new char[this.license.length()];
        int offset = this.license.length() / 2;
        for (int i = 0; i < this.license.length(); ++i) {
            if (i >= offset) {
                step1[i - offset] = this.license.charAt(i);
                continue;
            }
            step1[step1.length - offset + i] = this.license.charAt(i);
        }
        char[] flipped = new char[step1.length];
        for (int i = 0; i < step1.length; ++i) {
            if (i % 2 != 0) {
                flipped[i] = step1[i - 1];
                flipped[i - 1] = step1[i];
                continue;
            }
            if (i != step1.length - 1) continue;
            flipped[i] = step1[i];
        }
        String flippedStr = new String(flipped);
        ByteArrayOutputStream bytesflippedStr = new ByteArrayOutputStream();
        for (kIdx = 0; kIdx < this.license.length(); kIdx += 2) {
            bytesflippedStr.write((byte)Integer.parseInt(flippedStr.substring(kIdx, kIdx + 2), 16));
        }
        int localchecksum = 0;
        String theLicense = bytesflippedStr.toString("UTF8");
        if (theLicense.split("-").length < 5) {
            throw new IllegalArgumentException("License is invalid");
        }
        int lastIndexOf = theLicense.lastIndexOf("-");
        if (lastIndexOf != -1) {
            this.checksum = Integer.parseInt(theLicense.substring(lastIndexOf + 1));
            theLicense = theLicense.substring(0, lastIndexOf);
        }
        if ((lastIndexOf = theLicense.lastIndexOf("-")) != -1) {
            this.timestamp = Long.parseLong(theLicense.substring(lastIndexOf + 1));
            theLicense = theLicense.substring(0, lastIndexOf);
            for (char c : String.valueOf(this.timestamp).toCharArray()) {
                localchecksum += c;
            }
        }
        if ((lastIndexOf = theLicense.lastIndexOf("-")) != -1) {
            void var18_23;
            String doccountstr = theLicense.substring(lastIndexOf + 1);
            this.licenseType = "unlimited".equals(doccountstr) ? -1 : Integer.parseInt(doccountstr);
            char[] cArray = doccountstr.toCharArray();
            int n = cArray.length;
            boolean bl = false;
            while (var18_23 < n) {
                char ch2 = cArray[var18_23];
                localchecksum += ch2;
                ++var18_23;
            }
            theLicense = theLicense.substring(0, lastIndexOf);
        }
        if ((lastIndexOf = theLicense.lastIndexOf("-")) != -1) {
            this.majorVersion = Integer.parseInt(theLicense.substring(lastIndexOf + 1));
            theLicense = theLicense.substring(0, lastIndexOf);
            for (char c : String.valueOf(this.majorVersion).toCharArray()) {
                localchecksum += c;
            }
        }
        this.licenseE = theLicense;
        for (char c : this.licenseE.toCharArray()) {
            localchecksum += c;
        }
        if (localchecksum != this.checksum) {
            throw new IllegalArgumentException("Checksum is invalid.");
        }
    }

    public int getChecksum() {
        return this.checksum;
    }

    public int getLicenseType() {
        return this.licenseType;
    }

    public String getLicense() {
        return this.license;
    }

    public String getLicenseE() {
        return this.licenseE;
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public boolean isValid() {
        return this.majorVersion == 1;
    }
}

