/*
 * Decompiled with CFR 0.152.
 */
package com.inet.html.parser.converter;

import com.inet.html.InetHtmlDocument;
import com.inet.html.parser.converter.AttributeValue;
import com.inet.html.parser.converter.HtmlAttribute;
import java.util.Hashtable;

public class VerticalAlign
extends HtmlAttribute {
    public static final byte BASELINE = 1;
    public static final byte MIDDLE = 2;
    public static final byte SUB = 3;
    public static final byte SUPER = 4;
    public static final byte TEXT_TOP = 5;
    public static final byte TEXT_BOTTOM = 6;
    public static final byte TOP = 7;
    public static final byte BOTTOM = 8;
    private static final Hashtable<String, VerticalAlign> MAP = new Hashtable();
    static final VerticalAlign PARSER;
    private byte value;

    public static VerticalAlign getAlignValue(byte alignment) {
        for (VerticalAlign align : MAP.values()) {
            if (align.value != alignment) continue;
            return align;
        }
        return MAP.get("baseline");
    }

    private static void factory(String strValue, byte intValue) {
        VerticalAlign va = new VerticalAlign();
        va.setString(strValue);
        va.value = intValue;
        MAP.put(strValue, va);
    }

    public byte getAlign() {
        return this.value;
    }

    @Override
    AttributeValue parseHtmlValue(InetHtmlDocument doc, String value) {
        return value != null ? (AttributeValue)MAP.get(value.toLowerCase()) : null;
    }

    @Override
    protected AttributeValue parseCssValue(String valueStr, boolean important) {
        return MAP.get(valueStr.toLowerCase());
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof VerticalAlign)) {
            return false;
        }
        VerticalAlign other = (VerticalAlign)obj;
        if (this.isImportant() != other.isImportant()) {
            return false;
        }
        return this.value == other.value;
    }

    static {
        VerticalAlign.factory("baseline", (byte)1);
        VerticalAlign.factory("sub", (byte)3);
        VerticalAlign.factory("super", (byte)4);
        VerticalAlign.factory("top", (byte)7);
        VerticalAlign.factory("text-top", (byte)5);
        VerticalAlign.factory("middle", (byte)2);
        VerticalAlign.factory("bottom", (byte)8);
        VerticalAlign.factory("text-bottom", (byte)6);
        PARSER = MAP.get("baseline");
    }
}

