/*
 * Decompiled with CFR 0.152.
 */
package com.inet.html.parser.converter;

import com.inet.html.InetHtmlDocument;
import com.inet.html.parser.converter.AttributeValue;
import com.inet.html.parser.converter.HtmlAttribute;

public class TextAlign
extends HtmlAttribute {
    static final TextAlign PARSER = new TextAlign();
    public static final byte INITIAL = -1;
    private byte align;

    public TextAlign(byte alignConstant) {
        this.align = alignConstant;
        switch (alignConstant) {
            case 0: {
                this.setString("left");
                break;
            }
            case 2: {
                this.setString("right");
                break;
            }
            case 1: {
                this.setString("center");
                break;
            }
            case 3: {
                this.setString("justify");
                break;
            }
            case -1: {
                this.setString("initial");
            }
        }
    }

    private TextAlign() {
    }

    public byte getJustification() {
        return this.align;
    }

    @Override
    AttributeValue parseHtmlValue(InetHtmlDocument doc, String valueStr) {
        return this.parseCssValue(valueStr, false);
    }

    @Override
    protected AttributeValue parseCssValue(String valueStr, boolean important) {
        TextAlign textAlign = new TextAlign();
        if ("inherit".equals(valueStr = valueStr.toLowerCase())) {
            return AttributeValue.INHERIT;
        }
        if (valueStr.equals("left")) {
            textAlign.align = 0;
        } else if (valueStr.equals("center")) {
            textAlign.align = 1;
        } else if (valueStr.equals("right")) {
            textAlign.align = (byte)2;
        } else if (valueStr.equals("justify")) {
            textAlign.align = (byte)3;
        } else if (valueStr.equals("initial")) {
            textAlign.align = (byte)-1;
        } else {
            return null;
        }
        textAlign.setString(valueStr);
        return textAlign;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof TextAlign)) {
            return false;
        }
        TextAlign other = (TextAlign)obj;
        if (this.isImportant() != other.isImportant()) {
            return false;
        }
        return this.align == other.align;
    }
}

