/*
 * Decompiled with CFR 0.152.
 */
package com.inet.html.parser.converter;

import com.inet.html.InetHtmlDocument;
import com.inet.html.parser.converter.AttributeValue;
import com.inet.html.parser.converter.IntegerValue;
import com.inet.html.parser.converter.MultiAttributeValue;
import com.inet.html.utils.Logger;
import java.util.ArrayList;
import java.util.List;

public class MultiIntegerValue
extends MultiAttributeValue {
    private List<IntegerValue> values = new ArrayList<IntegerValue>();
    private boolean isBlank = true;
    static final MultiIntegerValue PARSER = new MultiIntegerValue();

    public List<IntegerValue> getValues() {
        return this.values;
    }

    @Override
    protected AttributeValue parseCssValue(String valueStr, boolean important) {
        IntegerValue intValue;
        String value = valueStr.toLowerCase().trim();
        MultiIntegerValue resolver = this;
        if (value.indexOf(" ") > 0) {
            String[] parts = value.split("[\\s\\t]+");
            resolver = (MultiIntegerValue)resolver.parseCssValue(parts[0], important);
            for (int i = 1; i < parts.length; ++i) {
                resolver.parseCssValue(parts[i], important);
            }
            return resolver;
        }
        if (this.isBlank) {
            resolver = new MultiIntegerValue();
        }
        if ((intValue = (IntegerValue)IntegerValue.PARSER.parseCssValue(valueStr, important)) == null) {
            return null;
        }
        resolver.values.add(intValue);
        resolver.isBlank = false;
        resolver.setString(value);
        return resolver;
    }

    @Override
    AttributeValue parseHtmlValue(InetHtmlDocument doc, String value) {
        IntegerValue intValue;
        String valueStr = value.toLowerCase().trim();
        MultiIntegerValue resolver = this;
        if (valueStr.indexOf(" ") > 0) {
            String[] parts = valueStr.split("[\\s\\t]+");
            if ((resolver = (MultiIntegerValue)resolver.parseCssValue(parts[0], false)) == null) {
                if (Logger.doesLog(2)) {
                    Logger.warning("Cannot parse '" + value + "' as a sequence of integer numbers");
                }
                return null;
            }
            for (int i = 1; i < parts.length; ++i) {
                resolver.parseCssValue(parts[i], false);
            }
            return resolver;
        }
        if (this.isBlank) {
            resolver = new MultiIntegerValue();
        }
        if ((intValue = (IntegerValue)IntegerValue.PARSER.parseCssValue(valueStr, false)) == null) {
            return null;
        }
        resolver.values.add(intValue);
        resolver.isBlank = false;
        resolver.setString(value);
        return resolver;
    }
}

