/*
 * Decompiled with CFR 0.152.
 */
package com.inet.html.parser.converter;

import com.inet.html.InetHtmlDocument;
import com.inet.html.parser.converter.AttributeValue;
import com.inet.html.parser.converter.HtmlAttribute;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParsePosition;

public class IntegerValue
extends HtmlAttribute {
    private int value;
    private ThreadLocal<NumberFormat> nf = new ThreadLocal();
    static final IntegerValue PARSER = new IntegerValue();

    public IntegerValue() {
    }

    public IntegerValue(int preset) {
        this.value = preset;
        this.setString(Integer.toString(preset));
    }

    private NumberFormat getFormatter() {
        NumberFormat localNf = this.nf.get();
        if (localNf == null) {
            localNf = DecimalFormat.getIntegerInstance();
            this.nf.set(localNf);
        }
        return localNf;
    }

    public int getInt() {
        return this.value;
    }

    @Override
    AttributeValue parseHtmlValue(InetHtmlDocument doc, String valueStr) {
        return this.parseCssValue(valueStr, false);
    }

    @Override
    protected AttributeValue parseCssValue(String valueStr, boolean important) {
        int val;
        block3: {
            try {
                if ("inherit".equalsIgnoreCase(valueStr)) {
                    return AttributeValue.INHERIT;
                }
                val = Integer.parseInt(valueStr);
            }
            catch (NumberFormatException e) {
                NumberFormat formatter = this.getFormatter();
                ParsePosition parsePosition = new ParsePosition(0);
                Number number = formatter.parse(valueStr, parsePosition);
                int n = val = number != null ? number.intValue() : 0;
                if (parsePosition.getIndex() != 0) break block3;
                return null;
            }
        }
        IntegerValue intValue = new IntegerValue();
        intValue.value = val;
        intValue.setString(valueStr);
        intValue.setImportant(important);
        return intValue;
    }

    public boolean equals(Object obj) {
        if (obj instanceof IntegerValue) {
            IntegerValue other = (IntegerValue)obj;
            if (other.getInt() != this.getInt()) {
                return false;
            }
            return other.isImportant() == this.isImportant();
        }
        return false;
    }
}

